/*
 * Decompiled with CFR 0.152.
 */
package moon.logprocess.db;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import moon.logprocess.db.TrackingPreparedStatementGroup;
import moon.logprocess.db.TrackingPreparedStatementGroupMobile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.util.StringUtil;

public abstract class PreparedStatementGroup {
    private static final Logger log = LoggerFactory.getLogger(PreparedStatementGroup.class);
    public static Hashtable PPS_GRP_MAP = new Hashtable();
    protected String GRP_NAME = null;

    public static void map_clean() {
        if (PPS_GRP_MAP.size() <= 0) {
            return;
        }
        Object obj = null;
        TrackingPreparedStatementGroup ppsGrp = null;
        TrackingPreparedStatementGroupMobile ppsMobileGrp = null;
        log.info("[USE: PPS_GRP_MAP SIZE]" + PPS_GRP_MAP.size());
        Enumeration e = PPS_GRP_MAP.elements();
        while (e.hasMoreElements()) {
            obj = e.nextElement();
            if (obj instanceof TrackingPreparedStatementGroup) {
                ppsGrp = obj;
                log.info("[CLOSE:ppsGrp NAME]" + ppsGrp.getGRP_NAME());
                ppsGrp.close();
                continue;
            }
            if (obj instanceof TrackingPreparedStatementGroupMobile) {
                ppsMobileGrp = obj;
                log.info("[CLOSE:ppsMobileGrp NAME]" + ppsMobileGrp.getGRP_NAME());
                ppsMobileGrp.close();
                continue;
            }
            ppsGrp.close();
        }
        PPS_GRP_MAP.clear();
    }

    public String getGRP_NAME() {
        return this.GRP_NAME;
    }

    public void setGRP_NAME(String grp_name) {
        this.GRP_NAME = grp_name;
    }

    public abstract void create(eMsConnection var1, String var2, String var3) throws Exception;

    public abstract void close();

    protected List setPptList(eMsConnection conn, List queryList, String list_table) throws Exception {
        ArrayList<eMsPreparedStatement> return_list = null;
        String query2 = "";
        eMsPreparedStatement pps = null;
        String open_table = StringUtil.replace(list_table, "LIST", "OPEN");
        String click_table = StringUtil.replace(list_table, "LIST", "CLICK");
        if (queryList != null && queryList.size() > 0) {
            return_list = new ArrayList<eMsPreparedStatement>();
            for (String query2 : queryList) {
                if (query2.trim().length() < 6) continue;
                query2 = this.ppsParseSQL(query2, "LIST_TABLE", list_table, "@{", "}");
                query2 = this.ppsParseSQL(query2, "OPEN_TABLE", open_table, "@{", "}");
                query2 = this.ppsParseSQL(query2, "CLICK_TABLE", click_table, "@{", "}");
                pps = conn.prepareStatement(query2, "${", "}");
                return_list.add(pps);
            }
        }
        return return_list;
    }

    protected List setPptListMobile(eMsConnection conn, List queryList, String list_table, String mobile_type) throws Exception {
        ArrayList<eMsPreparedStatement> return_list = null;
        String query2 = "";
        eMsPreparedStatement pps = null;
        String open_table = StringUtil.replace(list_table, "LIST", "OPEN");
        String click_table = StringUtil.replace(list_table, "LIST", "CLICK");
        if (queryList != null && queryList.size() > 0) {
            return_list = new ArrayList<eMsPreparedStatement>();
            for (String query2 : queryList) {
                if (query2.trim().length() < 6) continue;
                query2 = this.ppsParseSQL(query2, "LIST_TABLE", list_table, "@{", "}");
                query2 = this.ppsParseSQL(query2, "OPEN_TABLE", open_table + "_MOBILE", "@{", "}");
                query2 = this.ppsParseSQL(query2, "CLICK_TABLE", click_table, "@{", "}");
                query2 = this.ppsParseSQL(query2, "MOBILE_TYPE", mobile_type, "@{", "}");
                pps = conn.prepareStatement(query2, "${", "}");
                return_list.add(pps);
            }
        }
        return return_list;
    }

    public String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return PreparedStatementGroup.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }
}

