/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.basic;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.schedule.ScheduledMonitor;

public class ContentInfoManager
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(ContentInfoManager.class);
    public static final long CHECK_INTERVAL = 60000L;
    private static String INFO_SAVE_BASE_DIR = null;
    private static String INFO_SAVE_BASE_URL = null;
    private static String INFO_SAVE_FILE_EXT = null;
    private static String INFO_DTD_LOCATION = null;
    private static String INFO_XML_CHARSET = null;
    private static String INFO_XML_OUT_CHARSET = null;
    public static Object lock = new Object();
    private static Hashtable CONTENTE_INFO_HASH = new Hashtable();
    public static String name = "ContentInfoManager";
    private static ContentInfoManager INNER_MANAGER = null;
    private static final String KEY_ID_INFO = "AA";
    private static final String KEY_MAIL_BODY_INFO = "AI";
    private static final String KEY_MAPPING_HEADER_INFO = "AC";
    private static final String KEY_RETURN_PATH_INFO = "AD";
    private static final String KEY_SCHECULE_INFO = "AE";
    private static final String KEY_SEND_TYPE_INFO = "AH";
    private static final String KEY_FROM_EMAIL_INFO = "AIA";
    private static final String KEY_FROM_NAME_INFO = "AIB";
    private static final String KEY_SUBJECT_INFO = "AIC";
    private static final String KEY_TO_NAME_INFO = "AID";
    private static final String KEY_TO_EMAIL_INFO = "AIE";
    private static final String KEY_MESSAGE_INFO = "AIF";
    private static final String KEY_CHARSET_INFO = "AIFA";
    private static final String KEY_CONTENT_INFO = "AIFB";
    private static final String KEY_CONTENT_ENCODING_INFO = "AIFC";
    private static final String KEY_CONTENT_TYPE_INFO = "AIFD";
    private static final String KEY_MESSAGE_ID_INFO = "AIFE";
    private static final String BINARY_ATTACH_BODY_PARSER_CLASS_NAME = "mercury.contents.common.parser.BinaryAttachBodyParser";
    private static Class BINARY_ATTACH_BODY_PARSER_CLASS;

    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        INFO_SAVE_BASE_DIR = tmp.getProperty("base.dir");
        INFO_SAVE_BASE_URL = tmp.getProperty("base.url");
        INFO_SAVE_FILE_EXT = tmp.getProperty("file.ext", ".xml");
        INFO_DTD_LOCATION = tmp.getProperty("dtd.location");
        INFO_XML_CHARSET = tmp.getProperty("info.xml.charset", "euc-kr");
        INFO_XML_OUT_CHARSET = tmp.getProperty("info.out.charset", "KSC5601");
        if (INFO_SAVE_BASE_URL != null && !INFO_SAVE_BASE_URL.trim().equals("")) {
            String xmlDtd = FileElement.getFileBody(INFO_DTD_LOCATION);
            int i = INFO_DTD_LOCATION.lastIndexOf("/");
            int j = INFO_DTD_LOCATION.lastIndexOf("\\");
            String xmlDtdFileOnlyName = INFO_DTD_LOCATION.substring(Math.max(i, j) + 1);
            FileElement.toFile(INFO_SAVE_BASE_DIR + File.separator + xmlDtdFileOnlyName, xmlDtd);
            ContentInfo.setDTDLocation(INFO_SAVE_BASE_URL + "/" + xmlDtdFileOnlyName);
        } else {
            ContentInfo.setDTDLocation(INFO_DTD_LOCATION);
        }
        ContentInfo.setEncoding(INFO_XML_CHARSET);
        ContentInfo.setFileEncoding(INFO_XML_OUT_CHARSET);
        if (INFO_SAVE_BASE_DIR == null) {
            throw new RuntimeException("ContentBaseDirectory  parameter is not set!!!");
        }
    }

    public static synchronized void unload() throws Exception {
        INNER_MANAGER.close();
    }

    public static synchronized void destroy() throws Exception {
        CONTENTE_INFO_HASH.clear();
    }

    private ContentInfoManager() {
        super(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check() throws Exception {
        Enumeration ENUM = CONTENTE_INFO_HASH.elements();
        ContentInfo tmpInfo = null;
        if (log.isDebugEnabled()) {
            log.debug("ContentInfoManager Scan start...");
        }
        while (ENUM.hasMoreElements()) {
            tmpInfo = (ContentInfo)ENUM.nextElement();
            if (!tmpInfo.expire()) continue;
            Object object = lock;
            synchronized (object) {
                log.info(tmpInfo.getID() + " is removed from ContentManager");
                CONTENTE_INFO_HASH.remove(tmpInfo.getID());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("ContentInfoManager Scan end...");
        }
    }

    public static synchronized void registContentInfo(ContentInfo content) throws Exception {
        String store_file_name = FileElement.CheckSubDirectory(INFO_SAVE_BASE_DIR, content.getID().substring(0, 8)) + "/";
        String file_name = content.getID() + INFO_SAVE_FILE_EXT;
        File __OUT_FILE__ = new File(store_file_name + file_name);
        if (__OUT_FILE__.exists()) {
            __OUT_FILE__.delete();
        }
        ContentInfo.toXmlFile(store_file_name + file_name, content);
        if (log.isDebugEnabled()) {
            log.debug("REGIST ORG WRITE END");
        }
        ContentInfo returnValue = ContentInfo.XmlToContentInfo(store_file_name + file_name);
        if (log.isDebugEnabled()) {
            log.debug("REGIST ORG RECOVER END");
        }
        String path = store_file_name + file_name;
        if (INFO_SAVE_BASE_URL != null) {
            int i = INFO_SAVE_BASE_DIR.length();
            path = INFO_SAVE_BASE_URL + store_file_name.substring(i) + file_name;
        }
        returnValue.setContentInfoPath(path);
        ContentInfo.toXmlFile(store_file_name + "copy_" + file_name, returnValue);
        if (log.isDebugEnabled()) {
            log.debug("REGIST COPY WRITE END");
        }
        ContentInfoManager.putContentInfo(returnValue, false);
        log.info(content.getID() + " is registed in ContentManager");
    }

    public static synchronized void registTestContentInfo(ContentInfo content) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("REGIST ID => " + content.getID());
        }
        ContentInfoManager.putContentInfo(content, false);
        log.info(content.getID() + " is registed in ContentManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void putContentInfo(ContentInfo content, boolean check) throws Exception {
        content.execute();
        Object object = lock;
        synchronized (object) {
            if (check && CONTENTE_INFO_HASH.containsKey(content.getID())) {
                return;
            }
            CONTENTE_INFO_HASH.put(content.getID(), content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentInfo getContentInfo(String key) throws Exception {
        if (key == null || key.length() < 2) {
            log.error(INNER_MANAGER.getName(), (Object)"INVALID KEY[".concat(key).concat("]"));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(INNER_MANAGER.getName(), (Object)("REQUEST ID => " + key));
            log.debug(INNER_MANAGER.getName(), (Object)("CHECK ID => " + key));
        }
        if (CONTENTE_INFO_HASH.containsKey(key)) {
            if (log.isDebugEnabled()) {
                log.debug(INNER_MANAGER.getName(), (Object)("ALREADY CONTAIN => " + key));
            }
            ContentInfo returnValue = (ContentInfo)CONTENTE_INFO_HASH.get(key);
            returnValue.execute();
            return returnValue;
        }
        if (log.isDebugEnabled()) {
            log.debug(key + " is not in ContentManager so scan");
        }
        String scan_file_name = null;
        try {
            File f = new File(FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), key.substring(0, 8)));
            String[] fNames = f.list();
            for (int u = 0; u < fNames.length; ++u) {
                if (!fNames[u].startsWith(key + "_") && !fNames[u].startsWith(key + ".") || !fNames[u].endsWith(".xml")) continue;
                scan_file_name = FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), key.substring(0, 8)) + File.separator + fNames[u];
                break;
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return null;
        }
        if (scan_file_name == null) {
            return null;
        }
        File tmpFile = new File(scan_file_name);
        if (tmpFile.exists()) {
            ContentInfo returnValue = ContentInfo.XmlToContentInfo(scan_file_name);
            Object object = lock;
            synchronized (object) {
                CONTENTE_INFO_HASH.put(key, returnValue);
            }
            returnValue.execute();
            return returnValue;
        }
        log.info(INNER_MANAGER.getName(), (Object)"SCAN FILE NOT EXISTS SO RETURN NULL...");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkContentInfo(String key) {
        block13: {
            Object object = lock;
            synchronized (object) {
                if (CONTENTE_INFO_HASH.containsKey(key)) {
                    return true;
                }
            }
            try {
                String scan_file_name = null;
                boolean exist = false;
                try {
                    File f = new File(FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), key.substring(0, 8)));
                    String[] fNames = f.list();
                    for (int u = 0; u < fNames.length; ++u) {
                        if (!fNames[u].startsWith(key + "_") && !fNames[u].startsWith(key + ".") || !fNames[u].endsWith(".xml")) continue;
                        scan_file_name = FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), key.substring(0, 8)) + File.separator + fNames[u];
                        exist = true;
                        break;
                    }
                }
                catch (Exception ex) {
                    log.error(ex.getMessage());
                    return false;
                }
                if (!exist) break block13;
                ContentInfo returnValue = ContentInfo.XmlToContentInfo(scan_file_name);
                Object object2 = lock;
                synchronized (object2) {
                    CONTENTE_INFO_HASH.put(key, returnValue);
                }
                returnValue.execute();
                return true;
            }
            catch (Exception e) {
                log.error("ContentInfoManager", (Throwable)e);
            }
        }
        return false;
    }

    protected static ContentInfo HashtableToContentInfo(Hashtable src) throws Exception {
        ContentInfo returnValue = new ContentInfo();
        returnValue.setID((String)src.get(KEY_ID_INFO));
        returnValue.setMappingHeader((String)src.get(KEY_MAPPING_HEADER_INFO));
        returnValue.setReturnPath((String)src.get(KEY_RETURN_PATH_INFO));
        returnValue.setScheduleInfo((Properties)src.get(KEY_SCHECULE_INFO));
        returnValue.setSendType((String)src.get(KEY_SEND_TYPE_INFO));
        Hashtable MailBodyInfo = (Hashtable)src.get(KEY_MAIL_BODY_INFO);
        MailBody targetMailBody = (MailBody)InstanceFactory.getInstance("O", "00", (short)3);
        targetMailBody.setEtcHeader(eMsLocale.DEFAULT_HEADER);
        targetMailBody.setFromEmail((String)MailBodyInfo.get(KEY_FROM_EMAIL_INFO));
        targetMailBody.setFromName((String)MailBodyInfo.get(KEY_FROM_NAME_INFO));
        targetMailBody.setSubject((String)MailBodyInfo.get(KEY_SUBJECT_INFO));
        targetMailBody.setToName((String)MailBodyInfo.get(KEY_TO_NAME_INFO));
        targetMailBody.setToEmail((String)MailBodyInfo.get(KEY_TO_EMAIL_INFO));
        Vector Messages = (Vector)MailBodyInfo.get(KEY_MESSAGE_INFO);
        for (int i = 0; i < Messages.size(); ++i) {
            Hashtable tmpMessageInfo = (Hashtable)Messages.get(i);
            Message tmpMessage = (Message)InstanceFactory.getInstance("O", "00", (short)2);
            tmpMessage.setCharSet((String)tmpMessageInfo.get(KEY_CHARSET_INFO));
            tmpMessage.setContentEncoding((Short)tmpMessageInfo.get(KEY_CONTENT_ENCODING_INFO));
            tmpMessage.setContentType((Short)tmpMessageInfo.get(KEY_CONTENT_TYPE_INFO));
            tmpMessage.setMessageID((String)tmpMessageInfo.get(KEY_MESSAGE_ID_INFO));
            String[] tmpBodyParserInfo = (String[])tmpMessageInfo.get(KEY_CONTENT_INFO);
            BodyParser tmpBodyParser = null;
            tmpBodyParser = i > 0 ? (BodyParser)BINARY_ATTACH_BODY_PARSER_CLASS.newInstance() : (BodyParser)InstanceFactory.getInstance("O", "00", (short)1);
            tmpBodyParser.setContents(tmpBodyParserInfo[0], tmpBodyParserInfo[1], tmpBodyParserInfo[2]);
            tmpMessage.setContent(tmpBodyParser);
            targetMailBody.setMessage(tmpMessage);
        }
        returnValue.setMailBody(targetMailBody);
        return returnValue;
    }

    static {
        INNER_MANAGER = new ContentInfoManager();
        INNER_MANAGER.start();
        BINARY_ATTACH_BODY_PARSER_CLASS = null;
        try {
            BINARY_ATTACH_BODY_PARSER_CLASS = Class.forName(BINARY_ATTACH_BODY_PARSER_CLASS_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }
}

