/*
 * Decompiled with CFR 0.152.
 */
package mars.tracking.updator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.PreparedStatement;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

public class MobileDeviceUpdator {
    private static final Logger log = LoggerFactory.getLogger(MobileDeviceUpdator.class);
    protected static PreparedStatement EMS_P_STATEMENT = null;
    protected StringBuffer TMP_WORK_BUFFER = null;
    protected eMsStatement EMS_UPDATE_STATEMENT = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected String URL_PATH = null;
    protected String SOURCE_FILE = null;
    protected String DELIM = null;
    protected String LOCAL_FILE_PATH = null;

    public MobileDeviceUpdator(String url_path, String sourceFile, String delim, String localFilePath) {
        this.URL_PATH = url_path;
        this.SOURCE_FILE = sourceFile;
        this.DELIM = delim;
        this.LOCAL_FILE_PATH = localFilePath;
        try {
            this.EMS_CONNECTION = ConnectionPool.getConnection();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deviceListUpdate() throws Exception {
        URLConnection conn = null;
        InputStream in = null;
        InputStreamReader inr = null;
        BufferedReader br = null;
        BufferedWriter bwr = null;
        try {
            boolean firstFlag;
            String downUrl = this.URL_PATH + "/" + this.SOURCE_FILE;
            URL url = new URL(downUrl);
            conn = url.openConnection();
            in = conn.getInputStream();
            inr = new InputStreamReader(in, "utf-8");
            br = new BufferedReader(inr);
            String localFileVer = this.getLocalFileVersion();
            if (localFileVer == null) {
                firstFlag = true;
                localFileVer = "";
            } else {
                firstFlag = false;
            }
            String tempStr = null;
            int flagCnt = 0;
            bwr = new BufferedWriter(new FileWriter(this.LOCAL_FILE_PATH));
            String m_sQUERY_DELETE_MOBILE_DEVICE_LIST = SqlManager.getQuery("MobileDevice", "m_sQUERY_DELETE_MOBILE_DEVICE_LIST");
            String m_sQUERY_INSERT_MOBILE_DEVICE_LIST = SqlManager.getQuery("MobileDevice", "m_sQUERY_INSERT_MOBILE_DEVICE_LIST");
            this.EMS_UPDATE_STATEMENT = this.EMS_CONNECTION.createStatement();
            this.TMP_WORK_BUFFER = new StringBuffer(512);
            while ((tempStr = br.readLine()) != null) {
                if (flagCnt == 0 && localFileVer.equals(tempStr)) {
                    log.debug("\ub85c\uceec\ubc84\uc804\uacfc CS\uc11c\ubc84\uc758 \ubc84\uc804\uc774 \uac19\uc73c\ubbc0\ub85c \uc5c5\ub370\uc774\ub4dc\ub97c \uc9c4\ud589\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                    break;
                }
                if (flagCnt == 0) {
                    EMS_P_STATEMENT = this.EMS_CONNECTION.prepareStatement(m_sQUERY_DELETE_MOBILE_DEVICE_LIST);
                    EMS_P_STATEMENT.executeUpdate();
                }
                bwr.write(tempStr);
                bwr.newLine();
                if (flagCnt > 0) {
                    String[] list = StringUtil.split(tempStr, this.DELIM);
                    Properties obj = new Properties();
                    obj.setProperty("NUM", list[0]);
                    obj.setProperty("COMPANY", list[1]);
                    obj.setProperty("PLATFORM", list[2]);
                    obj.setProperty("MODEL_TYPE", list[3]);
                    obj.setProperty("MODEL_NAME_KO", list[4]);
                    obj.setProperty("MODEL_NAME_EN", list[5]);
                    obj.setProperty("KEYWORD", list[6]);
                    this.executeUpdate(m_sQUERY_INSERT_MOBILE_DEVICE_LIST, obj);
                }
                ++flagCnt;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (inr != null) {
                    inr.close();
                }
                if (br != null) {
                    br.close();
                }
                if (bwr != null) {
                    bwr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalFileVersion() {
        BufferedReader br = null;
        String returnStr = "";
        try {
            br = new BufferedReader(new FileReader(this.LOCAL_FILE_PATH));
            returnStr = br.readLine();
            if (returnStr == null) {
                returnStr = "no version";
            }
        }
        catch (FileNotFoundException fe) {
            returnStr = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
        }
        return returnStr;
    }

    protected int executeUpdate(String query, Object obj) throws Exception {
        this.TMP_WORK_BUFFER.setLength(0);
        StringConvertUtil.ConvertString(this.TMP_WORK_BUFFER, query, obj, "${", "}", true, false);
        if (log.isDebugEnabled()) {
            log.debug("original=>[" + query + "]");
        }
        if (log.isDebugEnabled()) {
            log.debug("exec=>" + this.TMP_WORK_BUFFER.toString());
        }
        return this.EMS_UPDATE_STATEMENT.executeUpdate(this.TMP_WORK_BUFFER.toString());
    }
}

