/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.send.task;

import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.CommonColumn;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import jupiter.mass.send.basic.SendStopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.panopticon.filter.RejectFilter;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.convert.StringConvert;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;
import venus.spool.common.task.SpoolControlTask;

public class SmsPersonalResendTask
extends CommonStepMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(SmsPersonalResendTask.class);
    private static final String ENC_YN = eMsSystem.getProperty("member.info.encrypt.yn", "N");
    private static final String ENC_KEY = eMsSystem.getProperty("member.info.encrypt.key", "");
    private static String QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = null;
    private static String QUERY_UPDATE_LIST_STATE_QUERY = null;
    private static String QUERY_SELECT_LIST_LOAD_QUERY = null;
    private static String QUERY_SELECT_RESEND_TABLE_INFO = null;
    private static String instance_QUERY_TARGET_TABLE_INFO = null;
    private static String QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO = null;
    private static String QUERY_CHECK_SMS_TYPE = null;
    public ArrayList SPOOLINFO_LIST = new ArrayList();
    private Properties PROP = null;

    public SmsPersonalResendTask() throws Exception {
        super((short)2, 1L);
        this.setName("SmsPersonalResendTask");
        this.setTaskID("SmsPersonalResendTask");
        if (log.isDebugEnabled()) {
            log.debug("PERSONAL RESEND Instance Create...");
        }
    }

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        if (log.isDebugEnabled()) {
            log.debug("PERSONAL RESEND INIT...");
        }
    }

    @Override
    public void setTaskProperty(Properties prop) {
    }

    @Override
    public void doErrorProcess(Throwable thr) {
    }

    @Override
    protected void execute_ListMake() throws Exception {
    }

    @Override
    protected void execute_ContentLoad() throws Exception {
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        this.WORK_FILE_ID = "personal_resend_".concat(Cal.getSerialDate());
        this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
        this.SPOOL_ANALYZER.setStep(0);
        if (log.isDebugEnabled()) {
            log.debug("REAL TIME Instance Initiate...");
        }
    }

    @Override
    public void release_Resource() {
        super.release_Resource();
    }

    @Override
    protected void updateTaskState(String __TYPE__, String __STATE__, String __STATE_MSG__) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_ListLoad() throws Exception {
        this.SPOOLINFO_LIST.clear();
        SpoolInfo spInfo = null;
        Vector v = null;
        eMsConnection conn = null;
        eMsStatement __EMS_EXEC_STATEMENT__ = null;
        eMsResultSet rs = null;
        String sPostId = "";
        try {
            conn = ConnectionPool.getConnection();
            __EMS_EXEC_STATEMENT__ = conn.createStatement();
            rs = __EMS_EXEC_STATEMENT__.executeQuery(QUERY_SELECT_PERSONAL_RESEND_WORK_INFO);
            this.PROP = new Properties();
            while (rs.next()) {
                this.PROP.clear();
                rs.putToMap(this.PROP, false);
                this.PROP.setProperty("MAPPINGHEADER", SpoolInfoManager.getSpoolInfo(this.PROP.getProperty("POST_ID")).getMappingHeader());
                SpoolControlTask targetTask = (SpoolControlTask)InstanceFactory.getInstance(this.PROP, (short)7);
                targetTask.setTaskProperty(this.PROP);
                targetTask.internal_execute();
                spInfo = targetTask.getSpoolInfo();
                SpoolInfoManager.registSpoolInfo(spInfo, spInfo.getID() + "_" + spInfo.getSendState() + Cal.getSerialDate());
                v = spInfo.getSpoolFilesInfo();
                if (v != null && v.size() > 0) {
                    this.SPOOLINFO_LIST.add(spInfo);
                }
                try {
                    this.wait(1000L);
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            e.printStackTrace();
            try {
                Properties oProp = new Properties();
                oProp.setProperty("POST_ID", sPostId);
                if (log.isDebugEnabled()) {
                    log.debug("QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO : " + QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO);
                    log.debug("oProp : " + oProp);
                    log.debug("__EMS_EXEC_STATEMENT__ :  " + __EMS_EXEC_STATEMENT__);
                }
                __EMS_EXEC_STATEMENT__.executeUpdate(StringConvertUtil.ConvertString(QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO, oProp, "${", "}", false, false));
            }
            catch (Exception e2) {
                log.error(this.getName(), (Throwable)e2);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            __EMS_EXEC_STATEMENT__.close();
            conn.recycle();
        }
    }

    @Override
    protected void execute_Startup() throws Exception {
    }

    @Override
    protected void execute_Finish() throws Exception {
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
        if (this.SPOOLINFO_LIST == null) {
            log.debug(" No Real Data.... So Skip ");
        }
        for (SpoolInfo this.mailSpoolInfo : this.SPOOLINFO_LIST) {
            if (this.mailSpoolInfo != null) {
                this.SPOOL_POPPER = Popper.getInstance();
                if (this.mailSpoolInfo.getSpoolFilesInfo().isEmpty()) {
                    log.debug("No Real Data.... So Skip");
                    return;
                }
                try {
                    this.SPOOL_POPPER.setTaskProp(this.PROP);
                    this.SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
                }
                catch (Exception ex) {
                    log.error("spool popper error", (Throwable)ex);
                }
            } else {
                log.debug("SMS SPOOL INFO IS NULL SO SKIP..");
                return;
            }
            if (this.SPOOL_POPPER == null) {
                log.error("No Real Data.... So Skip");
                return;
            }
            if (this.execute_StopCheck()) {
                throw new SendStopException(this.getName() + " receive stop signal");
            }
            RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.PROP);
            String nextSpool = null;
            String domain = null;
            int spoolPatchCount = 0;
            BufferedAgentPool pool = null;
            Object email_str = null;
            Object email_en = null;
            String ori_Spool = null;
            StringBuffer strBuffer = new StringBuffer(1024);
            boolean email_en_len = false;
            domain = this.PROP.getProperty("SMS_TYPE").toLowerCase();
            if ("".equals(domain)) {
                domain = this.getSmstype();
            }
            if (("SMS".equalsIgnoreCase(this.PROP.getProperty("SMS_TYPE")) || "LMS".equalsIgnoreCase(this.PROP.getProperty("SMS_TYPE"))) && this.PROP.getProperty("DONGBO_YN").equals("Y")) {
                domain = domain + "d";
            }
            while ((nextSpool = (String)this.SPOOL_POPPER.next()) != null) {
                if (nextSpool == null || nextSpool.length() < 1) continue;
                if (spoolPatchCount++ % this.instance_STOP_CHECK_RECYCLE == 0 && this.execute_StopCheck()) {
                    throw new SendStopException(this.getName() + " receive stop signal");
                }
                String phoneEn = null;
                String phoneStr = null;
                try {
                    ori_Spool = nextSpool;
                    if (ENC_YN.equals("Y")) {
                        phoneEn = this.getSecureSms(nextSpool);
                        phoneStr = !ChannelType.PUSH.getCode().equals(this.TASK_PROPERTY.getProperty(CommonColumn.CHANNEL_TYPE.getCode())) ? (ENC_KEY.equals("") ? CryptoUtil.decrypt(phoneEn, "TELNO_ENCR") : CryptoUtil.decrypt(phoneEn, "TELNO_ENCR", ENC_KEY)) : phoneEn;
                        strBuffer.setLength(0);
                        strBuffer.append(phoneEn).append("<TMS_DECRYPT>").append(phoneStr).append(nextSpool.substring(phoneEn.length()));
                        nextSpool = strBuffer.toString();
                    }
                    if (domain == null) {
                        this.processSyntaxErrorSpool(nextSpool);
                        continue;
                    }
                    if (instanceRejectFilter != null) {
                        this.SPOOL_ANALYZER.parse(nextSpool);
                        if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) continue;
                        nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
                    }
                    pool = this.getBufferedObjectPool(domain);
                    pool.registSpool(domain, nextSpool);
                }
                catch (OutOfMemoryError outError) {
                    log.error("OOM error", (Throwable)outError);
                    System.gc();
                    try {
                        Thread.sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        SpoolingManager.registSpool(ori_Spool);
                    }
                    catch (Exception ignore) {
                    }
                }
                catch (Throwable err) {
                    log.error("error", err);
                    ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("EXEC BufferedAgentPool.flushAll()");
            }
            BufferedAgentPool.flushAll();
            if (log.isDebugEnabled()) {
                log.debug("EXEC execute_ListSend [OK]");
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception ex_sub) {}
        }
        BufferedAgentPool.flushAll();
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("single", domain);
    }

    private String getSmstype() throws Exception {
        eMsConnection emsConnection = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            StringBuffer buffer = new StringBuffer(256);
            StringConvert.ConvertStringUseMap(buffer, QUERY_CHECK_SMS_TYPE, this.PROP, "${", "}", false, true);
            Properties m = new Properties();
            emsConnection.putSingleResultToMap(buffer.toString(), m);
            String string = m.getProperty("SMS_TYPE");
            return string;
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw new Exception(e);
        }
        finally {
            emsConnection.recycle();
        }
    }

    static {
        try {
            QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_PERSONAL_RESEND_WORK_INFO");
            QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_LIST_STATE_QUERY");
            QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_LIST_LOAD_QUERY");
            QUERY_SELECT_RESEND_TABLE_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_RESEND_TABLE_INFO");
            QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO");
            QUERY_CHECK_SMS_TYPE = SqlManager.getQuery("COMMON", "QUERY_CHECK_SMS_TYPE");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

