/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import com.humuson.tms.constrants.ChannelType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;
import pluto.util.convert.StringConvert;

public class UpdatorCheckTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(UpdatorCheckTask.class);
    private static final String _USE_OTHER_DB_ = "use.other.db";
    private static String MAX_THREAD_SIZE = "10";
    private static String ONE_THREAD_CNT = "1000";
    private static String channelType;
    private static String UPDATE_CLASS_NAME;
    private static String querySelectListTableName;
    private static String queryListSelectTargetRange;
    protected eMsConnection emsConnection = null;
    protected eMsStatement selectSearchStatement = null;
    private static boolean isUseOtherDb;
    private static ConnectInfo moduleConnectionInformation;

    public UpdatorCheckTask() {
        super((short)2);
        this.setName("UpdatorCheckTask_at_".concat(Cal.getSerialDate()));
        this.setTaskID("UpdatorCheckTask");
    }

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        ONE_THREAD_CNT = prop.getProperty("one.thread.cnt", "1000");
        MAX_THREAD_SIZE = prop.getProperty("max.thread.size", "10");
        channelType = prop.getProperty("channel.type", "");
        UPDATE_CLASS_NAME = prop.getProperty("update.class.name", "");
        isUseOtherDb = Boolean.parseBoolean(prop.getProperty(_USE_OTHER_DB_, "false"));
        if (channelType.equals(ChannelType.SMS.getCode())) {
            moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
            moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("sms.db.url"));
            moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("sms.db.id"));
            moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
            moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
            moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
            moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
            moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
        } else if (channelType.equals(ChannelType.KAKAO.getCode())) {
            querySelectListTableName = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_KAKAO_LIST_TABLE");
            moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
            moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
            moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
            moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
            moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
            moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
            moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
            moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
        } else {
            moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("other.db.driver"));
            moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("other.db.url"));
            moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("other.db.id"));
            moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("other.db.pass"));
            moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("other.db.init"));
            moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("other.db.base.charset"));
            moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("other.db.out.charset"));
            moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("other.db.in.charset"));
        }
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("UpdatorCheckTask_at_".concat(Cal.getSerialDate()));
        log.info("UpdatorCheckTask_START");
        this.emsConnection = isUseOtherDb ? ConnectionPool.getConnection(moduleConnectionInformation) : ConnectionPool.getConnection();
        try {
            this.selectSearchStatement = this.emsConnection.createStatement();
        }
        catch (Exception e) {
            this.emsConnection = ConnectionPool.getConnection();
            this.selectSearchStatement = this.emsConnection.createStatement();
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), (Object)" Request Connection Error");
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        if (this.emsConnection != null) {
            this.emsConnection.recycleStatement(this.selectSearchStatement);
            this.emsConnection.recycle();
        }
    }

    @Override
    public void execute() throws Exception {
        if (querySelectListTableName.isEmpty() || queryListSelectTargetRange.isEmpty()) {
            return;
        }
        ArrayList<String> listTables = new ArrayList<String>();
        Properties result = new Properties();
        eMsResultSet rsListTableName = null;
        eMsResultSet rs = null;
        try {
            rsListTableName = this.selectSearchStatement.executeQuery(querySelectListTableName);
            if (rsListTableName.next()) {
                String listTableName1 = null;
                String listTableName2 = null;
                if ("KA".equalsIgnoreCase(channelType)) {
                    listTableName1 = rsListTableName.getString("LIST_TABLE1") == null ? "" : rsListTableName.getString("LIST_TABLE1");
                    listTableName2 = rsListTableName.getString("LIST_TABLE2") == null ? "" : rsListTableName.getString("LIST_TABLE2");
                } else {
                    listTableName1 = rsListTableName.getString("SMS_LIST_TABLE1") == null ? "" : rsListTableName.getString("SMS_LIST_TABLE1");
                    String string = listTableName2 = rsListTableName.getString("SMS_LIST_TABLE2") == null ? "" : rsListTableName.getString("SMS_LIST_TABLE2");
                }
                if (listTableName1.isEmpty() && listTableName2.isEmpty()) {
                    return;
                }
                if (listTableName1.equals(listTableName2)) {
                    listTables.add(listTableName1);
                } else {
                    listTables.add(listTableName1);
                    listTables.add(listTableName2);
                }
            }
            if (listTables.isEmpty()) {
                log.debug("LIST TABLE NAME is empty.");
                return;
            }
            for (String listTableName : listTables) {
                StringBuffer buffer = new StringBuffer();
                StringConvert.ConvertString(buffer, queryListSelectTargetRange, "${SMS_LIST_TABLE}", listTableName);
                log.debug("QUERY_SELECT_TARGET_RANGE query: {}", (Object)buffer.toString());
                rs = this.selectSearchStatement.executeQuery(buffer.toString());
                if (rs.next()) {
                    rs.putToMap(result, false);
                }
                if (result.isEmpty()) {
                    log.debug("Get Target Range Result is empty.");
                    continue;
                }
                int totalCount = Integer.parseInt(result.getProperty("TO_CNT", "0"));
                if (totalCount < 1) {
                    log.debug("Get Target Range Result is zero.");
                    continue;
                }
                Map<String, Properties> executions = this.getThreadInfo(result.getProperty("MIN_ID", "0"), result.getProperty("MAX_ID", "0"));
                if (executions.isEmpty()) {
                    log.debug("{} Update Execute Information is null.", (Object)this.getName());
                    continue;
                }
                for (Map.Entry<String, Properties> exec : executions.entrySet()) {
                    String key = exec.getKey();
                    Properties value = exec.getValue();
                    value.setProperty("SMS_LIST_TABLE", listTableName);
                    value.setProperty(_USE_OTHER_DB_, String.valueOf(isUseOtherDb));
                    log.debug("{} execute_createTask... KEY: {}, VALUE: {}", new Object[]{this.getName(), key, value});
                    try {
                        this.execute_createTask(value);
                    }
                    catch (Exception e) {
                        log.error("[ERROR] execute_createTask...", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("[ERROR] Get Target Range.", (Throwable)e);
            throw e;
        }
        finally {
            if (rsListTableName != null) {
                rsListTableName.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        log.info("{} START is execute execute_createTask method...[OK]", (Object)this.getName());
    }

    private synchronized void execute_createTask(Properties info) throws Exception {
        try {
            Task make_info = (Task)this.getInstance(UPDATE_CLASS_NAME);
            make_info.setTaskProperty(info);
            TaskManager.executeTask(make_info);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        catch (AlreadyRegistTaskException e) {
            log.info("AlreadyRegistTaskException is skip {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
        }
    }

    private Object getInstance(String className) throws Exception {
        return Class.forName(className).newInstance();
    }

    private Map<String, Properties> getThreadInfo(String min, String max) throws Exception {
        int processCountPerThread = Integer.parseInt(ONE_THREAD_CNT);
        int processThreadCount = 0;
        int maxProcessThreadCount = Integer.parseInt(MAX_THREAD_SIZE);
        long maxSeq = Long.parseLong(max);
        long minSeq = Long.parseLong(min);
        int range = (int)(maxSeq - minSeq);
        HashMap<String, Properties> selectInfo = new HashMap<String, Properties>();
        int remain = range;
        processThreadCount = this.divideCeil(remain, processCountPerThread);
        if (processThreadCount > maxProcessThreadCount) {
            processThreadCount = maxProcessThreadCount;
            processCountPerThread = this.divideCeil(remain, processThreadCount);
        }
        log.debug("{}... processCountPerThread: {}", (Object)this.getName(), (Object)processCountPerThread);
        log.debug("{}... processThreadCount: {}", (Object)this.getName(), (Object)processThreadCount);
        if (processThreadCount == 1 || maxSeq == minSeq) {
            Properties processInfo = new Properties();
            processInfo.setProperty("MAX_ID", Long.toString(maxSeq));
            processInfo.setProperty("MIN_ID", Long.toString(minSeq));
            processInfo.setProperty("THREAD_ID", "1");
            selectInfo.put("1", processInfo);
        } else {
            long maxVal = 0L;
            long minVal = 0L;
            for (int i = 0; i < processThreadCount; ++i) {
                Properties processInfo = new Properties();
                maxVal = maxSeq - (long)(processCountPerThread * i);
                minVal = i + 1 == processThreadCount ? minSeq : maxVal - (long)processCountPerThread;
                System.out.println("[maxVal " + i + "] = " + maxVal);
                System.out.println("[minVal " + i + "] = " + minVal);
                log.debug("{}... Min Value: {}", (Object)this.getName(), (Object)minVal);
                log.debug("{}... Max Value: {}", (Object)this.getName(), (Object)maxVal);
                processInfo.setProperty("MAX_ID", Long.toString(maxVal));
                processInfo.setProperty("MIN_ID", Long.toString(minVal));
                processInfo.setProperty("THREAD_ID", Integer.toString(i));
                selectInfo.put(Integer.toString(i), processInfo);
            }
        }
        return selectInfo;
    }

    private int divideCeil(int ramin, int processCount) {
        int val = 0;
        try {
            float leaves = ramin % processCount;
            val = leaves > 0.0f ? ramin / processCount + 1 : ramin / processCount;
        }
        catch (Exception e) {
            return 0;
        }
        return val;
    }

    public static void main(String[] args) throws Exception {
        UpdatorCheckTask test = new UpdatorCheckTask();
        System.out.println(test.getThreadInfo("1899999999997641", "1900000000000000"));
    }

    static {
        querySelectListTableName = null;
        queryListSelectTargetRange = null;
        isUseOtherDb = false;
        moduleConnectionInformation = new ConnectInfo();
        try {
            querySelectListTableName = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_SMS_LIST_TABLE");
            queryListSelectTargetRange = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_RANGE");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("ERROR static variable setting.", (Throwable)e);
            System.exit(1);
        }
    }
}

