/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import com.humuson.tms.constrants.CommonType;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jupiter.mass.log.updator.ScheduleTblBean;
import jupiter.mass.log.updator.SmsAutoUpdator;
import jupiter.mass.log.updator.SmsCampUpdator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class SmsUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(SmsUpdator.class);
    private eMsConnection SOURCE_CONNECTION = null;
    private eMsConnection moduleConnection = null;
    private eMsStatement TMS_SMS_SELECT_STMT = null;
    private eMsStatement MODULE_SMS_SELECT_STMT = null;
    private eMsStatement MODULE_SMS_UPDATE_STMT = null;
    private String QUERY_SELECT_TARGET_SMS_LIST_TABLE = null;
    private String QUERY_TARGET_SMS_RESULT_QUERY = null;
    private String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = null;
    private String THREAD_ID = null;
    private Hashtable<String, ScheduleTblBean> CAMP_SCHEDULE_PPT = new Hashtable();
    private Hashtable<String, ScheduleTblBean> AUTO_SCHEDULE_PPT = new Hashtable();
    private static ConnectInfo connectInfo = new ConnectInfo();

    public SmsUpdator() {
        this.QUERY_SELECT_TARGET_SMS_LIST_TABLE = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_SMS_LIST_TABLE");
        this.QUERY_TARGET_SMS_RESULT_QUERY = SqlManager.getQuery("COMMON_UPDATE", "QUERY_TARGET_SMS_RESULT_QUERY");
        this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO");
    }

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.setName("SmsUpdator");
        this.setTaskID("SmsUpdator_" + this.TASK_PROPERTY.getProperty("THREAD_ID"));
        this.THREAD_ID = this.TASK_PROPERTY.getProperty("THREAD_ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL SmsUpdator===> execute()");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("SmsUpdator CALL execute() ERROR", thw);
            thw.printStackTrace();
        }
        finally {
            this.releaseResource();
        }
    }

    protected void execute_init() throws Throwable {
        Boolean useOtherDb;
        if (log.isDebugEnabled()) {
            log.debug("CALL SmsUpdator===> execute_init()");
        }
        if ((useOtherDb = Boolean.valueOf(Boolean.parseBoolean(this.TASK_PROPERTY.getProperty("use.other.db", "false")))).booleanValue()) {
            this.moduleConnection = ConnectionPool.getConnection(connectInfo);
            this.MODULE_SMS_SELECT_STMT = this.moduleConnection.createStatement();
            this.MODULE_SMS_UPDATE_STMT = this.moduleConnection.createStatement();
        }
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        if (this.MODULE_SMS_SELECT_STMT == null) {
            this.MODULE_SMS_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
        }
        if (this.MODULE_SMS_UPDATE_STMT == null) {
            this.MODULE_SMS_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
        }
        this.CAMP_SCHEDULE_PPT.clear();
        this.AUTO_SCHEDULE_PPT.clear();
        this.TMS_SMS_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL SMSUpdator===> releaseResource()");
        }
        if (this.MODULE_SMS_SELECT_STMT != null) {
            this.MODULE_SMS_SELECT_STMT.close();
        }
        if (this.MODULE_SMS_UPDATE_STMT != null) {
            this.MODULE_SMS_UPDATE_STMT.close();
        }
        if (this.TMS_SMS_SELECT_STMT != null) {
            this.TMS_SMS_SELECT_STMT.close();
        }
        if (this.SOURCE_CONNECTION != null) {
            this.SOURCE_CONNECTION.close();
        }
        if (this.moduleConnection != null) {
            this.moduleConnection.close();
        }
    }

    protected void execute_main() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL SMSUpdator===> execute_main()");
        }
        this.update_process(this.TASK_PROPERTY.getProperty("SMS_LIST_TABLE", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        eMsResultSet moduleSmsResult = null;
        SmsAutoUpdator autoUpt = new SmsAutoUpdator();
        SmsCampUpdator campUpt = new SmsCampUpdator();
        Properties resultQueryProp = new Properties();
        resultQueryProp.setProperty("SMS_LIST_TABLE", list_table);
        resultQueryProp.setProperty("MAX_ID", this.TASK_PROPERTY.getProperty("MAX_ID"));
        resultQueryProp.setProperty("MIN_ID", this.TASK_PROPERTY.getProperty("MIN_ID"));
        try {
            moduleSmsResult = this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_TARGET_SMS_RESULT_QUERY, resultQueryProp, "${", "}");
            campUpt.init_con(list_table);
            autoUpt.init_con(list_table);
            while (moduleSmsResult.next()) {
                int failCnt;
                Properties smsSendResultValue = new Properties();
                smsSendResultValue.setProperty("SMS_LIST_TABLE", list_table);
                moduleSmsResult.putToMap(smsSendResultValue, false);
                String postId = smsSendResultValue.getProperty("POST_ID").trim();
                if (smsSendResultValue.getProperty("CHANNEL_TYPE").equals(CommonType.AUTO.getCode())) {
                    int failCnt2;
                    int posPostId = postId.indexOf("_");
                    if (posPostId < 0) continue;
                    String workDay = postId.substring(0, posPostId);
                    String seqNo = postId.substring(posPostId + 1);
                    smsSendResultValue.setProperty("WORKDAY", workDay);
                    smsSendResultValue.setProperty("SEQNO", seqNo);
                    String tempMemberId = smsSendResultValue.getProperty("MEMBER_ID").trim();
                    int posMemberId = tempMemberId.indexOf("_");
                    if (posMemberId < 0) continue;
                    String memberId = tempMemberId.substring(0, posMemberId);
                    String memberIdSeq = tempMemberId.substring(posMemberId + 1);
                    smsSendResultValue.put("M_ID", memberId);
                    smsSendResultValue.put("M_ID_SEQ", memberIdSeq);
                    try {
                        autoUpt.update(smsSendResultValue, list_table);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    ScheduleTblBean autoStBean = this.AUTO_SCHEDULE_PPT.get(postId);
                    if (autoStBean == null) {
                        autoStBean = new ScheduleTblBean(postId);
                        this.AUTO_SCHEDULE_PPT.put(postId, autoStBean);
                    }
                    if ((failCnt2 = Integer.parseInt(smsSendResultValue.getProperty("FAIL_CNT"))) > 0) {
                        autoStBean.addFailCnt();
                        autoStBean.addErrorCnt(smsSendResultValue.getProperty("ERROR_CODE"));
                    }
                    autoStBean.addPush();
                    continue;
                }
                try {
                    campUpt.update(smsSendResultValue, list_table);
                }
                catch (Exception e) {
                    continue;
                }
                ScheduleTblBean stBean = this.CAMP_SCHEDULE_PPT.get(postId);
                if (stBean == null) {
                    stBean = new ScheduleTblBean(postId);
                    this.CAMP_SCHEDULE_PPT.put(postId, stBean);
                }
                if ((failCnt = Integer.parseInt(smsSendResultValue.getProperty("FAIL_CNT"))) > 0) {
                    stBean.addFailCnt();
                    stBean.addErrorCnt(smsSendResultValue.getProperty("ERROR_CODE"));
                }
                stBean.addPush();
            }
            if (!this.CAMP_SCHEDULE_PPT.isEmpty()) {
                this.schdSummary(this.CAMP_SCHEDULE_PPT, CommonType.MASS.getCode());
            }
            if (!this.AUTO_SCHEDULE_PPT.isEmpty()) {
                this.schdSummary(this.AUTO_SCHEDULE_PPT, CommonType.AUTO.getCode());
            }
        }
        catch (Exception e) {
            log.error("[ERROR] SmsUpdator update_process()", (Throwable)e);
        }
        finally {
            if (moduleSmsResult != null) {
                moduleSmsResult.close();
            }
            campUpt.release();
            autoUpt.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schdSummary(Hashtable schdMap, String type) {
        ScheduleTblBean stBean = null;
        StringBuffer buff = new StringBuffer(512);
        int result = 0;
        try {
            Enumeration e = schdMap.elements();
            while (e.hasMoreElements()) {
                result = 0;
                stBean = (ScheduleTblBean)e.nextElement();
                buff.setLength(0);
                if (log.isDebugEnabled()) {
                    log.debug("[stBean content]\n\t" + stBean.toString());
                }
                if (type.equals("AUTO")) {
                    StringConvertUtil.ConvertString(buff, this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO, stBean.getElement(type), "${", "}", true, false);
                } else {
                    StringConvertUtil.ConvertString(buff, this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY, stBean.getElement(type), "${", "}", true, false);
                }
                if ((result = this.MODULE_SMS_UPDATE_STMT.executeUpdate(buff.toString())) >= 1) continue;
                log.debug("[SCHEDULE SUMMARY FAIL]:" + stBean.getName());
            }
        }
        catch (Exception e) {
        }
        finally {
            buff.setLength(0);
            buff = null;
            schdMap.clear();
        }
    }

    protected String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return SmsUpdator.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("SmsUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("SmsUpdator init error", thw);
    }

    protected String getMonthListTableName(String month, String type) {
        String string = month = month.length() == 1 ? "0" + month : month;
        if (type.equals("AUTO")) {
            return "TMS_AUTO_SEND_LIST_" + month;
        }
        return "TMS_CAMP_SEND_LIST_" + month;
    }

    static {
        connectInfo.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
        connectInfo.setDB_URL(eMsSystem.getProperty("sms.db.url"));
        connectInfo.setDB_UID(eMsSystem.getProperty("sms.db.id"));
        connectInfo.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
        connectInfo.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
        connectInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
        connectInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
        connectInfo.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
    }
}

