/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.Properties;
import jupiter.mass.log.updator.SmsUpdator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

public class SmsAutoUpdator
extends SmsUpdator {
    private static final Logger log = LoggerFactory.getLogger(SmsAutoUpdator.class);
    private static String AUTO_LIST_TABLE = "TMS_AUTO_SEND_LIST_";
    protected eMsConnection UPDATOR_CONNECTION = null;
    private eMsPreparedStatement SEND_LIST_PSTMT_01 = null;
    private eMsPreparedStatement SEND_LIST_PSTMT_02 = null;
    private eMsPreparedStatement SEND_LIST_PSTMT_03 = null;
    private eMsPreparedStatement SEND_LIST_PSTMT_04 = null;
    private eMsPreparedStatement SEND_LIST_PSTMT_05 = null;
    private eMsPreparedStatement SMS_QUE_LOG_PSTMT = null;
    private String UPDATE_TMS_SMS_LIST_N = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TMS_SMS_LIST_N");
    private String UPDATE_TMS_SMS_QUE_LOG = SqlManager.getQuery("COMMON_UPDATE", "UPDATE_TMS_SMS_QUE_LOG");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init_con(String queLogTable) throws Exception {
        String listTable = "";
        String query = this.UPDATE_TMS_SMS_LIST_N;
        try {
            this.UPDATOR_CONNECTION = ConnectionPool.getConnection();
            for (int i = 1; i <= 5; ++i) {
                listTable = this.getMonthListTableName(Integer.toString(i), "AUTO");
                query = this.ppsParseSQL(this.UPDATE_TMS_SMS_LIST_N, "LIST_TABLE", listTable, "@{", "}");
                if (i == 1) {
                    this.SEND_LIST_PSTMT_01 = this.UPDATOR_CONNECTION.prepareStatement(query, "${", "}");
                }
                if (i == 2) {
                    this.SEND_LIST_PSTMT_02 = this.UPDATOR_CONNECTION.prepareStatement(query, "${", "}");
                }
                if (i == 3) {
                    this.SEND_LIST_PSTMT_03 = this.UPDATOR_CONNECTION.prepareStatement(query, "${", "}");
                }
                if (i == 4) {
                    this.SEND_LIST_PSTMT_04 = this.UPDATOR_CONNECTION.prepareStatement(query, "${", "}");
                }
                if (i != 5) continue;
                this.SEND_LIST_PSTMT_05 = this.UPDATOR_CONNECTION.prepareStatement(query, "${", "}");
            }
            this.UPDATE_TMS_SMS_QUE_LOG = this.ppsParseSQL(this.UPDATE_TMS_SMS_QUE_LOG, "SMS_LIST_TABLE", queLogTable, "@{", "}");
            this.SMS_QUE_LOG_PSTMT = this.UPDATOR_CONNECTION.prepareStatement(this.UPDATE_TMS_SMS_QUE_LOG, "${", "}");
        }
        catch (Exception e) {
            log.error("sms que log update error", (Throwable)e);
            this.release();
        }
    }

    public void release() throws Exception {
        if (this.SEND_LIST_PSTMT_01 != null) {
            this.SEND_LIST_PSTMT_01.close();
        }
        if (this.SEND_LIST_PSTMT_02 != null) {
            this.SEND_LIST_PSTMT_02.close();
        }
        if (this.SEND_LIST_PSTMT_03 != null) {
            this.SEND_LIST_PSTMT_03.close();
        }
        if (this.SEND_LIST_PSTMT_04 != null) {
            this.SEND_LIST_PSTMT_04.close();
        }
        if (this.SEND_LIST_PSTMT_05 != null) {
            this.SEND_LIST_PSTMT_05.close();
        }
        if (this.SMS_QUE_LOG_PSTMT != null) {
            this.SMS_QUE_LOG_PSTMT.close();
        }
        if (this.UPDATOR_CONNECTION != null) {
            this.UPDATOR_CONNECTION.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Properties smsSendResultValue, String list_table) throws Exception {
        boolean testFlag = false;
        String postId = smsSendResultValue.getProperty("POST_ID");
        String memberId = smsSendResultValue.getProperty("MEMBER_ID");
        try {
            smsSendResultValue.setProperty("CHECK_FLAG", "Y");
            smsSendResultValue.setProperty("SMS_LIST_TABLE", list_table);
            postId = smsSendResultValue.getProperty("POST_ID");
            int posPostid = postId.indexOf("_");
            String workDay = postId.substring(0, posPostid);
            String seqNo = postId.substring(posPostid + 1);
            smsSendResultValue.setProperty("WORKDAY", workDay);
            smsSendResultValue.setProperty("SEQNO", seqNo);
            if (smsSendResultValue.getProperty("MEMBER_ID").indexOf("*") > 0) {
                int pos = smsSendResultValue.getProperty("MEMBER_ID").indexOf("*");
                String mId = smsSendResultValue.getProperty("MEMBER_ID").substring(0, pos);
                String workSeq = smsSendResultValue.getProperty("MEMBER_ID").substring(pos + 1);
                smsSendResultValue.setProperty("M_ID", mId);
                smsSendResultValue.setProperty("WORK_SEQ", workSeq);
            } else {
                int pos = memberId.indexOf("_");
                String mId = memberId.substring(0, pos);
                String mIdSeq = memberId.substring(pos + 1);
                smsSendResultValue.setProperty("M_ID", mId);
                smsSendResultValue.setProperty("M_ID_SEQ", mIdSeq);
                this.getPps(smsSendResultValue.getProperty("LIST_TABLE")).executeUpdate(smsSendResultValue);
            }
            this.SMS_QUE_LOG_PSTMT.executeUpdate(smsSendResultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("SmsAutoUpdator", (Object)"update", (Object)e);
            smsSendResultValue.setProperty("CHECK_FLAG", "F");
            this.SMS_QUE_LOG_PSTMT.executeUpdate(smsSendResultValue);
        }
    }

    public eMsPreparedStatement getPps(String listTable) {
        if (listTable.indexOf("01") > 0) {
            return this.SEND_LIST_PSTMT_01;
        }
        if (listTable.indexOf("02") > 0) {
            return this.SEND_LIST_PSTMT_02;
        }
        if (listTable.indexOf("03") > 0) {
            return this.SEND_LIST_PSTMT_03;
        }
        if (listTable.indexOf("04") > 0) {
            return this.SEND_LIST_PSTMT_04;
        }
        if (listTable.indexOf("05") > 0) {
            return this.SEND_LIST_PSTMT_05;
        }
        return null;
    }
}

