/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jupiter.mass.log.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class PushCampCountUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(PushCampCountUpdator.class);
    private static ConnectInfo TARGET_CONNECT_INFO = null;
    private eMsStatement TMS_PUSH_SELECT_STMT = null;
    private eMsStatement TMS_PUSH_SELECT_STMT2 = null;
    private eMsStatement TMS_PUSH_UPDATE_STMT = null;
    private eMsStatement TMS_PUSH_FLAG_STMT = null;
    private String SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = null;
    private String QUERY_TARGET_PUSH_POST_ID_QUERY = null;
    private String UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private String UPDATE_PUSH_CHECK_FLAG_QUERY = null;
    private String UPDATE_PUSH_CHECK_FLAG_FINAL = null;
    private String SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = null;
    private String QUERY_TARGET_PUSH_COUNT_POST_ID_QUERY = null;
    private String UPDATE_TMS_PUSH_LIST = null;
    private String UPDATE_TMS_CAMP_SEND_OPEN = null;
    private String UPDATE_TMS_CAMP_SEND_CLICK = null;

    public PushCampCountUpdator() {
        super((short)2, 2L);
        this.setName("PushCampCountUpdator");
        this.setTaskID("PushCampCountUpdator");
        this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = SqlManager.getQuery("MASS_UPDATE", "SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE");
        this.QUERY_TARGET_PUSH_POST_ID_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_TARGET_PUSH_POST_ID_QUERY");
        this.UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        this.UPDATE_PUSH_CHECK_FLAG_QUERY = SqlManager.getQuery("MASS_UPDATE", "UPDATE_PUSH_CHECK_FLAG_QUERY");
        this.SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY");
        this.QUERY_TARGET_PUSH_COUNT_POST_ID_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_TARGET_PUSH_COUNT_POST_ID_QUERY");
        this.UPDATE_PUSH_CHECK_FLAG_FINAL = SqlManager.getQuery("MASS_UPDATE", "UPDATE_PUSH_CHECK_FLAG_FINAL");
        this.UPDATE_TMS_PUSH_LIST = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_PUSH_LIST");
        this.UPDATE_TMS_CAMP_SEND_OPEN = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_CAMP_SEND_OPEN");
        this.UPDATE_TMS_CAMP_SEND_CLICK = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_CAMP_SEND_CLICK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushCampCountUpdator===> execute()");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("PushCampCountUpdator", (Object)"CALL execute() ERROR", (Object)thw);
            thw.printStackTrace();
        }
        finally {
            this.releaseResource();
        }
    }

    protected void execute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushCampCountUpdator===> execute_init()");
        }
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushCampCountUpdator===> releaseResource()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_main() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushCampCountUpdator===> execute_main()");
        }
        eMsResultSet pushListTableResult = null;
        Properties tValue = new Properties();
        eMsConnection SOURCE_CONNECTION = null;
        try {
            SOURCE_CONNECTION = ConnectionPool.getConnection();
            this.TMS_PUSH_SELECT_STMT = SOURCE_CONNECTION.createStatement();
            pushListTableResult = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
            while (pushListTableResult.next()) {
                if (pushListTableResult.getString("LIST_TABLE1").equals(pushListTableResult.getString("LIST_TABLE2"))) {
                    tValue.setProperty("LIST_TABLE", pushListTableResult.getString("LIST_TABLE1").toString());
                    continue;
                }
                pushListTableResult.putToMap(tValue, false);
            }
            if (pushListTableResult != null) {
                pushListTableResult.close();
            }
            Iterator<Object> iter = tValue.values().iterator();
            while (iter.hasNext()) {
                String pushListTable = iter.next().toString();
                if (!pushListTable.equals("") && !pushListTable.equals(null)) {
                    this.update_process(pushListTable);
                    continue;
                }
                log.debug("TARGET TABLE null ", (Object)this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
            }
        }
        catch (Exception e) {
            log.error("PushCampCountUpdator", (Object)"execute_main", (Object)e);
        }
        finally {
            if (SOURCE_CONNECTION != null) {
                SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
                SOURCE_CONNECTION.recycle();
            }
            if (pushListTableResult != null) {
                pushListTableResult.close();
                pushListTableResult = null;
            }
        }
    }

    public List fromResultSetToList(eMsResultSet rs, String tableName) throws Exception {
        ArrayList<Properties> pushResult = new ArrayList<Properties>();
        while (rs.next()) {
            Properties pushSendResultValue = new Properties();
            pushSendResultValue.setProperty("PUSH_LIST_TABLE", tableName);
            rs.putToMap(pushSendResultValue, false);
            pushResult.add(pushSendResultValue);
        }
        return pushResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        log.error("PushCampCountUpdator", (Object)"update_process", (Object)"=========================== CAMP UPDATE COUNT START ==============================");
        eMsResultSet PushPostIdResult = null;
        eMsResultSet eMsRs = null;
        eMsResultSet rs = null;
        Properties prePushSendResultValue = new Properties();
        eMsConnection SOURCE_CONNECTION = null;
        try {
            SOURCE_CONNECTION = ConnectionPool.getConnection();
            this.TMS_PUSH_SELECT_STMT = SOURCE_CONNECTION.createStatement();
            this.TMS_PUSH_SELECT_STMT2 = SOURCE_CONNECTION.createStatement();
            this.TMS_PUSH_UPDATE_STMT = SOURCE_CONNECTION.createStatement();
            this.TMS_PUSH_FLAG_STMT = SOURCE_CONNECTION.createStatement();
            prePushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
            eMsRs = this.TMS_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_COUNT_POST_ID_QUERY);
            List pushSendResult = this.fromResultSetToList(eMsRs, list_table);
            for (Properties pushPostIdValue : pushSendResult) {
                try {
                    log.error("CAMP POST_ID : " + pushPostIdValue.getProperty("POST_ID"));
                    rs = this.TMS_PUSH_SELECT_STMT2.executeQuery(this.SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY, pushPostIdValue, "${", "}");
                    Properties pushSendResultValue = new Properties();
                    if (!rs.next()) continue;
                    rs.putToMap(pushSendResultValue, false);
                    this.TMS_PUSH_UPDATE_STMT.executeUpdate(this.UPDATE_SCHEDULE_INFO_SUMMARY_QUERY, pushSendResultValue, "${", "}");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("PushCampCountUpdator", (Object)"update_process", (Object)e);
                }
            }
            log.error("PushCampCountUpdator", (Object)"update_process", (Object)"=========================== CAMP UPDATE COUNT END ==============================");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("PushCampCountUpdator", (Object)"update_process", (Object)e);
        }
        finally {
            if (SOURCE_CONNECTION != null) {
                SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
                SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT2);
                SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_UPDATE_STMT);
                SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_FLAG_STMT);
                SOURCE_CONNECTION.recycle();
            }
            if (PushPostIdResult != null) {
                PushPostIdResult.close();
                PushPostIdResult = null;
            }
            if (eMsRs != null) {
                eMsRs.close();
                eMsRs = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lastUpdate(ScheduleTblBean stBean, StringBuffer buff, String sql) throws SQLException {
        try {
            StringConvertUtil.ConvertString(buff, sql, stBean.getElement("MASS"), "${", "}", true, false);
            if (this.TMS_PUSH_UPDATE_STMT.executeUpdate(buff.toString()) < 1) {
                log.info("[SCHEDULE SUMMARY FAIL]:" + stBean.getName() + "_sql : " + sql);
            }
        }
        catch (Exception e) {
            log.error("last update error", (Throwable)e);
        }
        finally {
            buff.setLength(0);
        }
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("PushCampCountUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("PushCampCountUpdator", (Object)"init error", (Object)thw);
    }

    static {
        TARGET_CONNECT_INFO = new ConnectInfo();
        TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("push.db.driver"));
        TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("push.db.url"));
        TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("push.db.id"));
        TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("push.db.pass"));
        TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("push.db.init"));
        TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("push.db.base.charset"));
        TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("push.db.out.charset"));
        TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("push.db.in.charset"));
    }
}

