/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.common.bean.PlanBean;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringUtil;

public class PushAutoSendListUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(PushAutoSendListUpdator.class);
    private eMsPreparedStatement PSTMT = null;
    private eMsPreparedStatement OPEN_PSTMT = null;
    private eMsPreparedStatement CHECK_PSTMT = null;
    protected eMsConnection SOURCE_CONNECTION = null;
    private eMsStatement TMS_PUSH_SELECT_STMT = null;
    private String SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = null;
    private String QUERY_TARGET_PUSH_POST_ID_QUERY = null;
    private String UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private String UPDATE_PUSH_CHECK_FLAG_QUERY = null;
    private String SELECT_PUSH_SEND_QUE_LOG = null;
    private String UPDATE_PUSH_CHECK_FLAG_FINAL = null;
    private String SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = null;
    private String UPDATE_TMS_PUSH_LIST = null;
    private String UPDATE_TMS_AUTO_SEND_OPEN = null;
    private String UPDATE_TMS_AUTO_SEND_CLICK = null;
    private static eMsPreparedStatement PPS_SELECT_FLOW_DATA = null;
    private static eMsPreparedStatement PPS_INSERT_FLOW_DATA = null;
    private static String QUERY_SELECT_PLAN_INFO = SqlManager.getQuery("FLOW_PLAN", "QUERY_SELECT_PLAN_INFO");
    private static String QUERY_INSERT_FLOW_DATA = SqlManager.getQuery("FLOW_PLAN", "QUERY_INSERT_FLOW_DATA");

    public PushAutoSendListUpdator() {
        super((short)2, 2L);
        this.setName("PushAutoSendListUpdator");
        this.setTaskID("PushAutoSendListUpdator");
        this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = SqlManager.getQuery("AUTO_UPDATE", "SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE");
        this.QUERY_TARGET_PUSH_POST_ID_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_TARGET_PUSH_POST_ID_QUERY");
        this.UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        this.UPDATE_PUSH_CHECK_FLAG_QUERY = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_PUSH_CHECK_FLAG_QUERY");
        this.SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TARGET_PUSH_COUNT_SUMMARY_QUERY");
        this.UPDATE_PUSH_CHECK_FLAG_FINAL = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_PUSH_CHECK_FLAG_FINAL");
        this.UPDATE_TMS_PUSH_LIST = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TMS_PUSH_LIST");
        this.UPDATE_TMS_AUTO_SEND_OPEN = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TMS_AUTO_SEND_OPEN");
        this.UPDATE_TMS_AUTO_SEND_CLICK = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TMS_AUTO_SEND_CLICK");
        this.SELECT_PUSH_SEND_QUE_LOG = SqlManager.getQuery("AUTO_UPDATE", "SELECT_PUSH_SEND_QUE_LOG");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushAutoSendListUpdator===> execute()");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("PushAutoSendListUpdator", (Object)"CALL execute() ERROR", (Object)thw);
        }
        finally {
            this.releaseResource();
        }
    }

    protected void execute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushAutoSendListUpdator===> execute_init()");
        }
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        this.TMS_PUSH_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushAutoSendListUpdator===> releaseResource()");
        }
        if (PPS_SELECT_FLOW_DATA != null) {
            PPS_SELECT_FLOW_DATA.close();
            PPS_SELECT_FLOW_DATA = null;
        }
        if (PPS_INSERT_FLOW_DATA != null) {
            PPS_INSERT_FLOW_DATA.close();
            PPS_INSERT_FLOW_DATA = null;
        }
        if (this.SOURCE_CONNECTION != null) {
            this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
            this.SOURCE_CONNECTION.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_main() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushAutoSendListUpdator===> execute_main()");
        }
        eMsResultSet pushListTableResult = null;
        Properties tValue = new Properties();
        try {
            this.TMS_PUSH_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
            pushListTableResult = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
            while (pushListTableResult.next()) {
                if (pushListTableResult.getString("LIST_TABLE1").equals(pushListTableResult.getString("LIST_TABLE2"))) {
                    tValue.setProperty("LIST_TABLE", pushListTableResult.getString("LIST_TABLE1").toString());
                    continue;
                }
                pushListTableResult.putToMap(tValue, false);
            }
            if (pushListTableResult != null) {
                pushListTableResult.close();
            }
            Iterator<Object> iter = tValue.values().iterator();
            while (iter.hasNext()) {
                String pushListTable = iter.next().toString();
                if (!pushListTable.equals("") && !pushListTable.equals(null)) {
                    this.update_process(pushListTable);
                    continue;
                }
                log.debug("TARGET TABLE null ", (Object)this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
            }
        }
        catch (Exception e) {
            log.error("PushAutoSendListUpdator", (Object)"execute_main", (Object)e);
        }
        finally {
            if (pushListTableResult != null) {
                pushListTableResult.close();
                pushListTableResult = null;
            }
        }
    }

    public List fromResultSetToList(eMsResultSet rs, String tableName) throws Exception {
        ArrayList<Properties> pushResult = new ArrayList<Properties>();
        while (rs.next()) {
            Properties pushSendResultValue = new Properties();
            pushSendResultValue.setProperty("PUSH_LIST_TABLE", tableName);
            rs.putToMap(pushSendResultValue, false);
            pushResult.add(pushSendResultValue);
        }
        return pushResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        log.debug("PushAutoSendListUpdator", (Object)"update_process", (Object)"=========================== AUTO SEND LIST UPDATE START ==============================");
        eMsResultSet PushPostIdResult = null;
        eMsResultSet eMsRs = null;
        Properties prePushSendResultValue = new Properties();
        Object stBean = null;
        boolean result = false;
        boolean updateFlag = false;
        StringBuffer buff = new StringBuffer(512);
        try {
            prePushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
            this.SOURCE_CONNECTION.setAutoCommit(false);
            PushPostIdResult = this.TMS_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_POST_ID_QUERY, prePushSendResultValue, "${", "}");
            List pushPostIdList = this.fromResultSetToList(PushPostIdResult, list_table);
            if (pushPostIdList.size() <= 0) {
                return;
            }
            int cnt = 0;
            this.SOURCE_CONNECTION.setAutoCommit(false);
            for (Properties pushPostIdValue : pushPostIdList) {
                String post_id = pushPostIdValue.getProperty("POST_ID");
                String push_table = pushPostIdValue.getProperty("LIST_TABLE");
                pushPostIdValue.setProperty("PUSH_TABLE", push_table);
                this.UPDATE_TMS_PUSH_LIST = this.UPDATE_TMS_PUSH_LIST.replaceAll("\\$\\{PUSH_TABLE}", push_table);
                this.PSTMT = this.SOURCE_CONNECTION.prepareStatement(this.UPDATE_TMS_PUSH_LIST, "${", "}");
                this.OPEN_PSTMT = this.SOURCE_CONNECTION.prepareStatement(this.UPDATE_TMS_AUTO_SEND_OPEN, "${", "}");
                this.CHECK_PSTMT = this.SOURCE_CONNECTION.prepareStatement(this.UPDATE_PUSH_CHECK_FLAG_FINAL, "${", "}");
                try {
                    eMsRs = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_PUSH_SEND_QUE_LOG, pushPostIdValue, "${", "}");
                    int listCnt = 0;
                    int openCnt = 0;
                    while (eMsRs.next()) {
                        Properties p = new Properties();
                        eMsRs.putToMap(p, false);
                        listCnt += this.PSTMT.executeUpdateLong(p);
                        if (!p.getProperty("PUSHED_CNT", "0").equals("0")) {
                            p.setProperty("DATA_TYPE", "SEND");
                            try {
                                this.insertFlowPlanData(p);
                            }
                            catch (Exception e) {
                                log.error("PushAutoSendListUpdator", (Object)("POST_ID :" + post_id + " MEMBER_ID :" + p.getProperty("ORI_MEMBER_ID") + " ERROR MESSAGE : " + e.getMessage()));
                            }
                        }
                        if (!p.getProperty("OPEN_CNT", "0").equals("0")) {
                            p.setProperty("DATA_TYPE", "OPEN");
                            try {
                                this.insertFlowPlanData(p);
                            }
                            catch (Exception e) {
                                log.error("PushAutoSendListUpdator", (Object)("POST_ID :" + post_id + " MEMBER_ID :" + p.getProperty("ORI_MEMBER_ID") + " ERROR MESSAGE : " + e.getMessage()));
                            }
                        }
                        if (!p.getProperty("CLICK_CNT", "0").equals("0")) {
                            p.setProperty("DATA_TYPE", "CLICK");
                            this.insertFlowPlanData(p);
                        }
                        if (!p.getProperty("OPEN_CNT", "0").equals("0")) {
                            openCnt += this.OPEN_PSTMT.executeUpdateLong(p);
                        }
                        cnt += this.CHECK_PSTMT.executeUpdateLong(p);
                        if (listCnt % 5000 != 0) continue;
                        log.error("PushAutoSendListUpdator", (Object)("POST_ID :" + post_id + " TMS_PUSH_LIST :" + listCnt + " TMS_CAMP_SEND_OPEN :" + openCnt));
                        this.SOURCE_CONNECTION.commit();
                    }
                    log.error("PushAutoSendListUpdator", (Object)("POST_ID :" + post_id + " TMS_PUSH_LIST :" + listCnt + " TMS_AUTO_SEND_OPEN :" + openCnt));
                    this.SOURCE_CONNECTION.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("PushAutoSendListUpdator", (Object)"update_process", (Object)e);
                }
            }
            this.SOURCE_CONNECTION.commit();
            this.SOURCE_CONNECTION.setAutoCommit(true);
            log.debug("PushAutoSendListUpdator", (Object)"UPDATE_PUSH_CHECK_FLAG_QUERY", (Object)("CHECK_FLAG = '-' -> 'Y'  : " + cnt));
            log.debug("PushAutoSendListUpdator", (Object)"update_process", (Object)"=========================== AUTO SEND LIST UPDATE END ==============================");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("PushAutoSendListUpdator", (Object)"update_process", (Object)e);
        }
        finally {
            if (PushPostIdResult != null) {
                PushPostIdResult.close();
                PushPostIdResult = null;
            }
            if (eMsRs != null) {
                eMsRs.close();
                eMsRs = null;
            }
            if (this.PSTMT != null) {
                this.PSTMT.close();
                this.PSTMT = null;
            }
            if (this.OPEN_PSTMT != null) {
                this.OPEN_PSTMT.close();
                this.OPEN_PSTMT = null;
            }
            if (this.CHECK_PSTMT != null) {
                this.CHECK_PSTMT.close();
                this.CHECK_PSTMT = null;
            }
        }
    }

    protected String insertFlowPlanData(Object target) throws Exception {
        Properties propLogData = (Properties)target;
        String dataType = propLogData.getProperty("DATA_TYPE");
        boolean isResend = propLogData.getProperty("IS_RESEND", "false").equals("true");
        int failCnt = Integer.parseInt(propLogData.getProperty("FAIL_CNT"));
        String postId = propLogData.getProperty("POST_ID");
        String actType = "SKIP";
        if (dataType.equals("SEND")) {
            actType = failCnt > 0 ? "FAIL" : (isResend ? "SUCCESS_RETRY" : "SUCCESS_FIRST");
        } else if (dataType.equals("OPEN")) {
            actType = "OPEN";
        } else if (dataType.equals("CLICK")) {
            actType = "CLICK";
        } else {
            return "SKIP";
        }
        PlanBean bean = PlanBean.getPlanBean(postId);
        if (bean == null) {
            bean = new PlanBean();
            if (PPS_SELECT_FLOW_DATA == null) {
                PPS_SELECT_FLOW_DATA = this.SOURCE_CONNECTION.prepareStatement(QUERY_SELECT_PLAN_INFO, "${", "}");
            }
            eMsResultSet rsFlowData = PPS_SELECT_FLOW_DATA.executeQuery(propLogData);
            ArrayList<Properties> arrTarget = new ArrayList<Properties>();
            while (rsFlowData.next()) {
                Properties prop = new Properties();
                prop.setProperty("MSG_TYPE", rsFlowData.getString("MSG_TYPE"));
                prop.setProperty("MSG_TYPE_SEQ", rsFlowData.getString("MSG_TYPE_SEQ"));
                prop.setProperty("PLAN_DAY", rsFlowData.getString("PLAN_DAY"));
                prop.setProperty("PLAN_HOUR", rsFlowData.getString("PLAN_HOUR"));
                prop.setProperty("PLAN_STATUS", rsFlowData.getString("PLAN_STATUS"));
                arrTarget.add(prop);
            }
            bean.setPostId(postId);
            bean.setArrTarget(arrTarget);
            PlanBean.setPlanBean(bean);
        }
        if (!bean.isPlanYn()) {
            return "SKIP";
        }
        ArrayList<Properties> dataList = bean.getArrTarget();
        int dataCnt = dataList.size();
        String msgType = "";
        String msgTypeSeq = "";
        String planStatus = "";
        String planDay = "";
        String planHour = "";
        boolean actFlag = false;
        for (int i = 0; i < dataCnt; ++i) {
            int cnt_insert;
            Properties propPlanData = dataList.get(i);
            msgType = propPlanData.getProperty("MSG_TYPE");
            msgTypeSeq = propPlanData.getProperty("MSG_TYPE_SEQ");
            planStatus = propPlanData.getProperty("PLAN_STATUS");
            planDay = propPlanData.getProperty("PLAN_DAY");
            planHour = propPlanData.getProperty("PLAN_HOUR");
            if (log.isDebugEnabled()) {
                log.debug("[planStatus]" + planStatus + "[actType]" + actType);
            }
            if ("A".equals(planStatus)) {
                if (!"SUCCESS_FIRST".equals(actType) && !"FAIL".equals(actType)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[TARGET_AREA]<Type:ALL> SUCCESS_FIRST / FAIL");
                }
            } else if ("S".equals(planStatus)) {
                if (!"SUCCESS_FIRST".equals(actType) && !"SUCCESS_RETRY".equals(actType)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[TARGET_AREA]<Type:SUCCESS> SUCCESS_FIRST / SUCCESS_RETRY");
                }
            } else if ("F".equals(planStatus)) {
                if (!"FAIL".equals(actType)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[TARGET_AREA]<Type:FAIL> FAIL_FIRST");
                }
            } else if ("O".equals(planStatus)) {
                if (!"OPEN".equals(actType)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[TARGET_AREA]<Type:OPEN> OPEN");
                }
            } else {
                if (!"C".equals(planStatus) || !"CLICK".equals(actType)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[TARGET_AREA]<Type:CLICK> CLICK");
                }
            }
            propLogData.setProperty("MSG_TYPE", msgType);
            propLogData.setProperty("MSG_TYPE_SEQ", msgTypeSeq);
            propLogData.setProperty("PLAN_STATUS", planStatus);
            propLogData.setProperty("PLAN_DAY", StringUtil.isNull(planDay) ? "0" : planDay);
            propLogData.setProperty("PLAN_HOUR", StringUtil.isNull(planHour) ? "0" : planHour);
            if (PPS_INSERT_FLOW_DATA == null) {
                PPS_INSERT_FLOW_DATA = this.SOURCE_CONNECTION.prepareStatement(QUERY_INSERT_FLOW_DATA, "${", "}");
            }
            if ((cnt_insert = PPS_INSERT_FLOW_DATA.executeUpdate(propLogData)) != 1) {
                log.debug("[ERROR] insert fail <FLOW_DATA> " + propLogData.toString());
                continue;
            }
            actFlag = true;
        }
        if (!actFlag) {
            actType = "no Match";
        }
        return actType;
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("PushAutoSendListUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("PushAutoSendListUpdator", (Object)"init error", (Object)thw);
    }
}

