/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import jupiter.mass.log.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class LmsCampUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(LmsCampUpdator.class);
    private static ConnectInfo TARGET_CONNECT_INFO = null;
    private eMsConnection SOURCE_CONNECTION = null;
    private eMsConnection TARGET_CONNECTION = null;
    private eMsStatement TMS_SMS_SELECT_STMT = null;
    private eMsStatement TMS_SMS_UPDATE_STMT = null;
    private eMsStatement MODULE_SMS_SELECT_STMT = null;
    private eMsPreparedStatement MODULE_SMS_UPDATE_PSTMT = null;
    private String QUERY_SELECT_TARGET_SMS_LIST_TABLE = null;
    private String QUERY_TARGET_SMS_RESULT_QUERY = null;
    private String QUERY_UPDATE_MASS_RESULT_QUERY = null;
    private String QUERY_UPDATE_SMS_TRAN_FLAG_QUERY = null;
    private String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private String QUERY_INSERT_SEND_OPTIMIZ = null;
    private static Hashtable CAMP_SCHEDULE_PPT;
    private String QUERY_UPDATE_RESULT = null;

    public LmsCampUpdator() {
        super((short)2, 2L);
        this.setName("LmsCampUpdator");
        this.setTaskID("LmsCampUpdator" + System.currentTimeMillis());
        this.QUERY_SELECT_TARGET_SMS_LIST_TABLE = SqlManager.getQuery("MASS_UPDATE", "QUERY_SELECT_TARGET_LMS_LIST_TABLE");
        this.QUERY_TARGET_SMS_RESULT_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_TARGET_LMS_RESULT_QUERY");
        this.QUERY_UPDATE_MASS_RESULT_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_MASS_RESULT_QUERY");
        this.QUERY_UPDATE_SMS_TRAN_FLAG_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_LMS_TRAN_FLAG_QUERY");
        this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        this.QUERY_INSERT_SEND_OPTIMIZ = SqlManager.getQuery("MASS_UPDATE", "QUERY_INSERT_SEND_OPTIMIZ");
        this.QUERY_UPDATE_RESULT = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_RESULT");
    }

    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL LmsCampUpdator===> execute()");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("CALL execute(), ", thw);
        }
    }

    protected void execute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL LmsCampUpdator===> execute_init()");
        }
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        CAMP_SCHEDULE_PPT.clear();
        this.TARGET_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
        this.TMS_SMS_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
        this.TMS_SMS_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
        this.MODULE_SMS_SELECT_STMT = this.TARGET_CONNECTION.createStatement();
        this.MODULE_SMS_UPDATE_PSTMT = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_main() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL LmsCampUpdator===> execute_main()");
        }
        Properties tValue = new Properties();
        try (eMsResultSet smsListTableResult = null;){
            smsListTableResult = this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_SELECT_TARGET_SMS_LIST_TABLE);
            if (smsListTableResult.next()) {
                String L1 = smsListTableResult.getString("LIST_TABLE1");
                String L2 = smsListTableResult.getString("LIST_TABLE2");
                String L3 = smsListTableResult.getString("LIST_TABLE3");
                if (L1.equals(L2)) {
                    tValue.setProperty("LIST_TABLE1", L1);
                } else {
                    tValue.setProperty("LIST_TABLE2", L2);
                    if (!L2.equals(L3)) {
                        tValue.setProperty("LIST_TABLE3", L3);
                    }
                }
            }
            if (smsListTableResult != null) {
                smsListTableResult.close();
            }
            Iterator<Object> iter = tValue.values().iterator();
            while (iter.hasNext()) {
                String smsListTable = iter.next().toString();
                if (!smsListTable.equals("") && !smsListTable.equals(null)) {
                    this.update_process(smsListTable);
                    continue;
                }
                log.debug("TARGET TABLE null ", (Object)this.QUERY_SELECT_TARGET_SMS_LIST_TABLE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        eMsResultSet moduleSMSResult = null;
        Properties sMsSendResultValue = new Properties();
        Properties summaryValue = new Properties();
        ScheduleTblBean stBean = null;
        Object updateBean = null;
        int result = 0;
        int count = 0;
        boolean updateFlag = false;
        StringBuffer buff = new StringBuffer(512);
        try {
            sMsSendResultValue.setProperty("LMS_LIST_TABLE", list_table);
            moduleSMSResult = this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_TARGET_SMS_RESULT_QUERY, sMsSendResultValue, "${", "}");
            Properties tableNameProp = new Properties();
            tableNameProp.setProperty("LMS_LIST_TABLE", list_table);
            StringBuffer buffer = new StringBuffer();
            StringConvertUtil.ConvertString(buffer, this.QUERY_UPDATE_SMS_TRAN_FLAG_QUERY, tableNameProp, "${", "}", true, true);
            this.MODULE_SMS_UPDATE_PSTMT = new eMsPreparedStatement(buffer.toString(), "${", "}");
            this.MODULE_SMS_UPDATE_PSTMT.connectTo(this.TARGET_CONNECTION);
            while (moduleSMSResult.next()) {
                updateFlag = true;
                sMsSendResultValue.clear();
                sMsSendResultValue.setProperty("LMS_LIST_TABLE", list_table);
                moduleSMSResult.putToMap(sMsSendResultValue, false);
                stBean = (ScheduleTblBean)CAMP_SCHEDULE_PPT.get(sMsSendResultValue.getProperty("POST_ID"));
                if (stBean == null) {
                    stBean = new ScheduleTblBean(sMsSendResultValue.getProperty("POST_ID"));
                    CAMP_SCHEDULE_PPT.put(sMsSendResultValue.getProperty("POST_ID"), stBean);
                }
                if (sMsSendResultValue.getProperty("MEMBER_ID").indexOf("^") > 0) {
                    int pos = sMsSendResultValue.getProperty("MEMBER_ID").indexOf("^");
                    String mId = sMsSendResultValue.getProperty("MEMBER_ID").substring(0, pos);
                    String workSeq = sMsSendResultValue.getProperty("MEMBER_ID").substring(pos + 1);
                    sMsSendResultValue.setProperty("M_ID", mId);
                    sMsSendResultValue.setProperty("WORK_SEQ", workSeq);
                    this.TMS_SMS_UPDATE_STMT.executeUpdate(this.QUERY_UPDATE_RESULT, sMsSendResultValue, "${", "}");
                    updateFlag = false;
                } else {
                    this.TMS_SMS_UPDATE_STMT.executeUpdate(this.QUERY_UPDATE_MASS_RESULT_QUERY, sMsSendResultValue, "${", "}");
                    if (Integer.parseInt(sMsSendResultValue.getProperty("FAIL_CNT")) > 0) {
                        stBean.addFailCnt();
                        stBean.addErrorCnt(sMsSendResultValue.getProperty("ERROR_CODE"));
                    }
                    stBean.addPush();
                }
                this.MODULE_SMS_UPDATE_PSTMT.executeUpdate(sMsSendResultValue);
            }
            if (CAMP_SCHEDULE_PPT.size() <= 0) {
                return;
            }
            Enumeration e = CAMP_SCHEDULE_PPT.elements();
            while (e.hasMoreElements()) {
                stBean = (ScheduleTblBean)e.nextElement();
                buff.setLength(0);
                if (log.isDebugEnabled()) {
                    log.debug("[stBean content]\n\t" + stBean.toString());
                }
                StringConvertUtil.ConvertString(buff, this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY, stBean.getElement("MASS"), "${", "}", true, false);
                result = this.TMS_SMS_UPDATE_STMT.executeUpdate(buff.toString());
                if (result < 1) {
                    log.debug("[SCHEDULE SUMMARY FAIL]:" + stBean.getName());
                    continue;
                }
                ++count;
            }
            if (count == CAMP_SCHEDULE_PPT.size()) {
                // empty if block
            }
        }
        catch (Exception e) {
            log.error("LmsCampUpdator", (Object)"execute_main", (Object)e);
        }
        finally {
            if (moduleSMSResult != null) {
                moduleSMSResult.close();
            }
            if (this.MODULE_SMS_UPDATE_PSTMT != null) {
                this.MODULE_SMS_UPDATE_PSTMT.close();
            }
        }
    }

    @Override
    public void release_Resource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL LmsCampUpdator===> releaseResource()");
        }
        if (this.TMS_SMS_SELECT_STMT != null) {
            this.TMS_SMS_SELECT_STMT.close();
        }
        if (this.TMS_SMS_UPDATE_STMT != null) {
            this.TMS_SMS_UPDATE_STMT.close();
        }
        if (this.SOURCE_CONNECTION != null) {
            this.SOURCE_CONNECTION.recycle();
        }
        if (this.MODULE_SMS_SELECT_STMT != null) {
            this.MODULE_SMS_SELECT_STMT.close();
        }
        if (this.MODULE_SMS_UPDATE_PSTMT != null) {
            this.MODULE_SMS_UPDATE_PSTMT.close();
        }
        if (this.TARGET_CONNECTION != null) {
            this.TARGET_CONNECTION.recycle();
        }
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("LmsCampUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("LmsCampUpdator", (Object)"init error", (Object)thw);
    }

    static {
        TARGET_CONNECT_INFO = new ConnectInfo();
        TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
        TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("sms.db.url"));
        TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("sms.db.id"));
        TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
        TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
        TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
        TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
        TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
        CAMP_SCHEDULE_PPT = new Hashtable();
    }
}

