/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jupiter.mass.log.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.schedule.Task;
import pluto.util.Cal;

public class KakaoMsgUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(KakaoMsgUpdator.class);
    private static ConnectInfo otherConnectInfo = new ConnectInfo();
    private static String querySelectTargetList = null;
    private static String queryUpdateTargetList = null;
    private static String queryUpdateSendList = null;
    private static String queryUpdateScheduleInfo = null;
    private eMsConnection oriCon = null;
    private eMsConnection moduleCon = null;
    private eMsResultSet rsSelect = null;
    private eMsPreparedStatement psSelect = null;
    private eMsPreparedStatement psLogUpdate = null;
    private eMsPreparedStatement psSchdUpdate = null;
    private boolean isOtherDb = false;
    private Properties taskProp = null;
    private Map<String, ScheduleTblBean> summary = new HashMap<String, ScheduleTblBean>();

    @Override
    public void setTaskProperty(Properties prop) {
        this.taskProp = prop;
        String currentTime = Cal.getSerialDate();
        this.setName("KakaoMsgUpdator_at_" + currentTime);
        this.setTaskID("KakaoMsgUpdator_at_" + currentTime);
        this.isOtherDb = Boolean.parseBoolean(this.taskProp.getProperty("use.other.db", "false"));
    }

    @Override
    public void execute_initiate() throws Exception {
        log.info("{}... START", (Object)this.getName());
        this.oriCon = ConnectionPool.getConnection();
        if (this.isOtherDb) {
            this.moduleCon = ConnectionPool.getConnection(otherConnectInfo);
            this.psSelect = this.moduleCon.prepareStatement(querySelectTargetList, "${", "}");
            this.psLogUpdate = this.moduleCon.prepareStatement(queryUpdateTargetList, "${", "}");
        }
        if (this.moduleCon == null) {
            this.psSelect = this.oriCon.prepareStatement(querySelectTargetList, "${", "}");
            this.psLogUpdate = this.oriCon.prepareStatement(queryUpdateTargetList, "${", "}");
        }
        this.psSchdUpdate = this.oriCon.prepareStatement(queryUpdateScheduleInfo, "${", "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        this.rsSelect = this.psSelect.executeQuery(this.taskProp);
        while (this.rsSelect.next()) {
            Properties result = new Properties();
            eMsPreparedStatement psListUpdate = null;
            try {
                this.rsSelect.putToMap(result, false);
                log.debug("Target List Info: {}", (Object)result);
                String postId = result.getProperty("POST_ID", "");
                if (postId.isEmpty()) continue;
                queryUpdateSendList = this.ppsParseSQL(queryUpdateSendList, "LIST_TABLE", result.getProperty("LIST_TABLE", ""), "@{", "}");
                psListUpdate = this.oriCon.prepareStatement(queryUpdateSendList, "${", "}");
                if (this.psLogUpdate.executeUpdate(result) < 1 || psListUpdate.executeUpdate(result) < 1) {
                    log.error("[ERROR] Msg Result is not updated. {}", (Object)result);
                    continue;
                }
                ScheduleTblBean bean = this.summary.get(postId);
                if (bean == null) {
                    bean = new ScheduleTblBean(postId);
                    this.summary.put(postId, bean);
                }
                bean.addSwitchedCnt();
            }
            catch (Exception e) {
                log.error("[ERROR] Msg Result process.", (Throwable)e);
            }
            finally {
                if (psListUpdate == null) continue;
                psListUpdate.close();
            }
        }
        if (!this.summary.isEmpty()) {
            this.updateSummary(this.summary);
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("execute_initiateError()...", thw);
    }

    @Override
    public void release_Resource() {
        if (this.rsSelect != null) {
            this.rsSelect.close();
        }
        if (this.psSelect != null) {
            this.psSelect.close();
        }
        if (this.psLogUpdate != null) {
            this.psLogUpdate.close();
        }
        if (this.psSchdUpdate != null) {
            this.psSchdUpdate.close();
        }
        if (this.moduleCon != null) {
            this.moduleCon.close();
        }
        if (this.oriCon != null) {
            this.oriCon.close();
        }
        log.info("{}... END", (Object)this.getName());
    }

    private void updateSummary(Map<String, ScheduleTblBean> target) {
        for (Map.Entry<String, ScheduleTblBean> t : target.entrySet()) {
            ScheduleTblBean b = t.getValue();
            log.debug("updateSummary... target: {}", (Object)b);
            try {
                if (this.psSchdUpdate.executeUpdate(b.getElement("AUTO")) >= 1) continue;
                log.error("[ERROR] Summary is not updated. target: {}", (Object)b);
            }
            catch (Exception e) {
                log.error("[ERROR] Summary is not updated.", (Throwable)e);
            }
        }
    }

    protected String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return KakaoMsgUpdator.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    static {
        querySelectTargetList = SqlManager.getQuery("MSG_UPDATE", "QUERY_SELECT_TARGET_LIST");
        queryUpdateTargetList = SqlManager.getQuery("MSG_UPDATE", "QUERY_UPDATE_TARGET_LIST");
        queryUpdateSendList = SqlManager.getQuery("MSG_UPDATE", "QUERY_UPDATE_SEND_LIST");
        queryUpdateScheduleInfo = SqlManager.getQuery("MSG_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO");
        otherConnectInfo.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
        otherConnectInfo.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
        otherConnectInfo.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
        otherConnectInfo.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
        otherConnectInfo.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
        otherConnectInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
        otherConnectInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
        otherConnectInfo.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
    }
}

