/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.task;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.mail.MailSendingInstanceFactory;
import pluto.reporter.Reporter;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;

public class SingleScheduleCheckTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(SingleScheduleCheckTask.class);
    public static String QUERY_SELECT_TARGET_SCHEDULE = null;
    protected static List QUERY_LIST_UPDATE_TARGET_SCHEDULE = null;
    protected String MAIL_ID = "";
    protected eMsConnection EMS_CONNECTION = null;

    public SingleScheduleCheckTask() {
        super((short)2);
        this.setName("SingleScheduleCheckTask_at_".concat(Cal.getSerialDate()));
        this.setTaskID("SingleScheduleCheckTask");
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("ScheduleCheck_at_".concat(Cal.getSerialDate()));
        if (log.isDebugEnabled()) {
            log.debug(" Request Connection");
        }
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        if (log.isDebugEnabled()) {
            log.debug(" Get Connetion " + this.EMS_CONNECTION.getName());
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(" Request Connection Error");
        if (!(thw instanceof SQLException)) {
            Reporter.report("common", this.getName(), "schedulechecktask.init.err", thw);
        }
    }

    @Override
    public void release_Resource() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycle();
        }
    }

    @Override
    public void doErrorProcess(Throwable thw) {
        log.error(this.getName(), thw);
        Reporter.report("common", this.getName(), "schedulechecktask.check.err", thw);
    }

    @Override
    public void execute() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(" is execute execute_createTask method...");
        }
        this.execute_createTask(QUERY_SELECT_TARGET_SCHEDULE, QUERY_LIST_UPDATE_TARGET_SCHEDULE);
        if (log.isDebugEnabled()) {
            log.debug(" is execute execute_createTask method...[OK]");
        }
    }

    private synchronized void execute_createTask(String TARGET_QUERY, List UPDATE_QUERY) throws Exception {
        eMsStatement __SELECT_STATEMENT__ = null;
        eMsStatement __EMS_EXEC_STATEMENT__ = null;
        eMsResultSet __RESULT_OF_SCHEDULE__ = null;
        try {
            __SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            __EMS_EXEC_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            if (log.isDebugEnabled()) {
                log.debug(this.EMS_CONNECTION.getName() + " BEFORE execute Query");
            }
            __RESULT_OF_SCHEDULE__ = __SELECT_STATEMENT__.executeQuery(TARGET_QUERY);
            if (log.isDebugEnabled()) {
                log.debug(this.EMS_CONNECTION.getName() + " AFTER execute Query");
            }
            while (__RESULT_OF_SCHEDULE__.next()) {
                Properties SCHEDULE_INFO = new Properties();
                __RESULT_OF_SCHEDULE__.putToMap(SCHEDULE_INFO, false);
                this.MAIL_ID = SCHEDULE_INFO.getProperty("MAIL_ID", "NO ID");
                SCHEDULE_INFO.setProperty("UPDATE_JOB_STATUS", "--");
                if (log.isDebugEnabled()) {
                    log.debug(this.getName() + " is create new MakeSendInfoTask " + SCHEDULE_INFO.getProperty("POST_ID"));
                }
                try {
                    Task make_info = (Task)MailSendingInstanceFactory.getInstance(SCHEDULE_INFO, (short)4);
                    if (log.isDebugEnabled()) {
                        log.debug(this.getName() + " is Popup MailSendTask => " + SCHEDULE_INFO.getProperty("SEND_TYPE") + "_" + SCHEDULE_INFO.getProperty("SEND_STATE") + " =>" + make_info.getClass().getName());
                    }
                    make_info.setTaskProperty(SCHEDULE_INFO);
                    TaskManager.executeTask(make_info);
                    this.EMS_CONNECTION.executeUpdateList(UPDATE_QUERY, SCHEDULE_INFO, "${", "}", false);
                }
                catch (Exception e) {
                    if (e instanceof AlreadyRegistTaskException) {
                        SCHEDULE_INFO.setProperty("UPDATE_JOB_STATUS", "95");
                        this.EMS_CONNECTION.executeUpdateList(UPDATE_QUERY, SCHEDULE_INFO, "${", "}", false);
                    }
                    log.error(this.getName(), (Throwable)e);
                    Reporter.report("[" + this.MAIL_ID + "] " + SCHEDULE_INFO.getProperty("POST_ID"), this.getName(), "schedulechecktask.create.info.err", e);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                __RESULT_OF_SCHEDULE__.close();
            }
            catch (Exception ignore) {}
            this.EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
            this.EMS_CONNECTION.recycleStatement(__EMS_EXEC_STATEMENT__);
        }
    }

    static {
        try {
            QUERY_SELECT_TARGET_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_TARGET_SCHEDULE");
            QUERY_LIST_UPDATE_TARGET_SCHEDULE = SqlManager.getMultiQuery("MAIN_SCHEDULE_CHECK", "QUERY_UPDATE_TARGET_SCHEDULE");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

