/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.pool;

import jupiter.common.pool.FixedDomainBufferedAgentPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import pluto.log.Composer;
import pluto.log.SmtpLogger;
import pluto.util.Cal;
import venus.spool.common.parser.SpoolAnalyzer;

public class TimeSectionLimitAgentPool
extends FixedDomainBufferedAgentPool {
    private static final Logger log = LoggerFactory.getLogger(TimeSectionLimitAgentPool.class);
    public int TIMELIMIT_START = 2400;
    public int TIMELIMIT_END = 448;
    public Composer composer;
    public SpoolAnalyzer SPOOL_ANALYZER = null;

    @Override
    protected void inner_init(Element TargetNode, String name) throws Exception {
        super.inner_init(TargetNode, name);
        Element subNode = (Element)TargetNode.getElementsByTagName("time-limit").item(0);
        this.TIMELIMIT_START = Integer.parseInt(subNode.getAttribute("start"));
        this.TIMELIMIT_END = Integer.parseInt(subNode.getAttribute("end"));
        if (log.isDebugEnabled()) {
            log.debug("start:{}", (Object)subNode.getAttribute("start"));
            log.debug("end:{}", (Object)subNode.getAttribute("end"));
        }
        try {
            this.SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
        }
        catch (Exception e) {
            log.error("spool analyzer error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registSpool(String domain, String spool) {
        if (TimeSectionLimitAgentPool.check_TimeLimit(this.TIMELIMIT_START, this.TIMELIMIT_END)) {
            if (log.isDebugEnabled()) {
                log.debug("ACCEPT");
            }
            super.registSpool(domain, spool);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("REJECT");
            }
            this.composer = Composer.getComposerInstance();
            try {
                this.SPOOL_ANALYZER.parse(spool);
            }
            catch (Exception e) {
                log.error("spool parse error", (Throwable)e);
            }
            Object object = this.composer.getLock();
            synchronized (object) {
                this.composer.setProperty("STYPE", this.SPOOL_ANALYZER.getSendType());
                this.composer.setProperty("T_TYPE", "54");
                this.composer.setProperty("T_CODE", "00");
                this.composer.setProperty("POST_ID", this.SPOOL_ANALYZER.getPostID());
                this.composer.setProperty("M_ID", this.SPOOL_ANALYZER.getMemberID());
                this.composer.setProperty("STEP", this.SPOOL_ANALYZER.getStep());
                this.composer.setProperty("T_DATE", Cal.getDate());
                this.composer.setProperty("MX_RECORD", "NC");
                this.composer.setProperty("DELAY", "0");
                this.composer.setProperty("TOKEN_ID", this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT"));
                this.composer.setProperty("DOMAIN", this.SPOOL_ANALYZER.getDomain());
                this.composer.setProperty("WORKER", this.getName());
                this.composer.setProperty("ETC_LOG", "550 OUT OF TIME LIMIT");
                this.composer.setProperty("LIST_TABLE", this.SPOOL_ANALYZER.getListTable());
                SmtpLogger.put(this.composer);
                this.composer.setProperty("STYPE", this.SPOOL_ANALYZER.getSendType());
                this.composer.setProperty("T_TYPE", "55");
                this.composer.setProperty("T_CODE", "30");
                this.composer.setProperty("POST_ID", this.SPOOL_ANALYZER.getPostID());
                this.composer.setProperty("M_ID", this.SPOOL_ANALYZER.getMemberID());
                this.composer.setProperty("STEP", this.SPOOL_ANALYZER.getStep());
                this.composer.setProperty("T_DATE", Cal.getDate());
                this.composer.setProperty("MX_RECORD", "NC");
                this.composer.setProperty("DELAY", "0");
                this.composer.setProperty("TOKEN_ID", this.SPOOL_ANALYZER.getProperty("TOKEN_ENCRYPT"));
                this.composer.setProperty("DOMAIN", this.SPOOL_ANALYZER.getDomain());
                this.composer.setProperty("WORKER", this.getName());
                this.composer.setProperty("ETC_LOG", "550 OUT OF TIME LIMIT");
                this.composer.setProperty("LIST_TABLE", this.SPOOL_ANALYZER.getListTable());
                SmtpLogger.put(this.composer);
            }
        }
    }

    public static boolean check_TimeLimit(int startTime, int endTime) {
        int cur_Time = Integer.parseInt(Cal.getHHmm());
        int limit_StartTime = startTime;
        int limit_EndTime = endTime;
        if (log.isDebugEnabled()) {
            log.debug("cur_Time:{}", (Object)cur_Time);
            log.debug("limit_StartTime:{}", (Object)limit_StartTime);
            log.debug("limit_EndTime:{}", (Object)limit_EndTime);
        }
        if (limit_StartTime > limit_EndTime) {
            return cur_Time > limit_StartTime && cur_Time < limit_EndTime;
        }
        if (limit_StartTime < limit_EndTime) {
            return cur_Time > limit_StartTime && cur_Time < limit_EndTime;
        }
        return true;
    }
}

