/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.util.Properties;
import jupiter.common.actor.ListMaker;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.AbstractNoDBMailSendTask;
import jupiter.mass.send.basic.SendStopException;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.MailSendingInstanceFactory;
import pluto.panopticon.filter.RejectFilter;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.convert.StringConvert;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;
import venus.spool.common.task.SpoolControlTask;

public class SmsCampTestSendTask
extends AbstractNoDBMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(SmsCampTestSendTask.class);
    protected ListMaker INNER_LIST_MAKER = null;
    protected Properties MAPPING_HEADER_INFO = null;
    public int send_cnt = 0;
    protected String MAIL_ID = "";
    private static String QUERY_UPDATE_TEST_STATUS = null;
    public static String QUERY_CHECK_SMS_TYPE = null;

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.setTaskID(this.POST_ID);
        this.MAIL_ID = this.TASK_PROPERTY.getProperty("MAIL_ID", "NO ID");
        this.setName("[" + this.MAIL_ID + "] " + this.POST_ID + "_TestSendTask");
        this.WORK_FILE_ID = this.POST_ID.concat("_test_").concat(Cal.getSerialDate());
    }

    @Override
    public void execute_initiate() throws Exception {
    }

    @Override
    protected void execute_ContentLoad() throws Exception {
        ContentPD INNER_CONTENT_PD = (ContentPD)MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, (short)5);
        INNER_CONTENT_PD.process(this.TASK_PROPERTY);
        ContentInfo __CONTENT_INFO__ = INNER_CONTENT_PD.getContentInfo();
        ContentInfoManager.putContentInfo(__CONTENT_INFO__, false);
    }

    @Override
    protected void execute_ListMake() throws Exception {
        this.INNER_LIST_MAKER = (ListMaker)MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, (short)6);
        this.INNER_LIST_MAKER.process(this.TASK_PROPERTY);
    }

    @Override
    protected void execute_ListLoad() throws Exception {
        SpoolControlTask targetTask = (SpoolControlTask)InstanceFactory.getInstance(this.TASK_PROPERTY, (short)7);
        if (this.TASK_PROPERTY.getProperty("POST_ID").indexOf("_") > 0) {
            this.TASK_PROPERTY.setProperty("TARGET_LIST_FILE", (String)this.INNER_LIST_MAKER.getTargetList());
        }
        targetTask.setTaskProperty(this.TASK_PROPERTY);
        targetTask.setMAPPING_HEADER_INFO(this.MAPPING_HEADER_INFO);
        targetTask.internal_execute();
        this.mailSpoolInfo = targetTask.getSpoolInfo();
    }

    @Override
    public void execute_initiateError(Throwable thw) {
    }

    @Override
    protected void execute_Startup() throws Exception {
        this.update_test_status("30", "--");
    }

    protected void execute_SendStartUpdate() throws Exception {
    }

    @Override
    protected void execute_Finish() throws Exception {
        this.update_test_status("40", "30");
    }

    protected void update_test_status(String status, String now_status) throws Exception {
        this.TASK_PROPERTY.setProperty("JOB_STATUS", status);
        this.TASK_PROPERTY.setProperty("JOB_STATUS_NOW", now_status);
        eMsConnection conn = null;
        eMsStatement stmt = null;
        try {
            conn = ConnectionPool.getConnection();
            stmt = conn.createStatement();
            StringBuffer buffer = new StringBuffer();
            StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_TEST_STATUS, this.TASK_PROPERTY, "${", "}", true, false);
            stmt.executeUpdate(buffer.toString());
        }
        catch (Exception e) {
            log.error("update test status", (Throwable)e);
            throw e;
        }
        finally {
            if (conn != null) {
                conn.recycleStatement(stmt);
                conn.recycle();
            }
        }
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
        this.execute_test_ListSend();
    }

    protected synchronized void execute_test_ListSend() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_test_ListSend");
        }
        if (this.mailSpoolInfo != null) {
            this.SPOOL_POPPER = Popper.getInstance();
            if (this.mailSpoolInfo.getSpoolFilesInfo().isEmpty()) {
                log.debug("No Real Data.... So Skip");
                return;
            }
            try {
                this.SPOOL_POPPER.setTaskProp(this.TASK_PROPERTY);
                this.SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
            }
            catch (Exception ex) {
                log.error("spool popper error", (Throwable)ex);
            }
        } else {
            log.debug("MAIL SPOOL INFO IS NULL SO SKIP..");
            return;
        }
        if (this.SPOOL_POPPER == null) {
            log.error("No Real Data.... So Skip");
            return;
        }
        if (this.execute_StopCheck()) {
            throw new SendStopException(this.getName() + " receive stop signal");
        }
        RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);
        String nextSpool = null;
        String domain = null;
        int spoolPatchCount = 0;
        BufferedAgentPool pool = null;
        domain = this.TASK_PROPERTY.getProperty("SMS_TYPE").toLowerCase();
        if ("".equals(domain)) {
            domain = this.getSmstype();
        }
        if (this.TASK_PROPERTY.getProperty("DONGBO_YN").equals("Y") && ("SMS".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE")) || "LMS".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE")))) {
            domain = domain + "d";
        }
        while ((nextSpool = (String)this.SPOOL_POPPER.next()) != null) {
            ++this.send_cnt;
            if (nextSpool == null || nextSpool.length() < 1) continue;
            if (spoolPatchCount++ % this.instance_STOP_CHECK_RECYCLE == 0 && this.execute_StopCheck()) {
                throw new SendStopException(this.getName() + " receive stop signal");
            }
            nextSpool = nextSpool + "|" + this.TASK_PROPERTY.getProperty("FROM_EMAIL");
            try {
                if (domain == null) {
                    this.processSyntaxErrorSpool(nextSpool);
                    continue;
                }
                if (instanceRejectFilter != null) {
                    this.SPOOL_ANALYZER.parse(nextSpool);
                    if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) continue;
                    nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
                }
                pool = this.getBufferedObjectPool(domain);
                pool.registSpool(domain, nextSpool);
            }
            catch (OutOfMemoryError outError) {
                log.error("OOM error", (Throwable)outError);
                System.gc();
                try {
                    Thread.sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    SpoolingManager.registSpool(nextSpool);
                }
                catch (Exception ignore) {
                }
            }
            catch (Throwable err) {
                log.error(this.getName(), err);
                ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("EXEC BufferedAgentPool.flushAll()");
        }
        BufferedAgentPool.flushAll();
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend [OK]");
        }
    }

    @Override
    protected boolean execute_StopCheck() {
        return false;
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("single", domain);
    }

    @Override
    public void doErrorProcess(Throwable thw) {
        log.error(this.getName(), thw);
        try {
            this.update_test_status("41", "30");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        Reporter.report(this.getName(), this.getName(), "mailsendtask.exec.err", thw);
    }

    @Override
    public void release_Resource() {
    }

    @Override
    protected void passDomainNotFound(String spool, Throwable ex) throws Exception {
        log.error("TEST SPOOL DOMAIN INVALID", (Object)spool.concat("=>").concat(ex.toString()));
    }

    @Override
    protected void processSyntaxErrorSpool(String spool) throws Exception {
        log.error("TEST SPOOL SYNTAX ERROR", (Object)spool);
    }

    @Override
    protected void passRejectDomain(String spool) throws Exception {
        log.error("TEST SPOOL DOMAIN REJECTED", (Object)spool);
    }

    private String getSmstype() throws Exception {
        eMsConnection emsConnection = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            StringBuffer buffer = new StringBuffer(256);
            StringConvert.ConvertStringUseMap(buffer, QUERY_CHECK_SMS_TYPE, this.TASK_PROPERTY, "${", "}", false, true);
            Properties m = new Properties();
            emsConnection.putSingleResultToMap(buffer.toString(), m);
            String string = m.getProperty("SMS_TYPE");
            return string;
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw new Exception(e);
        }
        finally {
            emsConnection.recycle();
        }
    }

    static {
        try {
            QUERY_UPDATE_TEST_STATUS = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_UPDATE_TEST_STATUS");
            QUERY_CHECK_SMS_TYPE = SqlManager.getQuery("COMMON", "QUERY_CHECK_SMS_TYPE");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

