/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.util.List;
import java.util.Properties;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.util.Cal;

public class AutoBaseSendTask
extends CommonStepMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(AutoBaseSendTask.class);
    public static List QUERY_UPDATE_STATE_START = null;
    public static List QUERY_UPDATE_STATE_END = null;
    public static List QUERY_UPDATE_STATE_INFO = null;
    public static String QUERY_CHECK_STOP_FLAG = null;
    public static String QUERY_UPDATE_STATE_STOP = null;
    protected Properties MAPPING_HEADER_INFO = null;

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat(Cal.getSerialDate());
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_AutoBaseSendTask");
        this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
        this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;
    }

    @Override
    protected void execute_Startup() throws Exception {
        this.execute_SendStartUpdate();
    }

    protected void execute_SendStartUpdate() throws Exception {
        this.updateTaskState("90", "30");
        eMsConnection emsConnection = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            emsConnection.executeUpdateList(QUERY_UPDATE_STATE_START, this.TASK_PROPERTY, "${", "}", false);
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw new Exception(e);
        }
        finally {
            emsConnection.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_Finish() throws Exception {
        this.updateTaskState("90", "40");
        eMsConnection emsConnection = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            String jobStatus = "40";
            if ("Y".equals(this.TASK_PROPERTY.getProperty("DIVIDE_SEND_USE_YN", "N"))) {
                int prevSpoolReadCount = Integer.parseInt(this.TASK_PROPERTY.getProperty("SPOOL_READ_COUNT", "0"));
                int filterCount = Integer.parseInt(this.TASK_PROPERTY.getProperty("FILTER_CNT", "0"));
                log.info("divide Info  prevSpoolReadCount : {} / filterCount : {} / Target Cnt : {} ", new Object[]{prevSpoolReadCount, filterCount, this.TASK_PROPERTY.getProperty("TARGET_CNT", "0")});
                if ((prevSpoolReadCount += this.mailSpoolInfo.getSpoolSize() + filterCount) < Integer.parseInt(this.TASK_PROPERTY.getProperty("TARGET_CNT", "0"))) {
                    log.info("Next Schedule Reserve after " + this.TASK_PROPERTY.getProperty("DIVIDE_MINUTE", "0") + "minute [postId:" + this.TASK_PROPERTY.getProperty("POST_ID") + "] ");
                    jobStatus = "00";
                }
                this.TASK_PROPERTY.put("NEXT_REQ_MINUTE", this.TASK_PROPERTY.getProperty("DIVIDE_MINUTE", "0"));
                this.TASK_PROPERTY.put("NEXT_DIVIDE_SCHD_SEQ", String.valueOf(this.mailSpoolInfo.getNextSpoolDivideScheduleSeq()));
            } else {
                this.TASK_PROPERTY.put("NEXT_REQ_MINUTE", "0");
                this.TASK_PROPERTY.put("NEXT_DIVIDE_SCHD_SEQ", String.valueOf(this.mailSpoolInfo.getSpoolDivideScheduleSeq()));
            }
            this.TASK_PROPERTY.put("UPDATE_JOB_STATUS", jobStatus);
            this.TASK_PROPERTY.put("LAST_SPOOL_MEMBER_ID", this.mailSpoolInfo.getLastMemberId());
            this.TASK_PROPERTY.put("CURRENT_SPOOL_READ_COUNT", String.valueOf(this.mailSpoolInfo.getSpoolSize()));
            emsConnection.executeUpdateList(QUERY_UPDATE_STATE_END, this.TASK_PROPERTY, "${", "}", false);
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
        }
        finally {
            emsConnection.recycle();
        }
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("single", domain);
    }

    static {
        try {
            QUERY_UPDATE_STATE_START = SqlManager.getMultiQuery("COMMON", "QUERY_UPDATE_STATE_START");
            QUERY_UPDATE_STATE_END = SqlManager.getMultiQuery("COMMON", "QUERY_UPDATE_STATE_END");
            QUERY_CHECK_STOP_FLAG = SqlManager.getQuery("COMMON", "QUERY_CHECK_STOP_FLAG");
            QUERY_UPDATE_STATE_INFO = SqlManager.getMultiQuery("COMMON", "QUERY_UPDATE_STATE_INFO");
            QUERY_UPDATE_STATE_STOP = SqlManager.getQuery("COMMON", "QUERY_UPDATE_STATE_STOP");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

