/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.log.updator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class MMSAutoReceiver
extends Task {
    private static final Logger log = LoggerFactory.getLogger(MMSAutoReceiver.class);
    protected eMsConnection SOURCE_CONNECTION = null;
    protected eMsConnection TARGET_CONNECTION = null;
    protected eMsStatement TARGET_SELECT_STMT = null;
    protected eMsStatement TARGET_UPDATE_STMT = null;
    protected eMsStatement EMS_UPDATE_STMT = null;
    protected eMsStatement EMS_SELECT_STMT = null;
    protected String QUERY_SELECT_TARGET_MMS_LIST_TABLE = null;
    protected String QUERY_TARGET_MMS_RESULT_QUERY = null;
    protected String QUERY_UPDATE_AUTO_RESULT_QUERY = null;
    protected String QUERY_UPDATE_AUTO_SUMMARY_QUERY = null;
    protected String QUERY_UPDATE_LOG_RESULT_QUERY = null;
    protected String QUERY_UPDATE_AUTO_RESULT_QUERY_SUCCESS = null;
    protected LinkedList LIST_SUMMARY_TARGET_AUTO_IDS = null;

    public MMSAutoReceiver() {
        super((short)2, 1L);
        this.setName("MMSAutoRecevier");
        this.setTaskID("MMSAutoRecevier" + System.currentTimeMillis());
        this.QUERY_SELECT_TARGET_MMS_LIST_TABLE = SqlManager.getQuery("AUTO_UPDATE", "QUERY_SELECT_TARGET_MMS_LIST_TABLE");
        this.QUERY_TARGET_MMS_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_TARGET_MMS_RESULT_QUERY");
        this.QUERY_UPDATE_AUTO_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_AUTO_RESULT_QUERY");
        this.QUERY_UPDATE_AUTO_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_AUTO_SUMMARY_QUERY");
        this.QUERY_UPDATE_LOG_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_LOG_RESULT_QUERY");
        this.QUERY_UPDATE_AUTO_RESULT_QUERY_SUCCESS = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_AUTO_RESULT_QUERY_SUCCESS");
        this.LIST_SUMMARY_TARGET_AUTO_IDS = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL MAIN METHOD");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("SMSAUTOReceiver", (Object)"CALL MAIN METHOD ERROR", (Object)thw);
        }
        finally {
            this.releaseResource();
        }
    }

    protected void execute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL MAIN execute_init");
        }
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        this.EMS_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
        this.EMS_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
        this.setName("LMSAutoReceiver");
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL MAIN releaseResource");
        }
        if (this.SOURCE_CONNECTION != null) {
            this.SOURCE_CONNECTION.recycleStatement(this.EMS_SELECT_STMT);
            this.SOURCE_CONNECTION.recycleStatement(this.EMS_UPDATE_STMT);
            this.SOURCE_CONNECTION.recycle();
        }
        if (this.TARGET_SELECT_STMT != null) {
            this.TARGET_SELECT_STMT.close();
            this.TARGET_SELECT_STMT = null;
        }
        if (this.TARGET_UPDATE_STMT != null) {
            this.TARGET_UPDATE_STMT.close();
            this.TARGET_UPDATE_STMT = null;
        }
        if (this.TARGET_CONNECTION != null) {
            this.TARGET_CONNECTION.destroy();
            this.TARGET_CONNECTION = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_main() throws Throwable {
        String sTableName;
        Iterator<Object> iter;
        if (log.isDebugEnabled()) {
            log.debug("CALL MAIN execute_main");
        }
        eMsResultSet rsResult = null;
        this.TARGET_SELECT_STMT = this.TARGET_CONNECTION.createStatement();
        this.TARGET_UPDATE_STMT = this.TARGET_CONNECTION.createStatement();
        LinkedList<String> listSMSLogTables = new LinkedList<String>();
        try {
            if (log.isDebugEnabled()) {
                log.debug("SELECT TARGET LOG TABLE", (Object)this.QUERY_SELECT_TARGET_MMS_LIST_TABLE);
            }
            rsResult = this.TARGET_SELECT_STMT.executeQuery(this.QUERY_SELECT_TARGET_MMS_LIST_TABLE);
            Properties tValue = new Properties();
            if (rsResult.next()) {
                if (rsResult.getString("LIST_TABLE1").equals(rsResult.getString("LIST_TABLE2"))) {
                    tValue.setProperty("LIST_TABLE", rsResult.getString("LIST_TABLE1").toString());
                } else {
                    rsResult.putToMap(tValue, false);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("TARGET TABLE SELECT FAIL..", (Object)this.QUERY_SELECT_TARGET_MMS_LIST_TABLE);
                }
                return;
            }
            iter = tValue.values().iterator();
            while (iter.hasNext()) {
                sTableName = iter.next().toString();
                if (listSMSLogTables.indexOf(sTableName) < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("SELECT TARGET LOG TABLE", (Object)sTableName);
                    }
                    listSMSLogTables.addLast(sTableName);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("SKIP TARGET LOG TABLE", (Object)sTableName);
            }
        }
        finally {
            if (rsResult != null) {
                rsResult.close();
            }
        }
        Properties tableProp = new Properties();
        this.LIST_SUMMARY_TARGET_AUTO_IDS.clear();
        iter = listSMSLogTables.iterator();
        while (iter.hasNext()) {
            sTableName = iter.next().toString();
            if (log.isDebugEnabled()) {
                log.debug("TARGET LOG TABLE", (Object)sTableName);
            }
            tableProp.setProperty("LIST_TABLE", sTableName);
            try {
                this.process_table(tableProp);
            }
            catch (Throwable thw) {
                log.error("LMSAutoReceiver", (Object)"TABLE PROCESS ERROR", (Object)thw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process_table(Properties prop) throws Throwable {
        try (eMsResultSet rsResult = null;){
            if (log.isDebugEnabled()) {
                log.debug("SELECT LOG TABLE>" + prop.toString(), (Object)this.QUERY_TARGET_MMS_RESULT_QUERY);
            }
            rsResult = this.TARGET_SELECT_STMT.executeQuery(this.QUERY_TARGET_MMS_RESULT_QUERY, prop, "${", "}");
            Properties tValue = new Properties();
            while (rsResult.next()) {
                rsResult.putToMap(tValue, false);
                tValue.setProperty("TARGET_TABLE", prop.getProperty("LIST_TABLE"));
                try {
                    this.process_record(tValue);
                }
                catch (Throwable thw1) {
                    log.error("LMSAutoReceiver", (Object)"RECORD UPDATE ERROR", (Object)thw1);
                }
                try {
                    this.process_summary(tValue);
                }
                catch (Throwable thw2) {
                    log.error("LMSAutoReceiver", (Object)"SUMMARY ERROR", (Object)thw2);
                }
                try {
                    this.process_update(tValue);
                }
                catch (Throwable thw3) {
                    log.error("LMSAutoReceiver", (Object)"TARGET_SMS_TABLE UPDATE ERROR", (Object)thw3);
                }
            }
        }
    }

    protected void process_summary(Properties record) throws Throwable {
        StringBuffer buffer = new StringBuffer(256);
        if (record.getProperty("ERROR_CODE").equals("00")) {
            if (log.isDebugEnabled()) {
                log.debug("ERROR_CODE 00");
            }
        } else {
            StringConvertUtil.ConvertString(buffer, this.QUERY_UPDATE_AUTO_SUMMARY_QUERY, record, "${", "}", true, false);
            if (this.EMS_UPDATE_STMT.executeUpdate(buffer.toString()) > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Summary update success");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Summary update fail");
            }
        }
    }

    protected void process_update(Properties record) throws Throwable {
        StringBuffer buffer = new StringBuffer(512);
        StringConvertUtil.ConvertString(buffer, this.QUERY_UPDATE_LOG_RESULT_QUERY, record, "${", "}", true, false);
        if (this.TARGET_UPDATE_STMT.executeUpdate(buffer.toString()) > 0) {
            if (log.isDebugEnabled()) {
                log.debug("update_flag success");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("update_flag fail");
        }
    }

    protected void process_record(Properties record) throws Throwable {
        String sTRAN_ETC7 = record.getProperty("TRAN_ETC7");
        String sTRAN_ETC6 = record.getProperty("TRAN_ETC6");
        String sTRAN_ETC1 = record.getProperty("TRAN_ETC1");
        record.setProperty("MEMBER_ID_SEQ", sTRAN_ETC7.substring(sTRAN_ETC7.lastIndexOf("_") + 1));
        record.setProperty("MEMBER_ID", sTRAN_ETC7.substring(0, sTRAN_ETC7.lastIndexOf("_")));
        record.setProperty("WORKDAY", sTRAN_ETC1.substring(0, sTRAN_ETC1.lastIndexOf("_")));
        record.setProperty("SEQNO", sTRAN_ETC1.substring(sTRAN_ETC1.lastIndexOf("_") + 1));
        record.setProperty("LIST_TABLE", sTRAN_ETC6);
        this.LIST_SUMMARY_TARGET_AUTO_IDS.addLast(record);
        StringBuffer buffer = new StringBuffer(512);
        if (log.isDebugEnabled()) {
            log.debug("EXEC TYPE ONE>" + record, (Object)this.QUERY_UPDATE_AUTO_RESULT_QUERY);
        }
        if (record.getProperty("ERROR_CODE").equals("00")) {
            StringConvertUtil.ConvertString(buffer, this.QUERY_UPDATE_AUTO_RESULT_QUERY_SUCCESS, record, "${", "}", true, false);
        } else {
            StringConvertUtil.ConvertString(buffer, this.QUERY_UPDATE_AUTO_RESULT_QUERY, record, "${", "}", true, false);
        }
        if (this.EMS_UPDATE_STMT.executeUpdate(buffer.toString()) > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Error_code update success");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error_code update fail");
        }
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("MMSAutoReceiver_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("MMSExecutor", (Object)"init error", (Object)thw);
    }
}

