/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.actor;

import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.util.FatigueListTableNameUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.AutoSendType;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.CommonColumn;
import com.humuson.tms.constrants.ErrorCode;
import java.io.File;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jupiter.common.actor.ListMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.UniqueKey;
import pluto.log.Composer;
import pluto.log.SmtpLogger;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;
import venus.spool.common.basic.NoTargetListException;
import venus.spool.common.handler.LongMappingSpooler;
import venus.spool.common.handler.SpoolFileObjectController;
import venus.spool.common.parser.SpoolHashParser;
import venus.spool.common.parser.SpoolHeaderParser;

public class BasicListMaker
extends SpoolFileObjectController
implements ListMaker {
    private static final Logger log = LoggerFactory.getLogger(BasicListMaker.class);
    private static String QUERY_UPDATE_STATE_INFO = null;
    private static String QUERY_SELECT_LIST_QUERY_INFO = null;
    private static String QUERY_INSERT_SCHEDULED_SEND_LIST = null;
    public static String QUERY_SELECT_TARGET_CNT = null;
    private static String QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE = null;
    private static String QUERY_DELETE_CURRENT_LIST = null;
    public static String QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE = null;
    private static String QUERY_UPDATE_SCHEDULED_SEND_LIST = null;
    private static String QUERY_UPDATE_MSG_ERROR = null;
    private static String QUERY_UPDATE_SCHEDULED_ERROR = null;
    private static String querySelectFatigueInfo = null;
    private static String querySelectMemberFatigueCount = null;
    private static String queryInsertOrUpdateFatigueList = null;
    public static String TMP_WORKING_DIRECTORY = null;
    public static int MAPPING_LIMIT = 1024;
    public static String MEMBER_INFO_ENCRYPT_YN = "N";
    public static String encKey = null;
    protected Properties SCHEDULE_INFO = null;
    protected Vector<ConnectInfo> VECTOR_QUERY_MAPPING_INFO = new Vector();
    protected Vector<ConnectInfo> VECTOR_QUERY_LIST_INFO = new Vector();
    protected Vector<ConnectInfo> VECTOR_QUERY_SIMPLE_MAPPING_INFO = new Vector();
    protected Vector<ConnectInfo> VECTOR_QUERY_BLOB_MAPPING_INFO = new Vector();
    protected Vector<ConnectInfo> VECTOR_QUERY_LOOP_MAPPING_INFO = new Vector();
    protected Vector<ConnectInfo> VECTOR_QUERY_UPDATE_INFO = new Vector();
    protected String LIST_STORE_FILE_NAME = null;
    protected String MAPPING_INFO_ADDED_FILE_NAME = null;
    protected String BLOB_MAPPING_INFO_ADDED_FILE_NAME = null;
    protected String LOOPING_INFO_ADDED_FILE_NAME = null;
    protected String INFO_ADDED_FINAL_FILE_NAME = null;
    protected String NEXT_BASE_INFO_FILE_NAME = null;
    protected String POST_ID = null;
    protected String WORKDAY = null;
    protected String SEQNO = null;
    protected String WORK_FILE_ID = null;
    protected SpoolHashParser AUTO_KEY_VALUE_PARSER = null;
    protected String MAPPING_HEADER = null;
    protected Composer composer = null;
    protected Map<String, String> __TMP_SIMPLE_HASH__ = new Hashtable<String, String>();
    protected Hashtable<String, String> __HEADER_MAP__ = new Hashtable();
    protected String MAIL_ID = "";
    protected String TMS_M_TOKEN_DECRYPT = "TMS_M_TOKEN_DECRYPT";
    protected String KEY_FILLER = "KEY_FILLER";
    protected String EMS_DB_URL = "";
    protected String EMS_DB_ID = "";
    protected String EMS_DB_PWD = "";
    private eMsPreparedStatement psMemberFatigueCount = null;
    private int fatigueDayLimitCount = 0;
    private int fatigueMonthLimitCount = 0;
    private int fatigueFilteredCount = 0;

    protected void inner_init(Properties prop) throws Exception {
        this.SCHEDULE_INFO = prop;
        this.composer = Composer.getComposerInstance();
        this.AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");
        this.SCHEDULE_INFO.setProperty("LUNARDAY", Cal.getLunarDate());
        this.WORKDAY = this.SCHEDULE_INFO.getProperty("WORKDAY");
        this.SEQNO = this.SCHEDULE_INFO.getProperty("SEQNO");
        this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");
        this.MAIL_ID = this.SCHEDULE_INFO.getProperty("MAIL_ID");
        this.setName("[" + this.MAIL_ID + "] " + this.POST_ID + "'s BasicListMaker");
        this.WORK_FILE_ID = this.POST_ID + "_real_" + Cal.getSerialDate();
    }

    @Override
    protected void inner_process(Properties prop) throws Exception {
        this.inner_init(prop);
        if (log.isDebugEnabled()) {
            log.debug("EXEC INFO=>".concat(this.SCHEDULE_INFO.toString()));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("execute_getConnectInfo START");
            }
            this.execute_getConnectInfo();
            if (log.isDebugEnabled()) {
                log.debug("execute_getConnectInfo END");
            }
            if (log.isDebugEnabled()) {
                log.debug("execute_QueryMappingInfoProcess START");
            }
            this.execute_QueryMappingInfoProcess();
            if (log.isDebugEnabled()) {
                log.debug("execute_QueryMappingInfoProcess END");
            }
            this.updateTaskState("11");
            if (log.isDebugEnabled()) {
                log.debug("execute_BasicInfoProcess START");
            }
            this.execute_BasicInfoProcess();
            if (log.isDebugEnabled()) {
                log.debug("execute_BasicInfoProcess END");
            }
            if (log.isDebugEnabled()) {
                log.debug("execute_MappingProcess START");
            }
            this.execute_MappingProcess();
            if (log.isDebugEnabled()) {
                log.debug("execute_MappingProcess END");
            }
            if (log.isDebugEnabled()) {
                log.debug("execute_MappingProcess START");
            }
            this.execute_BlobMappingProcess();
            if (log.isDebugEnabled()) {
                log.debug("execute_MappingProcess END");
            }
            if (log.isDebugEnabled()) {
                log.debug("execute_LoopingProcess START");
            }
            this.execute_LoopingProcess();
            if (log.isDebugEnabled()) {
                log.debug("execute_LoopingProcess END");
            }
            this.MAPPING_HEADER = this.SCHEDULE_INFO.getProperty("MAPPINGHEADER");
            this.updateTaskState("13");
        }
        catch (NoTargetListException e) {
            this.updateTaskState("19");
            return;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            this.updateTaskState("12");
            if (log.isDebugEnabled()) {
                log.debug("main process method END");
            }
            throw e;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("deleteCurrentList START");
            }
            this.deleteCurrentList();
            if (log.isDebugEnabled()) {
                log.debug("deleteCurrentList START");
            }
            this.updateTaskState("14");
            if (log.isDebugEnabled()) {
                log.debug("execute_DBInsertProcess START");
            }
            this.execute_DBInsertProcess();
            if (log.isDebugEnabled()) {
                log.debug("execute_DBInsertProcess END");
            }
            this.updateTaskState("16");
            if (log.isDebugEnabled()) {
                log.debug("execute_FinalProcess START");
            }
            this.execute_FinalProcess();
            if (log.isDebugEnabled()) {
                log.debug("execute_FinalProcess END");
            }
            this.updateTaskState("19");
        }
        catch (NoTargetListException e) {
            this.updateTaskState("19");
        }
        catch (Exception e) {
            this.updateTaskState("15");
            throw e;
        }
    }

    protected void execute_getConnectInfo() throws Exception {
        this.VECTOR_QUERY_LIST_INFO.clear();
        this.VECTOR_QUERY_SIMPLE_MAPPING_INFO.clear();
        this.VECTOR_QUERY_BLOB_MAPPING_INFO.clear();
        this.VECTOR_QUERY_LOOP_MAPPING_INFO.clear();
        this.VECTOR_QUERY_UPDATE_INFO.clear();
        this.VECTOR_QUERY_MAPPING_INFO.clear();
        eMsConnection EMS_CONNECTION = ConnectionPool.getConnection();
        ConnectInfo EMS_CON_INFO = eMsConnection.getConnectInfo("ems");
        this.EMS_DB_URL = EMS_CON_INFO.getDB_URL();
        this.EMS_DB_ID = EMS_CON_INFO.getDB_UID();
        this.EMS_DB_PWD = EMS_CON_INFO.getDB_PASS();
        eMsStatement __SELECT_STATEMENT__ = null;
        eMsResultSet rs = null;
        try {
            __SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
            StringBuffer buffer = new StringBuffer(512);
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_SELECT_LIST_QUERY_INFO, this.SCHEDULE_INFO, "${", "}", true, false);
            rs = __SELECT_STATEMENT__.executeQuery(buffer.toString());
            if (log.isDebugEnabled()) {
                log.debug("[================================================>]");
                log.debug("\ub300\uc0c1\uc790 \ub9ac\uc2a4\ud2b8 query[" + buffer.toString() + "]");
                log.debug("[================================================>]");
            }
            if (log.isDebugEnabled()) {
                log.debug("exec local=>", (Object)"OK");
            }
            Properties __TMP_CONNECT_INFOS__ = new Properties();
            block20: while (rs.next()) {
                __TMP_CONNECT_INFOS__.clear();
                rs.putToMap(__TMP_CONNECT_INFOS__, false);
                ConnectInfo __TMP_CONNECTION_INFO__ = null;
                switch (eMsConnection.GET_CONNECTION_TYPE) {
                    case 1: {
                        __TMP_CONNECTION_INFO__ = eMsConnection.getConnectInfo(__TMP_CONNECT_INFOS__.getProperty(eMsConnection.GET_CONNECTION_INDEX));
                        break;
                    }
                    default: {
                        __TMP_CONNECTION_INFO__ = new ConnectInfo();
                        __TMP_CONNECTION_INFO__.setDB_ID(this.getName());
                        __TMP_CONNECTION_INFO__.setDB_NAME(this.getName());
                        __TMP_CONNECTION_INFO__.setDRIVER(__TMP_CONNECT_INFOS__.getProperty("CONNECT_DRIVER"));
                        __TMP_CONNECTION_INFO__.setDB_URL(__TMP_CONNECT_INFOS__.getProperty("CONNECT_IP"));
                        __TMP_CONNECTION_INFO__.setDB_UID(__TMP_CONNECT_INFOS__.getProperty("CONNECT_ID"));
                        __TMP_CONNECTION_INFO__.setDB_PASS(__TMP_CONNECT_INFOS__.getProperty("CONNECT_PWD"));
                        __TMP_CONNECTION_INFO__.setDB_BASE_CHARSET(__TMP_CONNECT_INFOS__.getProperty("BASE_CHARSET"));
                        __TMP_CONNECTION_INFO__.setDB_IN_CHARSET(__TMP_CONNECT_INFOS__.getProperty("IN_CHARSET"));
                        __TMP_CONNECTION_INFO__.setDB_OUT_CHARSET(__TMP_CONNECT_INFOS__.getProperty("OUT_CHARSET"));
                        __TMP_CONNECTION_INFO__.setQUERY_SEQ(__TMP_CONNECT_INFOS__.getProperty("QUERY_SEQ"));
                        __TMP_CONNECTION_INFO__.setQUERY_TYPE(__TMP_CONNECT_INFOS__.getProperty("QUERY_TYPE"));
                        __TMP_CONNECTION_INFO__.setENCRYPT_YN(__TMP_CONNECT_INFOS__.getProperty("ENCRYPT_YN"));
                    }
                }
                __TMP_CONNECTION_INFO__.setQUERY(__TMP_CONNECT_INFOS__.getProperty("QUERY_SELECT"));
                if (log.isDebugEnabled()) {
                    log.debug("\ucffc\ub9ac \uc815\ubcf4 (" + Integer.parseInt(__TMP_CONNECT_INFOS__.getProperty("QUERY_TYPE")) + ") [" + __TMP_CONNECT_INFOS__.getProperty("QUERY_SELECT") + "]");
                }
                __TMP_CONNECTION_INFO__.setAPPEND_NULL(__TMP_CONNECT_INFOS__.getProperty("APPEND_NULL", "N").equalsIgnoreCase("Y"));
                if (log.isDebugEnabled()) {
                    log.debug("APPEND NULL : (" + __TMP_CONNECT_INFOS__.getProperty("APPEND_NULL") + ")");
                }
                switch (Integer.parseInt(__TMP_CONNECT_INFOS__.getProperty("QUERY_TYPE"))) {
                    case 10: {
                        this.VECTOR_QUERY_LIST_INFO.addElement(__TMP_CONNECTION_INFO__);
                        continue block20;
                    }
                    case 20: {
                        this.VECTOR_QUERY_SIMPLE_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
                        continue block20;
                    }
                    case 25: {
                        this.VECTOR_QUERY_BLOB_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
                        continue block20;
                    }
                    case 30: {
                        this.VECTOR_QUERY_LOOP_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
                        continue block20;
                    }
                    case 40: {
                        this.VECTOR_QUERY_UPDATE_INFO.addElement(__TMP_CONNECTION_INFO__);
                        continue block20;
                    }
                    case 50: {
                        this.VECTOR_QUERY_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
                        continue block20;
                    }
                }
                throw new RuntimeException("DB QUERY TYPE IS INVALID");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            if (EMS_CONNECTION != null) {
                if (__SELECT_STATEMENT__ != null) {
                    EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
                }
                EMS_CONNECTION.recycle();
            }
        }
        if (this.VECTOR_QUERY_LIST_INFO.size() != 1) {
            throw new RuntimeException("NO LIST QUERY or TOO MANY QUERY => " + this.VECTOR_QUERY_LIST_INFO.size());
        }
    }

    protected void execute_QueryMappingInfoProcess() throws Exception {
        int __QUERY_SIZE__ = this.VECTOR_QUERY_MAPPING_INFO.size();
        if (__QUERY_SIZE__ < 1) {
            if (log.isDebugEnabled()) {
                log.debug("NO QUERY  MAPPING INFO....");
            }
            return;
        }
        eMsConnection __TARGET_CONNECTION__ = null;
        eMsResultSet rs = null;
        eMsStatement stmt = null;
        ConnectInfo __TARGET_CONNECT_INFO__ = null;
        String __EXEC_TARGET_QUERY__ = null;
        StringBuffer buffer = new StringBuffer(1024);
        for (int i = 0; i < __QUERY_SIZE__; ++i) {
            __TARGET_CONNECT_INFO__ = this.VECTOR_QUERY_MAPPING_INFO.get(i);
            try {
                __TARGET_CONNECTION__ = this.checkConnectionInfo(__TARGET_CONNECT_INFO__) ? ConnectionPool.getConnection() : ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);
                stmt = __TARGET_CONNECTION__.createStatement();
                if (log.isDebugEnabled()) {
                    log.debug(".execute_QueryMappingInfoProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
                    log.debug(".execute_QueryMappingInfoProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
                    log.debug(".execute_QueryMappingInfoProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());
                }
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
                __EXEC_TARGET_QUERY__ = buffer.toString();
                if (log.isDebugEnabled()) {
                    log.debug(".execute_QueryMappingInfoProcess() exe query:" + __EXEC_TARGET_QUERY__);
                }
                rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);
                if (log.isDebugEnabled()) {
                    log.debug(".execute_QueryMappingInfoProcess() exe query:[OK]");
                }
                if (!rs.next()) continue;
                rs.putToMap(this.SCHEDULE_INFO, false);
                if (!log.isDebugEnabled()) continue;
                log.debug(this.SCHEDULE_INFO.toString());
                continue;
            }
            catch (Exception e) {
                log.error("target query error", __EXEC_TARGET_QUERY__);
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (__TARGET_CONNECTION__ != null) {
                        __TARGET_CONNECTION__.destroy();
                    }
                }
                catch (Exception ignore) {}
            }
        }
    }

    protected void execute_BasicInfoProcess() throws Exception {
        String this_day = Cal.getDayDate();
        this.LIST_STORE_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".base";
        this.openWriter(this.LIST_STORE_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.LIST_STORE_FILE_NAME;
        String __EXEC_TARGET_QUERY__ = null;
        eMsConnection __TARGET_CONNECTION__ = null;
        eMsResultSet rs = null;
        eMsStatement stmt = null;
        this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", "");
        ConnectInfo __TMP_CONNECTION_INFO__ = this.VECTOR_QUERY_LIST_INFO.get(0);
        boolean __APPEND_CHECK__ = false;
        StringBuffer buffer = new StringBuffer(1024);
        try {
            __TARGET_CONNECTION__ = this.checkConnectionInfo(__TMP_CONNECTION_INFO__) ? ConnectionPool.getConnection() : ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);
            stmt = __TARGET_CONNECTION__.createStatement();
            if (log.isDebugEnabled()) {
                log.debug(".execute_BasicInfoProcess() db:" + __TMP_CONNECTION_INFO__.toString());
            }
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
            __EXEC_TARGET_QUERY__ = buffer.toString();
            if (log.isDebugEnabled()) {
                log.debug(".execute_BasicInfoProcess() exe query:" + __EXEC_TARGET_QUERY__);
            }
            rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));
            if (log.isDebugEnabled()) {
                log.debug(".execute_BasicInfoProcess() exe query:[OK]");
            }
            String[] header_list = StringUtil.split(rs.getHeaderString(), "|");
            buffer.setLength(0);
            int decrypt_index = 0;
            int key_filler_index = 0;
            String temp_header = "";
            for (int i = 1; i <= header_list.length; ++i) {
                temp_header = header_list[i - 1];
                if (temp_header.equals(this.TMS_M_TOKEN_DECRYPT)) {
                    temp_header = "TMS_M_TOKEN";
                    decrypt_index = i;
                }
                if (temp_header.equals(this.KEY_FILLER)) {
                    temp_header = "SSLIFE_ID|EMS_M_SECURE";
                    key_filler_index = i;
                }
                if (i != 1) {
                    buffer.append("|");
                }
                buffer.append(temp_header);
            }
            this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
            if (log.isDebugEnabled()) {
                log.debug("TARGET MAPPINGHEADER : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
            }
            int colcount = rs.getColumnCount();
            String temp = "";
            while (rs.next()) {
                buffer.setLength(0);
                temp = decrypt_index == 1 ? CryptoUtil.enEmailAddr(rs.getString(1)) : (key_filler_index == 1 ? StringUtil.getKeyFillerValue(rs.getString(1)) : rs.getString(1));
                if (key_filler_index == 1) {
                    buffer.append(temp);
                } else {
                    DelimConvertor.encodeToBuffer(buffer, temp == null ? "" : temp.trim());
                }
                for (int count = 2; count <= colcount; ++count) {
                    buffer.append("|");
                    temp = decrypt_index == count ? CryptoUtil.enEmailAddr(rs.getString(count)) : (key_filler_index == count ? StringUtil.getKeyFillerValue(rs.getString(count)) : rs.getString(count));
                    if (key_filler_index == count) {
                        buffer.append(temp);
                        continue;
                    }
                    DelimConvertor.encodeToBuffer(buffer, temp == null ? "" : temp.trim());
                }
                this.BUFFERED_WRITER.write(buffer.toString());
                this.BUFFERED_WRITER.newLine();
                this.BUFFERED_WRITER.flush();
                __APPEND_CHECK__ = true;
                if (!log.isDebugEnabled()) continue;
                log.debug("LINE CREATE....");
            }
        }
        catch (Exception e) {
            if (!__APPEND_CHECK__) {
                if (log.isDebugEnabled()) {
                    log.debug("NO TARGET LIST....");
                }
                this.deleteWriter();
            } else {
                this.closeWriter();
            }
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ignore) {}
            try {
                __TARGET_CONNECTION__.destroy();
            }
            catch (Exception ignore) {}
        }
        if (!__APPEND_CHECK__) {
            if (log.isDebugEnabled()) {
                log.debug("NO TARGET LIST....");
            }
            this.deleteWriter();
            throw new NoTargetListException("NO TARGET LIST => " + this.POST_ID);
        }
        this.closeWriter();
    }

    protected void execute_MappingProcess() throws Exception {
        int __QUERY_SIZE__ = this.VECTOR_QUERY_SIMPLE_MAPPING_INFO.size();
        if (__QUERY_SIZE__ < 1) {
            if (log.isDebugEnabled()) {
                log.debug("NO MAPPING QUERY  INFO....");
            }
            return;
        }
        String this_day = Cal.getDayDate();
        this.MAPPING_INFO_ADDED_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".mapping";
        log.debug(".execute_MappingProcess() set spool file :" + this.MAPPING_INFO_ADDED_FILE_NAME);
        this.openWriter(this.MAPPING_INFO_ADDED_FILE_NAME);
        log.debug(".execute_MappingProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
        this.openReader(this.NEXT_BASE_INFO_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.MAPPING_INFO_ADDED_FILE_NAME;
        ConnectInfo __TARGET_CONNECT_INFO__ = null;
        String __EXEC_TARGET_QUERY__ = null;
        boolean __APPEND_CHECK__ = false;
        eMsConnection __TARGET_CONNECTION__ = null;
        eMsStatement stmt = null;
        eMsPreparedStatement __PS_TARGET_QUERY__ = null;
        eMsResultSet rs = null;
        String __TMP_HEADER_STRING__ = null;
        String __TMP_READ_LINE__ = null;
        StringBuffer buffer = new StringBuffer(1024);
        for (int i = 0; i < __QUERY_SIZE__; ++i) {
            try {
                if (i > 0) {
                    log.debug(".execute_MappingProcess() set switch file :" + this.MAPPING_INFO_ADDED_FILE_NAME + "=>" + this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    File rename = new File(this.MAPPING_INFO_ADDED_FILE_NAME);
                    File target = new File(this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    if (target.exists()) {
                        try {
                            target.delete();
                        }
                        catch (Exception e) {
                            log.error(this.getName(), (Throwable)e);
                        }
                    }
                    if (rename.renameTo(new File(this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i)))) {
                        log.info("Rename Success");
                    } else {
                        log.info("Rename Fail");
                    }
                    log.info(".execute_MappingProcess() set spool file :" + this.MAPPING_INFO_ADDED_FILE_NAME);
                    this.openWriter(this.MAPPING_INFO_ADDED_FILE_NAME);
                    log.info(".execute_MappingProcess() set source file :" + this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    this.openReader(this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                }
                __TARGET_CONNECTION__ = this.checkConnectionInfo(__TARGET_CONNECT_INFO__ = this.VECTOR_QUERY_SIMPLE_MAPPING_INFO.get(i)) ? ConnectionPool.getConnection() : ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);
                log.debug(".execute_MappingProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
                log.debug(".execute_MappingProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
                log.debug(".execute_MappingProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
                __EXEC_TARGET_QUERY__ = buffer.toString();
                boolean __QUERY_SECOND_MAPPING_FLAG__ = false;
                if (__EXEC_TARGET_QUERY__.indexOf("@{") > 0) {
                    SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", this.__HEADER_MAP__);
                    __PS_TARGET_QUERY__ = new eMsPreparedStatement(__EXEC_TARGET_QUERY__, "@{", "}");
                    __PS_TARGET_QUERY__.connectTo(__TARGET_CONNECTION__);
                    __QUERY_SECOND_MAPPING_FLAG__ = true;
                } else {
                    stmt = __TARGET_CONNECTION__.createStatement();
                }
                __TMP_HEADER_STRING__ = null;
                int colcount = 0;
                while (this.BUFFERED_READER.ready()) {
                    __TMP_READ_LINE__ = this.BUFFERED_READER.readLine();
                    if (log.isDebugEnabled()) {
                        log.debug(" read => " + __TMP_READ_LINE__);
                    }
                    if (__TMP_READ_LINE__ == null || __TMP_READ_LINE__.trim().length() < 1) continue;
                    if (__QUERY_SECOND_MAPPING_FLAG__) {
                        this.AUTO_KEY_VALUE_PARSER.parseSimple(this.__TMP_SIMPLE_HASH__, __TMP_READ_LINE__, this.__HEADER_MAP__);
                        rs = __PS_TARGET_QUERY__.executeQuery(this.__TMP_SIMPLE_HASH__);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("exec query", (Object)__EXEC_TARGET_QUERY__);
                        }
                        rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));
                    }
                    int decrypt_index = 0;
                    int key_filler_index = 0;
                    if (__TMP_HEADER_STRING__ == null) {
                        __TMP_HEADER_STRING__ = rs.getHeaderString();
                        String[] header_list = StringUtil.split(__TMP_HEADER_STRING__, "|");
                        buffer.setLength(0);
                        String temp_header = "";
                        for (int i1 = 1; i1 <= header_list.length; ++i1) {
                            temp_header = header_list[i1 - 1];
                            if (temp_header.equals(this.TMS_M_TOKEN_DECRYPT)) {
                                temp_header = "TMS_M_TOKEN";
                                decrypt_index = i1;
                            }
                            if (temp_header.equals(this.KEY_FILLER)) {
                                temp_header = "SSLIFE_ID|EMS_M_SECURE";
                                key_filler_index = i1;
                            }
                            if (i1 != 1) {
                                buffer.append("|");
                            }
                            buffer.append(temp_header);
                        }
                        if (decrypt_index > 0 || key_filler_index > 0) {
                            __TMP_HEADER_STRING__ = buffer.toString();
                        }
                        buffer.setLength(0);
                        buffer.append(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
                        buffer.append("|");
                        buffer.append(__TMP_HEADER_STRING__);
                        this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
                        if (log.isDebugEnabled()) {
                            log.debug("HEADER SETTING : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
                        }
                    }
                    colcount = rs.getColumnCount();
                    if (rs.next()) {
                        do {
                            this.BUFFERED_WRITER.write(__TMP_READ_LINE__);
                            buffer.setLength(0);
                            String temp = "";
                            for (int count = 1; count <= colcount; ++count) {
                                buffer.append("|");
                                temp = decrypt_index == count ? CryptoUtil.enEmailAddr(rs.getString(count).trim()) : (key_filler_index == count ? StringUtil.getKeyFillerValue(rs.getString(count).trim()) : rs.getString(count).trim());
                                if (key_filler_index == count) {
                                    buffer.append(temp);
                                    continue;
                                }
                                DelimConvertor.encodeToBuffer(buffer, temp);
                            }
                            this.BUFFERED_WRITER.write(buffer.toString());
                            this.BUFFERED_WRITER.newLine();
                            this.BUFFERED_WRITER.flush();
                        } while (rs.next());
                        __APPEND_CHECK__ = true;
                        continue;
                    }
                    if (!__TARGET_CONNECT_INFO__.isAPPEND_NULL()) continue;
                    this.BUFFERED_WRITER.write(__TMP_READ_LINE__);
                    for (int count = 1; count <= colcount; ++count) {
                        this.BUFFERED_WRITER.write("| ");
                    }
                    this.BUFFERED_WRITER.newLine();
                    this.BUFFERED_WRITER.flush();
                    __APPEND_CHECK__ = true;
                }
            }
            catch (Exception e) {
                log.error(this.getName(), __EXEC_TARGET_QUERY__);
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignore) {}
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {}
                }
                if (__PS_TARGET_QUERY__ != null) {
                    try {
                        __PS_TARGET_QUERY__.close();
                    }
                    catch (Exception ignore) {}
                }
                try {
                    if (__TARGET_CONNECTION__ != null) {
                        __TARGET_CONNECTION__.destroy();
                    }
                }
                catch (Exception ignore) {}
                if (!__APPEND_CHECK__) {
                    if (log.isDebugEnabled()) {
                        log.debug("NO MAPPING REAULT RECORD so skip => " + this.POST_ID);
                    }
                    this.deleteWriter();
                } else {
                    this.closeWriter();
                    if (log.isDebugEnabled()) {
                        log.debug("MAPPING STEP CLEAR => " + this.POST_ID);
                    }
                }
                this.closeReader();
            }
            if (__APPEND_CHECK__) continue;
            throw new NoTargetListException("NO MAPPING REAULT RECORD so skip.. => " + this.POST_ID);
        }
    }

    protected void execute_BlobMappingProcess() throws Exception {
        int __QUERY_SIZE__ = this.VECTOR_QUERY_BLOB_MAPPING_INFO.size();
        if (__QUERY_SIZE__ < 1) {
            if (log.isDebugEnabled()) {
                log.debug("NO BLOB MAPPING QUERY  INFO....");
            }
            return;
        }
        String this_day = Cal.getDayDate();
        this.BLOB_MAPPING_INFO_ADDED_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".blob";
        log.debug(".execute_BlobMappingProcess() set spool file :" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);
        this.openWriter(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);
        log.debug(".execute_BlobMappingProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
        this.openReader(this.NEXT_BASE_INFO_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.BLOB_MAPPING_INFO_ADDED_FILE_NAME;
        ConnectInfo __TARGET_CONNECT_INFO__ = null;
        String __EXEC_TARGET_QUERY__ = null;
        boolean __APPEND_CHECK__ = false;
        eMsConnection __TARGET_CONNECTION__ = null;
        eMsStatement stmt = null;
        eMsPreparedStatement __PS_TARGET_QUERY__ = null;
        eMsResultSet rs = null;
        String __TMP_HEADER_STRING__ = null;
        String __TMP_READ_LINE__ = null;
        StringBuffer buffer = new StringBuffer(1024);
        for (int i = 0; i < __QUERY_SIZE__; ++i) {
            try {
                if (i > 0) {
                    log.debug(".execute_BlobMappingProcess() set switch file :" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "=>" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    File rename = new File(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);
                    File target = new File(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    if (target.exists()) {
                        try {
                            target.delete();
                        }
                        catch (Exception e) {
                            log.error(this.getName(), (Throwable)e);
                        }
                    }
                    if (rename.renameTo(new File(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i)))) {
                        log.debug("Rename Success");
                    } else {
                        log.debug("Rename Fail");
                    }
                    log.debug(".execute_BlobMappingProcess() set spool file :" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);
                    this.openWriter(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);
                    log.debug(".execute_BlobMappingProcess() set source file :" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    this.openReader(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                }
                __TARGET_CONNECTION__ = this.checkConnectionInfo(__TARGET_CONNECT_INFO__ = this.VECTOR_QUERY_BLOB_MAPPING_INFO.get(i)) ? ConnectionPool.getConnection() : ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);
                log.debug(".execute_BlobMappingProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
                log.debug(".execute_BlobMappingProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
                log.debug(".execute_BlobMappingProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
                __EXEC_TARGET_QUERY__ = buffer.toString();
                boolean __QUERY_SECOND_MAPPING_FLAG__ = false;
                if (__EXEC_TARGET_QUERY__.indexOf("@{") > 0) {
                    SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", this.__HEADER_MAP__);
                    __PS_TARGET_QUERY__ = new eMsPreparedStatement(__EXEC_TARGET_QUERY__, "@{", "}");
                    __PS_TARGET_QUERY__.connectTo(__TARGET_CONNECTION__);
                    __QUERY_SECOND_MAPPING_FLAG__ = true;
                } else {
                    stmt = __TARGET_CONNECTION__.createStatement();
                }
                __TMP_HEADER_STRING__ = null;
                while (this.BUFFERED_READER.ready()) {
                    __TMP_READ_LINE__ = this.BUFFERED_READER.readLine();
                    if (log.isDebugEnabled()) {
                        log.debug(" read => " + __TMP_READ_LINE__);
                    }
                    if (__TMP_READ_LINE__ == null || __TMP_READ_LINE__.trim().length() < 1) continue;
                    if (__QUERY_SECOND_MAPPING_FLAG__) {
                        this.AUTO_KEY_VALUE_PARSER.parseSimple(this.__TMP_SIMPLE_HASH__, __TMP_READ_LINE__, this.__HEADER_MAP__);
                        rs = __PS_TARGET_QUERY__.executeQuery(this.__TMP_SIMPLE_HASH__);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("exec query", (Object)__EXEC_TARGET_QUERY__);
                        }
                        rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));
                    }
                    if (__TMP_HEADER_STRING__ == null) {
                        __TMP_HEADER_STRING__ = rs.getHeaderString();
                        buffer.setLength(0);
                        buffer.append(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
                        buffer.append("|");
                        buffer.append(__TMP_HEADER_STRING__);
                        this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
                        if (log.isDebugEnabled()) {
                            log.debug("HEADER SETTING : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
                        }
                    }
                    if (!rs.next()) continue;
                    do {
                        try {
                            buffer.setLength(0);
                            DelimConvertor.encodeToBuffer(buffer, rs.getCharStreamAsString(1));
                        }
                        catch (Exception e) {
                            log.error(this.getName(), (Throwable)e);
                            continue;
                        }
                        this.BUFFERED_WRITER.write(__TMP_READ_LINE__);
                        this.BUFFERED_WRITER.write("|");
                        this.BUFFERED_WRITER.write(buffer.toString());
                        this.BUFFERED_WRITER.newLine();
                        this.BUFFERED_WRITER.flush();
                    } while (rs.next());
                    __APPEND_CHECK__ = true;
                }
            }
            catch (Exception e) {
                log.error(this.getName(), __EXEC_TARGET_QUERY__);
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignore) {}
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {}
                }
                if (__PS_TARGET_QUERY__ != null) {
                    try {
                        __PS_TARGET_QUERY__.close();
                    }
                    catch (Exception ignore) {}
                }
                try {
                    __TARGET_CONNECTION__.destroy();
                }
                catch (Exception ignore) {}
                if (!__APPEND_CHECK__) {
                    if (log.isDebugEnabled()) {
                        log.debug("NO MAPPING REAULT RECORD so skip => " + this.POST_ID);
                    }
                    this.deleteWriter();
                } else {
                    this.closeWriter();
                    if (log.isDebugEnabled()) {
                        log.debug("MAPPING STEP CLEAR => " + this.POST_ID);
                    }
                }
                this.closeReader();
            }
            if (__APPEND_CHECK__) continue;
            throw new NoTargetListException("NO MAPPING REAULT RECORD so skip.. => " + this.POST_ID);
        }
    }

    protected void execute_LoopingProcess() throws Exception {
        int __QUERY_SIZE__ = this.VECTOR_QUERY_LOOP_MAPPING_INFO.size();
        if (__QUERY_SIZE__ < 1) {
            if (log.isDebugEnabled()) {
                log.debug("NO LOOPING QUERY INFO....");
            }
            return;
        }
        String this_day = Cal.getDayDate();
        this.LOOPING_INFO_ADDED_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".looping";
        log.debug(".execute_LoopingProcess() set spool file :" + this.LOOPING_INFO_ADDED_FILE_NAME);
        this.openWriter(this.LOOPING_INFO_ADDED_FILE_NAME);
        log.debug(".execute_LoopingProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
        this.openReader(this.NEXT_BASE_INFO_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.LOOPING_INFO_ADDED_FILE_NAME;
        ConnectInfo __TARGET_CONNECT_INFO__ = null;
        String __EXEC_TARGET_QUERY__ = null;
        boolean __APPEND_CHECK__ = false;
        eMsConnection __TARGET_CONNECTION__ = null;
        eMsStatement stmt = null;
        eMsPreparedStatement __EMS_PS__ = null;
        eMsResultSet rs = null;
        String __TMP_HEADER_STRING__ = null;
        String __TMP_READ_LINE__ = null;
        StringBuffer buffer = new StringBuffer(1024);
        for (int i = 0; i < __QUERY_SIZE__; ++i) {
            try {
                if (i > 0) {
                    log.debug(".execute_LoopingProcess() set switch file :" + this.LOOPING_INFO_ADDED_FILE_NAME + "=>" + this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    File rename = new File(this.LOOPING_INFO_ADDED_FILE_NAME);
                    File target = new File(this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    if (target.exists()) {
                        try {
                            target.delete();
                        }
                        catch (Exception e) {
                            log.error(this.getName(), (Throwable)e);
                        }
                    }
                    if (rename.renameTo(new File(this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i)))) {
                        if (log.isDebugEnabled()) {
                            log.debug("Rename Success");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("Rename Fail");
                    }
                    log.debug(".execute_LoopingProcess() set spool file :" + this.LOOPING_INFO_ADDED_FILE_NAME);
                    this.openWriter(this.LOOPING_INFO_ADDED_FILE_NAME);
                    log.debug(".execute_LoopingProcess() set source file :" + this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                    this.openReader(this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
                }
                __TARGET_CONNECTION__ = this.checkConnectionInfo(__TARGET_CONNECT_INFO__ = this.VECTOR_QUERY_LOOP_MAPPING_INFO.get(i)) ? ConnectionPool.getConnection() : ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);
                log.debug(".execute_LoopingProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
                log.debug(".execute_LoopingProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
                log.debug(".execute_LoopingProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
                __EXEC_TARGET_QUERY__ = buffer.toString();
                boolean __QUERY_SECOND_MAPPING_FLAG__ = false;
                if (__EXEC_TARGET_QUERY__.indexOf("@{") > 0) {
                    SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", this.__HEADER_MAP__);
                    __EMS_PS__ = new eMsPreparedStatement(__EXEC_TARGET_QUERY__, "@{", "}");
                    __EMS_PS__.connectTo(__TARGET_CONNECTION__);
                    __QUERY_SECOND_MAPPING_FLAG__ = true;
                } else {
                    stmt = __TARGET_CONNECTION__.createStatement();
                }
                __TMP_HEADER_STRING__ = null;
                int colcount = 0;
                boolean ONE_LINE_USE = false;
                String BASE_REAL_ROW = "BASE_REAL_ROW";
                while (this.BUFFERED_READER.ready()) {
                    int count;
                    __TMP_READ_LINE__ = this.BUFFERED_READER.readLine();
                    if (log.isDebugEnabled()) {
                        log.debug(" read => " + __TMP_READ_LINE__);
                    }
                    if (__TMP_READ_LINE__ == null || __TMP_READ_LINE__.trim().length() < 1) continue;
                    if (__QUERY_SECOND_MAPPING_FLAG__) {
                        this.AUTO_KEY_VALUE_PARSER.parseSimple(this.__TMP_SIMPLE_HASH__, __TMP_READ_LINE__, this.__HEADER_MAP__);
                        rs = __EMS_PS__.executeQuery(this.__TMP_SIMPLE_HASH__);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug(__EXEC_TARGET_QUERY__);
                        }
                        rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));
                    }
                    if (__TMP_HEADER_STRING__ == null) {
                        __TMP_HEADER_STRING__ = rs.getHeaderString();
                        if (__TMP_HEADER_STRING__.indexOf(BASE_REAL_ROW) > 0) {
                            ONE_LINE_USE = true;
                            log.debug("[ONE_LINE_USE]" + ONE_LINE_USE);
                        }
                        buffer.setLength(0);
                        buffer.append(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
                        buffer.append("[");
                        buffer.append(__TMP_HEADER_STRING__);
                        buffer.append("]");
                        this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
                        if (log.isDebugEnabled()) {
                            log.debug("HEADER SETTING : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
                        }
                    }
                    colcount = rs.getColumnCount();
                    boolean isnull_flag = false;
                    if (ONE_LINE_USE) {
                        if (rs.next()) {
                            this.BUFFERED_WRITER.write(__TMP_READ_LINE__);
                            buffer.setLength(0);
                            buffer.append("[");
                            do {
                                buffer.append("{");
                                DelimConvertor.encodeToBuffer(buffer, rs.getString(BASE_REAL_ROW).trim());
                                buffer.append("}");
                            } while (rs.next());
                            __APPEND_CHECK__ = true;
                            buffer.append("]");
                            this.BUFFERED_WRITER.write(buffer.toString().replaceAll("\\^%\\^", "|"));
                            this.BUFFERED_WRITER.newLine();
                            this.BUFFERED_WRITER.flush();
                        } else {
                            isnull_flag = true;
                        }
                    } else if (rs.next()) {
                        this.BUFFERED_WRITER.write(__TMP_READ_LINE__);
                        buffer.setLength(0);
                        buffer.append("[");
                        do {
                            buffer.append("{");
                            DelimConvertor.encodeToBuffer(buffer, rs.getString(1));
                            for (count = 2; count <= colcount; ++count) {
                                buffer.append("|");
                                DelimConvertor.encodeToBuffer(buffer, rs.getString(count));
                            }
                            buffer.append("}");
                        } while (rs.next());
                        __APPEND_CHECK__ = true;
                        buffer.append("]");
                        this.BUFFERED_WRITER.write(buffer.toString());
                        this.BUFFERED_WRITER.newLine();
                        this.BUFFERED_WRITER.flush();
                    } else {
                        isnull_flag = true;
                    }
                    if (!isnull_flag || !__TARGET_CONNECT_INFO__.isAPPEND_NULL()) continue;
                    this.BUFFERED_WRITER.write(__TMP_READ_LINE__);
                    this.BUFFERED_WRITER.write("[");
                    do {
                        this.BUFFERED_WRITER.write("{");
                        this.BUFFERED_WRITER.write(" ");
                        for (count = 2; count <= colcount; ++count) {
                            this.BUFFERED_WRITER.write("| ");
                        }
                        this.BUFFERED_WRITER.write("}");
                    } while (rs.next());
                    this.BUFFERED_WRITER.write("]");
                    this.BUFFERED_WRITER.newLine();
                    this.BUFFERED_WRITER.flush();
                    __APPEND_CHECK__ = true;
                }
            }
            catch (Exception e) {
                log.error(this.getName(), (Object)("==>" + __EXEC_TARGET_QUERY__));
                if (!__APPEND_CHECK__) {
                    this.deleteWriter();
                } else {
                    this.closeWriter();
                    if (log.isDebugEnabled()) {
                        log.debug("LOOPING STEP CLEAR => " + this.POST_ID);
                    }
                }
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignore) {}
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ignore) {}
                }
                if (__EMS_PS__ != null) {
                    try {
                        __EMS_PS__.close();
                    }
                    catch (Exception ignore) {}
                }
                try {
                    __TARGET_CONNECTION__.destroy();
                }
                catch (Exception ignore) {}
                this.closeReader();
            }
            if (!__APPEND_CHECK__) {
                this.deleteWriter();
                throw new NoTargetListException("NO LOOPING REAULT RECORD so skip.. => " + this.POST_ID);
            }
            this.closeWriter();
            if (!log.isDebugEnabled()) continue;
            log.debug("LOOPING STEP CLEAR => " + this.POST_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_DBInsertProcess() throws Exception {
        String workId = Cal.getSerialDate();
        this.SCHEDULE_INFO.setProperty("WORK_ID", workId);
        this.INFO_ADDED_FINAL_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, Cal.getDayDate()) + "/" + this.WORK_FILE_ID + ".infoadd";
        if (log.isDebugEnabled()) {
            log.debug(".execute_DBInsertProcess() set spool file: {}", (Object)this.INFO_ADDED_FINAL_FILE_NAME);
        }
        this.openWriter(this.INFO_ADDED_FINAL_FILE_NAME);
        if (log.isDebugEnabled()) {
            log.debug(".execute_DBInsertProcess() set source file: {}", (Object)this.NEXT_BASE_INFO_FILE_NAME);
        }
        this.openReader(this.NEXT_BASE_INFO_FILE_NAME);
        this.NEXT_BASE_INFO_FILE_NAME = this.INFO_ADDED_FINAL_FILE_NAME;
        eMsConnection emsConnection = null;
        eMsStatement stmtFatigueInfo = null;
        eMsPreparedStatement psFatigueInsertOrUpdateList = null;
        eMsPreparedStatement psSendListInsert = null;
        eMsPreparedStatement psSelectNextSeq = null;
        eMsResultSet rsFatigueInfo = null;
        eMsResultSet rsNextSeq = null;
        String tmpReadLine = null;
        StringBuffer buffer = new StringBuffer(1024);
        log.debug(".execute_DBInsertProcess() in SCHEDULE_INFO: {}", (Object)this.SCHEDULE_INFO);
        try {
            emsConnection = ConnectionPool.getConnection();
            String channel = this.SCHEDULE_INFO.getProperty("CHANNEL_TYPE");
            if (channel == null || "".equals(channel)) {
                channel = this.SCHEDULE_INFO.getProperty("CHANNEL");
            }
            String fatigueTableName = FatigueListTableNameUtil.getFatigueListTableName((String)channel);
            boolean isFatigue = this.isUseFatigue();
            if (isFatigue) {
                stmtFatigueInfo = emsConnection.createStatement();
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, querySelectFatigueInfo, this.SCHEDULE_INFO, "${", "}", true, false);
                rsFatigueInfo = stmtFatigueInfo.executeQuery(buffer.toString());
                if (rsFatigueInfo.next()) {
                    this.fatigueDayLimitCount = rsFatigueInfo.getInt("DAY_LIMIT");
                    this.fatigueMonthLimitCount = rsFatigueInfo.getInt("MON_LIMIT");
                }
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, querySelectMemberFatigueCount.replace("${FATIGUE_TABLE}", fatigueTableName), this.SCHEDULE_INFO, "${", "}", true, false);
                this.psMemberFatigueCount = new eMsPreparedStatement(buffer.toString(), "@{", "}");
                this.psMemberFatigueCount.connectTo(emsConnection);
            }
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, queryInsertOrUpdateFatigueList.replace("${FATIGUE_TABLE}", fatigueTableName), this.SCHEDULE_INFO, "${", "}", true, false);
            psFatigueInsertOrUpdateList = new eMsPreparedStatement(buffer.toString(), "@{", "}");
            psFatigueInsertOrUpdateList.connectTo(emsConnection);
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_INSERT_SCHEDULED_SEND_LIST, this.SCHEDULE_INFO, "${", "}", true, false);
            psSendListInsert = new eMsPreparedStatement(buffer.toString(), "@{", "}");
            psSendListInsert.connectTo(emsConnection);
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE, this.SCHEDULE_INFO, "${", "}", true, false);
            psSelectNextSeq = new eMsPreparedStatement(buffer.toString(), "@{", "}");
            psSelectNextSeq.connectTo(emsConnection);
            SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", this.__HEADER_MAP__);
            log.debug("Souce File Read Ready");
            while (this.BUFFERED_READER.ready()) {
                tmpReadLine = this.BUFFERED_READER.readLine();
                if (log.isDebugEnabled()) {
                    log.debug("read => {}", (Object)tmpReadLine);
                }
                if (tmpReadLine == null || tmpReadLine.trim().length() < 1) continue;
                try {
                    this.AUTO_KEY_VALUE_PARSER.parseSimple(this.__TMP_SIMPLE_HASH__, tmpReadLine, this.__HEADER_MAP__);
                }
                catch (Exception e) {
                    log.error(this.getName() + " ID/NAME/EMAIL POPUP FAIL => " + tmpReadLine, (Throwable)e);
                    continue;
                }
                String mapping = null;
                mapping = tmpReadLine.length() > MAPPING_LIMIT ? this.StoreLongMapping(this.WORKDAY, this.SEQNO, tmpReadLine) : tmpReadLine;
                if (mapping == null) {
                    log.error(this.getName() + " Mapping is null Or Store Filename is NULL.... so skip=>" + tmpReadLine);
                    continue;
                }
                this.__TMP_SIMPLE_HASH__.put("MAPPING", mapping);
                if (!this.__TMP_SIMPLE_HASH__.containsKey("TMS_M_ID_SEQ")) {
                    this.__TMP_SIMPLE_HASH__.put("TMS_M_ID_SEQ", UniqueKey.getSerial());
                }
                this.__TMP_SIMPLE_HASH__.put("WORK_ID", workId);
                String channelType = this.SCHEDULE_INFO.getProperty(CommonColumn.CHANNEL_TYPE.getCode(), ChannelType.EMAIL.getCode());
                this.getMemberToken(channelType, this.__TMP_SIMPLE_HASH__);
                String email = this.__TMP_SIMPLE_HASH__.get(CommonColumn.TMS_M_TOKEN.getCode());
                if (ChannelType.EMAIL.getCode().equals(channelType)) {
                    if ("Y".equals(this.VECTOR_QUERY_LIST_INFO.get(0).getENCRYPT_YN()) || email.indexOf(64) < 0) {
                        try {
                            email = HumusonDecryptor.decrypt((String)this.__TMP_SIMPLE_HASH__.get(CommonColumn.TMS_M_TOKEN.getCode()), (String)encKey, (boolean)false);
                        }
                        catch (Exception e) {
                            log.error("email decrypt error [{}] msg:{}", (Object)email, (Object)e.getMessage());
                        }
                    }
                    if (StringUtils.isEmailError((String)email)) continue;
                }
                this.__TMP_SIMPLE_HASH__.put("DOMAIN", StringUtils.getDomain((String)email));
                String oriVal = "";
                String encVal = "";
                try {
                    if (this.__TMP_SIMPLE_HASH__.containsKey(CommonColumn.TMS_M_TOKEN.getCode()) && "Y".equals(MEMBER_INFO_ENCRYPT_YN) && !"Y".equals(this.VECTOR_QUERY_LIST_INFO.get(0).getENCRYPT_YN())) {
                        oriVal = this.__TMP_SIMPLE_HASH__.get(CommonColumn.TMS_M_TOKEN.getCode());
                        if (oriVal != null && !"".equals(oriVal)) {
                            encVal = CryptoUtil.enEmailAddr(oriVal.trim());
                        }
                        this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), encVal);
                    }
                }
                catch (Exception e) {
                    log.error(this.getName() + " email encrypt fail ==> " + oriVal, (Throwable)e);
                }
                this.__TMP_SIMPLE_HASH__.put(CommonColumn.SEND_STATE.getCode(), "NY");
                if (isFatigue) {
                    this.checkFatigue();
                }
                log.debug("__TMP_SIMPLE_HASH__... {}", this.__TMP_SIMPLE_HASH__);
                try {
                    try {
                        if (psSendListInsert.executeUpdate(this.__TMP_SIMPLE_HASH__) < 1) {
                            log.error(this.getName(), (Object)"INSERT AFFECT 0");
                        }
                    }
                    catch (SQLException dup) {
                        String nextMemberSeq = "";
                        try {
                            rsNextSeq = psSelectNextSeq.executeQuery(this.__TMP_SIMPLE_HASH__);
                            if (rsNextSeq.next()) {
                                String string = nextMemberSeq = rsNextSeq.getString(1) == null ? "" : rsNextSeq.getString(1);
                            }
                            if (!"".equals(nextMemberSeq)) {
                                this.__TMP_SIMPLE_HASH__.put("TMS_M_ID_SEQ", nextMemberSeq);
                                if (psSendListInsert.executeUpdate(this.__TMP_SIMPLE_HASH__) < 1) {
                                    log.error(this.getName(), (Object)"INSERT AFFECT 0");
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error(this.getName() + " MAX SEQ SELECT FAIL....so skip..", (Throwable)e);
                        }
                        finally {
                            if (rsNextSeq != null) {
                                rsNextSeq.close();
                            }
                        }
                    }
                    this.BUFFERED_WRITER.write(this.__TMP_SIMPLE_HASH__.get("TMS_M_ID_SEQ").toString());
                    this.BUFFERED_WRITER.write("|");
                    this.BUFFERED_WRITER.write(tmpReadLine);
                    this.BUFFERED_WRITER.newLine();
                    this.BUFFERED_WRITER.flush();
                    if (psFatigueInsertOrUpdateList.executeUpdate(this.__TMP_SIMPLE_HASH__) >= 1) continue;
                    log.error(this.getName(), (Object)("TMS_FATIGUE_LIST not inserted or updated. [ " + this.__TMP_SIMPLE_HASH__ + " ]"));
                }
                catch (Exception ignore) {
                    log.error(this.getName(), (Object)"INSERT RETRY ERR.. so skip.", (Object)ignore);
                }
            }
            log.debug("Souce File Read Done");
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            if (rsFatigueInfo != null) {
                rsFatigueInfo.close();
            }
            if (stmtFatigueInfo != null) {
                stmtFatigueInfo.close();
            }
            if (psFatigueInsertOrUpdateList != null) {
                psFatigueInsertOrUpdateList.close();
            }
            if (psSelectNextSeq != null) {
                psSelectNextSeq.close();
            }
            if (psSendListInsert != null) {
                psSendListInsert.close();
            }
            if (emsConnection != null) {
                emsConnection.recycle();
            }
            if (this.BUFFERED_READER != null) {
                try {
                    this.BUFFERED_READER.close();
                }
                catch (Exception e) {}
            }
            if (this.BUFFERED_WRITER != null) {
                try {
                    this.BUFFERED_WRITER.flush();
                    this.BUFFERED_WRITER.close();
                }
                catch (Exception e) {}
            }
            log.debug("Exit Souce File Read Routine");
        }
        this.exec_CountUpdate();
    }

    protected void exec_CountUpdate() throws Exception {
        eMsConnection emsConnection = null;
        eMsStatement emsStmt = null;
        eMsResultSet emsRs = null;
        StringBuffer buffer = new StringBuffer(512);
        try {
            emsConnection = ConnectionPool.getConnection();
            emsStmt = emsConnection.createStatement();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_SELECT_TARGET_CNT, this.SCHEDULE_INFO, "${", "}", true, false);
            emsRs = emsStmt.executeQuery(buffer.toString(), 3600);
            if (!emsRs.next()) {
                throw new RuntimeException("Target Cnt Select Error");
            }
            emsRs.putToMap(this.SCHEDULE_INFO, false);
            this.SCHEDULE_INFO.setProperty(CommonColumn.FILTER_CNT.getCode(), String.valueOf(this.fatigueFilteredCount));
            log.debug("exec_CountUpdate() in SCHEDULE_INFO: {}", (Object)this.SCHEDULE_INFO);
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE, this.SCHEDULE_INFO, "${", "}", true, false);
            log.debug("exec_CountUpdate() in QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE: {}", (Object)buffer.toString());
            emsStmt.executeUpdate(buffer.toString());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (emsRs != null) {
                emsRs.close();
            }
            if (emsConnection != null) {
                if (emsStmt != null) {
                    emsConnection.recycleStatement(emsStmt);
                }
                emsConnection.recycle();
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void execute_FinalProcess() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String StoreLongMapping(String __WORKDAY__, String __SEQNO__, String __MAPPING__) throws Exception {
        if (this.__INNER_LONG_MAPPING_SPOOLER__ == null) {
            this.__INNER_LONG_MAPPING_SPOOLER__ = new LongMappingSpooler(__WORKDAY__.concat("_").concat(__SEQNO__).concat(".mapping"));
        }
        return this.__INNER_LONG_MAPPING_SPOOLER__.put(__MAPPING__);
    }

    @Override
    public Object getTargetList() {
        throw new RuntimeException("Not Implements");
    }

    @Override
    public String getMAPPING_HEADER() {
        return this.MAPPING_HEADER;
    }

    @Override
    public String getID() {
        return this.WORKDAY == null ? null : this.WORKDAY + "_" + this.SEQNO;
    }

    protected void deleteCurrentList() throws Exception {
        eMsConnection emsConnection = null;
        eMsStatement emsStmt = null;
        StringBuffer buffer = new StringBuffer(512);
        try {
            emsConnection = ConnectionPool.getConnection();
            emsStmt = emsConnection.createStatement();
            StringConvertUtil.ConvertString(buffer, QUERY_DELETE_CURRENT_LIST, this.SCHEDULE_INFO, "${", "}", true, false);
            log.debug("DELETE CURRENT LIST START exec query => {}", (Object)buffer.toString());
            emsStmt.executeUpdate(buffer.toString(), -1);
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            if (emsConnection != null) {
                if (emsStmt != null) {
                    emsConnection.recycleStatement(emsStmt);
                }
                emsConnection.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTaskState(String state) throws Exception {
        Object object = this.composer.getLock();
        synchronized (object) {
            this.composer.setProperty("STYPE", "SYSTEM");
            this.composer.setProperty("T_TYPE", "41");
            this.composer.setProperty("T_CODE", state);
            this.composer.setProperty("POST_ID", this.POST_ID);
            this.composer.setProperty("M_ID", "noid");
            this.composer.setProperty("STEP", "0");
            this.composer.setProperty("T_DATE", Cal.getDate());
            this.composer.setProperty("MX_RECORD", "");
            this.composer.setProperty("DELAY", "");
            this.composer.setProperty("TOKEN_ID", "noemail");
            this.composer.setProperty("DOMAIN", "");
            this.composer.setProperty("WORKER", this.getName());
            this.composer.setProperty("ETC_LOG", "MakeInfoStart");
            this.composer.setProperty("LIST_TABLE", "n");
            SmtpLogger.put(this.composer);
        }
        this.SCHEDULE_INFO.setProperty("UPDATE_JOB_STATUS", state);
        eMsConnection emsConnection = null;
        eMsStatement emsStmt = null;
        StringBuffer buffer = new StringBuffer(512);
        try {
            emsConnection = ConnectionPool.getConnection();
            emsStmt = emsConnection.createStatement();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_STATE_INFO, this.SCHEDULE_INFO, "${", "}", true, false);
            if (log.isDebugEnabled()) {
                log.debug("exec => {}", (Object)buffer.toString());
            }
            emsStmt.executeUpdate(buffer.toString());
        }
        catch (Exception ignore) {
            log.error(this.getName(), (Throwable)ignore);
            throw ignore;
        }
        finally {
            if (emsConnection != null) {
                if (emsStmt != null) {
                    emsConnection.recycleStatement(emsStmt);
                }
                emsConnection.recycle();
            }
        }
    }

    protected void updateSendListStatus() throws Exception {
        eMsConnection emsConnection = null;
        eMsStatement emsStmt = null;
        StringBuffer buffer = new StringBuffer(512);
        try {
            emsConnection = ConnectionPool.getConnection();
            emsStmt = emsConnection.createStatement();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_SCHEDULED_SEND_LIST, this.SCHEDULE_INFO, "${", "}", true, false);
            if (log.isDebugEnabled()) {
                log.debug("QUERY_UPDATE_SCHEDULED_SEND_LIST => {}", (Object)buffer.toString());
            }
            emsStmt.executeUpdate(buffer.toString());
        }
        catch (Exception ignore) {
            log.error(this.getName(), (Throwable)ignore);
            throw ignore;
        }
        finally {
            if (emsConnection != null) {
                if (emsStmt != null) {
                    emsConnection.recycleStatement(emsStmt);
                }
                emsConnection.recycle();
            }
        }
    }

    @Override
    protected void releaseResource() {
        if (this.psMemberFatigueCount != null) {
            this.psMemberFatigueCount.close();
        }
        super.releaseResource();
        this.destroy();
    }

    protected boolean checkConnectionInfo(ConnectInfo targetConnInfo) throws Exception {
        return this.EMS_DB_URL.equals(targetConnInfo.getDB_URL()) && this.EMS_DB_ID.equals(targetConnInfo.getDB_UID()) && this.EMS_DB_PWD.equals(targetConnInfo.getDB_PASS());
    }

    @Override
    public void destroy() {
        if (this.AUTO_KEY_VALUE_PARSER != null) {
            this.AUTO_KEY_VALUE_PARSER.destroy();
            this.AUTO_KEY_VALUE_PARSER = null;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateErrorList(Properties scheduleInfo) throws Exception {
        eMsConnection emsConnection = null;
        eMsStatement emsStmt = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            emsStmt = emsConnection.createStatement();
            StringBuffer buffer = new StringBuffer(512);
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_SCHEDULED_ERROR, scheduleInfo, "${", "}", true, false);
            emsStmt.executeUpdate(buffer.toString());
            if (AutoSendType.SEARCH_OF_REALTIME.getCode().equals(scheduleInfo.getProperty(CommonColumn.CYCLE_TYPE.getCode(), ""))) {
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_MSG_ERROR, scheduleInfo, "${", "}", true, false);
                emsStmt.executeUpdate(buffer.toString());
            }
        }
        finally {
            if (emsConnection != null) {
                if (emsStmt != null) {
                    emsConnection.recycleStatement(emsStmt);
                }
                emsConnection.recycle();
            }
        }
    }

    protected void updateAllErrorList() throws Exception {
    }

    private void getMemberToken(String channelType, Map<String, String> tmpSimpleHash) throws Exception {
        if (ChannelType.EMAIL.getCode().equals(channelType)) {
            if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_EMAIL.getCode())) {
                this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_EMAIL.getCode()));
            } else if (tmpSimpleHash.containsKey(CommonColumn.TMS_M_EMAIL.getCode())) {
                this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.TMS_M_EMAIL.getCode()));
            }
        } else if (ChannelType.SMS.getCode().equals(channelType) || ChannelType.SMART_SMS.getCode().equals(channelType)) {
            if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_PHONE.getCode())) {
                this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_PHONE.getCode()));
            } else if (tmpSimpleHash.containsKey(CommonColumn.TMS_M_PHONE.getCode())) {
                this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.TMS_M_PHONE.getCode()));
            }
        } else if (ChannelType.PUSH.getCode().equals(channelType)) {
            if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_TOKEN.getCode())) {
                this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_TOKEN.getCode()));
            } else if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_PUSH.getCode())) {
                this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_PUSH.getCode()));
            }
        } else if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_TOKEN.getCode())) {
            this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_TOKEN.getCode()));
        }
    }

    private boolean isOftenSendingFilter() {
        return "Y".equals(this.SCHEDULE_INFO.getProperty(CommonColumn.FILTER_USE_YN.getCode(), "N")) && AutoSendType.OFTEN_SENDING.getCode().equals(this.SCHEDULE_INFO.getProperty(CommonColumn.CYCLE_TYPE.getCode(), ""));
    }

    private boolean isUseFatigue() throws Exception {
        return "Y".equals(this.SCHEDULE_INFO.getProperty(CommonColumn.FILTER_USE_YN.getCode(), "N"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFatigue() {
        int fatigueDaySentCount = 0;
        int fatigueMonthSentCount = 0;
        try (eMsResultSet rsMemberFatigueCount = null;){
            rsMemberFatigueCount = this.psMemberFatigueCount.executeQuery(this.__TMP_SIMPLE_HASH__);
            if (rsMemberFatigueCount.next()) {
                fatigueDaySentCount = rsMemberFatigueCount.getInt("DAY_CNT");
                fatigueMonthSentCount = rsMemberFatigueCount.getInt("MONTH_CNT");
            }
            if (fatigueDaySentCount > this.fatigueDayLimitCount || fatigueMonthSentCount > this.fatigueMonthLimitCount) {
                this.__TMP_SIMPLE_HASH__.put(CommonColumn.SEND_STATE.getCode(), ErrorCode.FATIGUE_FILTER.getCode());
                ++this.fatigueFilteredCount;
            }
        }
    }

    static {
        try {
            QUERY_UPDATE_STATE_INFO = SqlManager.getQuery("COMMON", "QUERY_UPDATE_STATE_INFO");
            QUERY_SELECT_LIST_QUERY_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_LIST_QUERY_INFO");
            QUERY_INSERT_SCHEDULED_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_INSERT_SCHEDULED_SEND_LIST");
            QUERY_UPDATE_SCHEDULED_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SCHEDULED_SEND_LIST");
            QUERY_SELECT_TARGET_CNT = SqlManager.getQuery("COMMON", "QUERY_SELECT_TARGET_CNT");
            QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE = SqlManager.getQuery("COMMON", "QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE");
            QUERY_DELETE_CURRENT_LIST = SqlManager.getQuery("COMMON", "QUERY_DELETE_CURRENT_LIST");
            QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE = SqlManager.getQuery("COMMON", "QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE");
            QUERY_UPDATE_MSG_ERROR = SqlManager.getQuery("UPDATE_ERROR", "QUERY_UPDATE_MSG_ERROR");
            QUERY_UPDATE_SCHEDULED_ERROR = SqlManager.getQuery("UPDATE_ERROR", "QUERY_UPDATE_SCHEDULED_ERROR");
            TMP_WORKING_DIRECTORY = eMsSystem.getProperty("temp.working.dir", System.getProperty("java.io.tmpdir")).trim();
            MAPPING_LIMIT = Integer.parseInt(eMsSystem.getProperty("long.mapping.limit", "1000").trim());
            MEMBER_INFO_ENCRYPT_YN = eMsSystem.getProperty("member.info.encrypt.yn", "N");
            encKey = eMsSystem.getProperty("member.info.encrypt.key");
            querySelectFatigueInfo = SqlManager.getQuery("COMMON", "QUERY_SELECT_FATIGUE_INFO");
            querySelectMemberFatigueCount = SqlManager.getQuery("COMMON", "QUERY_SELECT_MEMBER_FATIGUE_COUNT");
            queryInsertOrUpdateFatigueList = SqlManager.getQuery("COMMON", "QUERY_INSERT_OR_UPDATE_FATIGUE_LIST");
        }
        catch (Exception e) {
            log.error("query load fail", (Throwable)e);
            System.exit(1);
        }
    }
}

