/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.support;

import com.humuson.tms.model.vo.TmsUser;
import com.humuson.tms.model.vo.TmsUserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class TmsUserSessionArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(TmsUserSessionArgumentResolver.class);

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        TmsUser tmsUser = null;
        if (authentication != null) {
            if (log.isDebugEnabled()) {
                log.debug("authentication.getPrincipal() : " + authentication.getPrincipal());
            }
            if (authentication.getPrincipal() instanceof TmsUser) {
                tmsUser = (TmsUser)authentication.getPrincipal();
            }
        }
        TmsUserSession tmsUserSession = new TmsUserSession(tmsUser);
        return tmsUserSession;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return TmsUserSession.class.isAssignableFrom(parameter.getParameterType());
    }
}

