/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.security;

import com.humuson.tms.constrants.RoleType;
import com.humuson.tms.exception.UserExpirationDateException;
import com.humuson.tms.mapper.TmsUserMapper;
import com.humuson.tms.model.vo.TmsUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="tmsUserService")
public class TmsUserDetailsService
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(TmsUserDetailsService.class);
    @Value(value="${tms.dormant.use.yn}")
    private String tmsDormantUseYn;
    @Value(value="${tms.dormant.day}")
    private int tmsDormantDay;
    @Autowired
    private TmsUserMapper tmsUserMapper;

    public GrantedAuthority getSecurityRole(String role) {
        return new SimpleGrantedAuthority(RoleType.find((String)role).getRole());
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        String lockYN;
        TmsUser tmsUser = this.tmsUserMapper.findTmsUserByUserId(username);
        if (tmsUser == null) {
            throw new AuthenticationServiceException("USER_NOT_FOUND");
        }
        if ("Y".equals(this.tmsDormantUseYn)) {
            this.tmsUserMapper.updateDormantLockYn(username, this.tmsDormantDay);
            log.info("username:{} ==> LockYn:Y Update");
        }
        if ((lockYN = this.tmsUserMapper.checkLoginAvailable(username)).equals("Y")) {
            throw new AuthenticationServiceException("LOCKED");
        }
        this.validateExpirationDate(tmsUser.getStartDate(), tmsUser.getEndDate());
        List<String> roleList = this.tmsUserMapper.getUserRoleList(tmsUser.getAuthId());
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        HashMap<String, String> roleMap = new HashMap<String, String>();
        for (String role : roleList) {
            authorities.add(this.getSecurityRole(role));
            roleMap.put(role, role);
        }
        tmsUser.setAuthorities(authorities);
        tmsUser.setRoleList(roleList);
        tmsUser.setRoleMap(roleMap);
        if (log.isDebugEnabled()) {
            log.debug("TmsUser : {}", (Object)tmsUser.toString());
        }
        return tmsUser;
    }

    private void validateExpirationDate(String startDate, String endDate) {
        String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        if (nowDateStr.compareTo(startDate) < 0) {
            String displayDateStr = startDate.replaceAll("(.{4})(.{2})(.{2})", "$1-$2-$3");
            throw new UserExpirationDateException("\uc0ac\uc6a9 \uc2dc\uc791 \uc77c\uc790\uac00 \uc9c0\ub098\uc57c\ub9cc \ub85c\uadf8\uc778\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc2dc\uc791 \uc77c\uc790 : " + displayDateStr);
        }
        if (nowDateStr.compareTo(endDate) > 0) {
            throw new UserExpirationDateException("\uc0ac\uc6a9 \ub9cc\uae30 \uc77c\uc790\uac00 \uc9c0\ub0ac\uc2b5\ub2c8\ub2e4. \uad00\ub9ac\uc790\uc5d0\uac8c \ubb38\uc758\ud574 \uc8fc\uc2ed\uc2dc\uc624.");
        }
    }
}

