/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.site.user;

import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.mapper.site.user.SiteUserMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.site.user.AppUserHistInfo;
import com.humuson.tms.model.site.user.SiteUserInfo;
import com.humuson.tms.service.excel.FillManagerSiteUser;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import com.humuson.tms.service.site.user.SiteUserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.annotations.Param;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteUserServiceImpl
implements SiteUserService {
    private static final int USER_LIST_SIZE = 10;
    private static final int USER_DETAIL_LIST_SIZE = 5;
    @Autowired
    private SiteUserMapper siteUserMapper;

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SiteUserInfo> selectSiteUserList(String userId, Map<String, String> param, PageInfo pageInfo) {
        if (param.get("search_period") != null && !"".equals(param.get("search_period"))) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        pageInfo.setSize(10);
        pageInfo.calculate(this.siteUserMapper.selectSiteUserListCnt(userId, param, pageInfo));
        List<SiteUserInfo> list = this.siteUserMapper.selectSiteUserList(userId, param, pageInfo);
        return list;
    }

    @Override
    public void downloadXLS(HttpServletResponse response, Map<String, String> param, List<SiteUserInfo> list) {
        String title = "Site user list";
        ArrayList<String> columnListMsg = new ArrayList<String>();
        columnListMsg.add("\ub4f1\ub85d\uc77c");
        columnListMsg.add("ID");
        columnListMsg.add("\uc774\ub984");
        columnListMsg.add("\uc774\uba54\uc77c");
        columnListMsg.add("\ud578\ub4dc\ud3f0\ubc88\ud638");
        columnListMsg.add("\ud50c\ub7ab\ud3fc");
        columnListMsg.add("\uc571\ubc84\uc804");
        columnListMsg.add("\ub514\ubc14\uc774\uc2a4");
        columnListMsg.add("\ud65c\uc131\uc5ec\ubd80");
        columnListMsg.add("Email \ub9c8\ucf00\ud305 \uc218\uc2e0\ub3d9\uc758");
        columnListMsg.add("PUSH \ub9c8\ucf00\ud305 \uc218\uc2e0\ub3d9\uc758");
        columnListMsg.add("SMS \ub9c8\ucf00\ud305 \uc218\uc2e0\ub3d9\uc758");
        String startDate = "";
        String endDate = "";
        if (param.get("search_period") != null && !"".equals(param.get("search_period"))) {
            String[] period = param.get("search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        PeriodInfo periodInfo = new PeriodInfo(startDate, endDate, "", "", 0);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet[] worksheet = new XSSFSheet[]{workbook.createSheet("Site user list")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnListMsg, periodInfo);
        FillManagerSiteUser.fillReportSiteUser(worksheet[0], startRowIndex, startColIndex, list);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }

    @Override
    public AppUserHistInfo selectAppUserDevice(Map<String, String> param) {
        return this.siteUserMapper.selectAppUserDevice(param);
    }

    @Override
    public List<AppUserHistInfo> selectAppUserHist(Map<String, String> param, PageInfo pageInfo) {
        pageInfo.setSize(5);
        pageInfo.calculate(this.siteUserMapper.selectAppUserHistCnt(param));
        return this.siteUserMapper.selectAppUserHist(param, pageInfo);
    }

    @Override
    public int selectAppUserHistCnt(Map<String, String> param) {
        return this.siteUserMapper.selectAppUserHistCnt(param);
    }

    @Override
    public List<SiteUserInfo> selectAppUserGrpList(@Param(value="param") Map<String, String> param) {
        return this.siteUserMapper.selectAppUserGrpList(param);
    }
}

