/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.report;

import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.Decrypt;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.convert.bind.Encrypt;
import com.humuson.tms.mapper.report.UserHistoryMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.TMSResendInfo;
import com.humuson.tms.model.UserHistoryInfo;
import com.humuson.tms.service.report.UserHistoryService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserHistoryServiceImpl
implements UserHistoryService {
    @Autowired
    private UserHistoryMapper userHistoryMapper;

    @Override
    @ConvertTarget
    @Decrypt
    public List<UserHistoryInfo> userReceiveMessageList(PageInfo pageInfo, String startDate, String endDate, String searchKeyword, ArrayList<String> month, String channelType, String kakaoType, String searchType, int siteId) {
        return this.userHistoryMapper.userReceiveMessageList(pageInfo, startDate, endDate, searchKeyword, month, channelType, kakaoType, searchType, siteId);
    }

    @Override
    public int userReceiveMessageTotal(PageInfo pageInfo, String startDate, String endDate, String searchKeyword, ArrayList<String> month, String channelType, String kakaoType, String searchType, int siteId) {
        return this.userHistoryMapper.userReceiveMessageTotal(pageInfo, startDate, endDate, searchKeyword, month, channelType, kakaoType, searchType, siteId);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<TMSResendInfo> resendCampTargetList(TMSResendInfo tmsResendInfo) {
        return this.userHistoryMapper.selectCampResendTargetList(tmsResendInfo);
    }

    @Override
    @ConvertTarget
    public int registCampResendTargetData(@Encrypt TMSResendInfo tmsResendInfo) {
        return this.userHistoryMapper.insertCampResendTargetData(tmsResendInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<TMSResendInfo> resendAutoTargetList(TMSResendInfo tmsResendInfo) {
        return this.userHistoryMapper.selectAutoResendTargetList(tmsResendInfo);
    }

    @Override
    @ConvertTarget
    public int registAutoResendTargetData(@Encrypt TMSResendInfo tmsResendInfo) {
        return this.userHistoryMapper.insertAutoResendTargetData(tmsResendInfo);
    }
}

