/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.report;

import com.humuson.tms.mapper.report.ReportMapper;
import com.humuson.tms.model.MessageInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.excel.FillManagerMultiCamp;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import com.humuson.tms.service.report.ReportService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    @Autowired
    private ReportMapper reportMapper;

    @Override
    public List<MessageInfo> reportPageingMsgList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        if (param.get("msg_search_period") != null) {
            String[] period = param.get("msg_search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.reportMapper.reportMsgChnTotal(param, tmsUserSession));
        return this.reportMapper.reportPageingMsgList(pageInfo, param, tmsUserSession);
    }

    @Override
    public Map<String, List<MessageInfo>> reportMsgChnList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        String endDate;
        String startDate;
        String[] period;
        if (param.get("msg_search_period") != null) {
            period = param.get("msg_search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null) {
            period = param.get("search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.reportMapper.reportMsgChnTotal(param, tmsUserSession));
        List<MessageInfo> allMsgChnList = this.reportMapper.reportMsgChnList(pageInfo, param, tmsUserSession);
        ArrayList<MessageInfo> msgChnList = null;
        HashMap<String, List<MessageInfo>> msgChnMap = new HashMap<String, List<MessageInfo>>();
        for (MessageInfo messageInfo : allMsgChnList) {
            if (!msgChnMap.containsKey(messageInfo.getMsgId())) {
                msgChnList = new ArrayList<MessageInfo>();
                msgChnList.add(messageInfo);
                msgChnMap.put(messageInfo.getMsgId(), msgChnList);
                continue;
            }
            ((List)msgChnMap.get(messageInfo.getMsgId())).add(messageInfo);
        }
        return msgChnMap;
    }

    @Override
    public void downloadXLS(HttpServletResponse response, Map<String, String> param, PeriodInfo periodInfo, TmsUserSession tmsUserSession) {
        String title = "Multi Campaign";
        ArrayList<String> columnListMsg = new ArrayList<String>();
        columnListMsg.add("Campaign Name");
        columnListMsg.add("Message Name");
        columnListMsg.add("Dates");
        columnListMsg.add("Job Status");
        columnListMsg.add("Total");
        columnListMsg.add("Success");
        columnListMsg.add("Open");
        columnListMsg.add("Click");
        columnListMsg.add("Fail");
        columnListMsg.add("SwitchSuccess");
        columnListMsg.add("SwitchFail");
        List<MessageInfo> dataListMsg = this.reportMapper.reportPageingMsgList(null, param, tmsUserSession);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet[] worksheet = new XSSFSheet[]{workbook.createSheet("Message")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnListMsg, periodInfo);
        FillManagerMultiCamp.fillReportMsg(worksheet[0], startRowIndex, startColIndex, dataListMsg);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }
}

