/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.report;

import com.humuson.tms.mapper.report.AutoReportMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.analytics.AnalyticsAutoSchdlInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.excel.FillManagerAutoCamp;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import com.humuson.tms.service.report.AutoReportService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoReportServiceImpl
implements AutoReportService {
    @Autowired
    AutoReportMapper autoReportMapper;

    @Override
    public List<AnalyticsAutoSchdlInfo> getCompletedSchdlList(String startDate, String endDate, PageInfo pageInfo, String msgName, String regId, String deptId, String siteId, TmsUserSession tmsUserSession) {
        pageInfo.calculate(this.autoReportMapper.getCompletedSchdlTotalCnt(startDate, endDate, msgName, regId, deptId, siteId, tmsUserSession));
        return this.autoReportMapper.getCompletedSchdlList(startDate, endDate, pageInfo, msgName, regId, deptId, siteId, tmsUserSession);
    }

    @Override
    public Map<String, Object> getMsgInfo(String workDay, String seqNo) {
        return this.autoReportMapper.getMsgInfo(workDay, seqNo);
    }

    @Override
    public List<Map<String, Object>> getDeviceOpenList(String workDay, String seqNo) {
        return this.autoReportMapper.getDeviceOpenList(workDay, seqNo);
    }

    @Override
    public List<Map<String, Object>> getDeviceClickList(String workDay, String seqNo) {
        return this.autoReportMapper.getDeviceClickList(workDay, seqNo);
    }

    @Override
    public List<Map<String, Object>> getMobileOpenList(String workDay, String seqNo) {
        return this.autoReportMapper.getMobileOpenList(workDay, seqNo);
    }

    @Override
    public List<Map<String, Object>> getMobileClickList(String workDay, String seqNo) {
        return this.autoReportMapper.getMobileClickList(workDay, seqNo);
    }

    @Override
    public List<Map<String, Object>> getTrackingDailyOpen(String workDay, String seqNo, String orderBy, int size) {
        return this.autoReportMapper.getTrackingDailyOpen(workDay, Integer.parseInt(seqNo), orderBy, size);
    }

    @Override
    public List<Map<String, Object>> getTrackingDailyClick(String workDay, String seqNo, String orderBy, int size) {
        return this.autoReportMapper.getTrackingDailyClick(workDay, Integer.parseInt(seqNo), orderBy, size);
    }

    @Override
    public List<Map<String, Object>> getTrackingHourlyOpen(String workDay, String seqNo) {
        return this.autoReportMapper.getTrackingHourlyOpen(workDay, seqNo);
    }

    @Override
    public List<Map<String, Object>> getTrackingHourlyClick(String workDay, String seqNo) {
        return this.autoReportMapper.getTrackingHourlyClick(workDay, seqNo);
    }

    @Override
    public List<Map<String, Object>> getErrorCntList(String workDay, String seqNo, String channelType) {
        String listTable = this.autoReportMapper.getListTableName(workDay, seqNo);
        return this.autoReportMapper.getErrorCntList(workDay, seqNo, listTable, channelType);
    }

    @Override
    public Map<String, Object> getChnClickViewInfo(String workDay, String seqNo) {
        return this.autoReportMapper.getChnClickViewInfo(workDay, seqNo);
    }

    @Override
    public List<Map<String, Object>> getClickList(String workDay, String seqNo) {
        return this.autoReportMapper.getClickList(workDay, seqNo);
    }

    @Override
    public Map<String, Object> getClickSum(String workDay, String seqNo) {
        return this.autoReportMapper.getClickSum(workDay, seqNo);
    }

    @Override
    public void downloadSchdlReportXLS(HttpServletResponse response, TmsUserSession tmsUserSession, String startDate, String endDate, PageInfo pageInfo, String msgName, String regId, String deptId, String siteId) {
        String title = "Auto Report";
        ArrayList<String> columnListMsg = new ArrayList<String>();
        columnListMsg.add("Message Name");
        columnListMsg.add("Channel");
        columnListMsg.add("Dates");
        columnListMsg.add("Seq No");
        columnListMsg.add("Total");
        columnListMsg.add("Success");
        columnListMsg.add("Open");
        columnListMsg.add("Click");
        columnListMsg.add("Fail");
        columnListMsg.add("SwitchSuccess");
        columnListMsg.add("SwitchFail");
        pageInfo = null;
        List<AnalyticsAutoSchdlInfo> dataListMsg = this.autoReportMapper.getCompletedSchdlList(startDate, endDate, pageInfo, msgName, regId, deptId, siteId, tmsUserSession);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet[] worksheet = new XSSFSheet[]{workbook.createSheet("Message")};
        int startRowIndex = 0;
        int startColIndex = 0;
        PeriodInfo periodInfo = new PeriodInfo(startDate, endDate, null, null, 0);
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnListMsg, periodInfo);
        FillManagerAutoCamp.fillReportSchdl(worksheet[0], startRowIndex, startColIndex, dataListMsg);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }
}

