/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.single;

import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.mapper.campaign.single.CampaignSingleMapper;
import com.humuson.tms.model.MassSendListInfo;
import com.humuson.tms.model.MessageInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.SingleCampListInfo;
import com.humuson.tms.model.TmsCampInfo;
import com.humuson.tms.model.TmsCodeInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.campaign.single.CampaignSingleService;
import com.humuson.tms.service.excel.FillManagerSingleCamp;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CampaignSingleServiceImpl
implements CampaignSingleService {
    @Autowired
    private CampaignSingleMapper campaignSingleMapper;

    @Override
    public int singleCampTotal(Map<String, String> param, TmsUserSession tmsUserSession) {
        return this.campaignSingleMapper.singleCampTotal(param, tmsUserSession);
    }

    @Override
    public int singleCampMsgTotal(Map<String, String> param) {
        return this.campaignSingleMapper.singleCampMsgTotal(param);
    }

    @Override
    public int singleCampRegist(Map<String, String> param) {
        String[] period = param.get("campaign_period").split("-");
        String startDate = period[0].trim();
        String endDate = period[1].trim();
        param.put("start_date", startDate);
        param.put("end_date", endDate);
        int cnt = this.campaignSingleMapper.singleCampRegist(param);
        return cnt;
    }

    @Override
    public List<SingleCampListInfo> singleCampList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        if (param.get("search_period") != null && !"".equals(param.get("search_period"))) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.singleCampTotal(param, tmsUserSession));
        return this.campaignSingleMapper.singleCampList(pageInfo, param, tmsUserSession);
    }

    @Override
    public List<MessageInfo> singleMsgList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        if (param.get("msg_search_period") != null && !"".equals(param.get("msg_search_period"))) {
            String[] period = param.get("msg_search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null && param.get("search_period") != null && !"".equals(param.get("search_period"))) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        if (param.get("pageSize") != null) {
            pageInfo.setSize(Integer.parseInt(param.get("pageSize")));
        } else {
            pageInfo.setSize(5);
        }
        pageInfo.calculate(this.singleCampMsgTotal(param));
        return this.campaignSingleMapper.singleMsgList(pageInfo, param, tmsUserSession);
    }

    @Override
    public Map<String, List<MessageInfo>> singleMsgChnList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        String endDate;
        String startDate;
        String[] period;
        if (param.get("msg_search_period") != null && !"".equals(param.get("msg_search_period"))) {
            period = param.get("msg_search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null && param.get("search_period") != null && !"".equals(param.get("search_period"))) {
            period = param.get("search_period").split("-");
            startDate = period[0].trim();
            endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.campaignSingleMapper.singleMsgChnTotal(param, tmsUserSession));
        List<MessageInfo> allMsgChnList = this.campaignSingleMapper.singleMsgChnList(pageInfo, param, tmsUserSession);
        ArrayList<MessageInfo> msgChnList = null;
        HashMap<String, List<MessageInfo>> msgChnMap = new HashMap<String, List<MessageInfo>>();
        for (MessageInfo messageInfo : allMsgChnList) {
            if (!msgChnMap.containsKey(messageInfo.getMsgId())) {
                msgChnList = new ArrayList<MessageInfo>();
                msgChnList.add(messageInfo);
                msgChnMap.put(messageInfo.getMsgId(), msgChnList);
                continue;
            }
            ((List)msgChnMap.get(messageInfo.getMsgId())).add(messageInfo);
        }
        return msgChnMap;
    }

    @Override
    public List<MessageInfo> singlePageingMsgList(PageInfo pageInfo, Map<String, String> param, TmsUserSession tmsUserSession) {
        if (param.get("msg_search_period") != null && !"".equals(param.get("msg_search_period"))) {
            String[] period = param.get("msg_search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        } else if (param.get("hiddenMsgCampId") != null && param.get("search_period") != null && !"".equals(param.get("search_period"))) {
            String[] period = param.get("search_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        pageInfo.calculate(this.campaignSingleMapper.singleMsgChnTotal(param, tmsUserSession));
        return this.campaignSingleMapper.singlePageingMsgList(pageInfo, param, tmsUserSession);
    }

    @Override
    public int singleCampDelete(Map<String, String> param) {
        int cnt = this.campaignSingleMapper.singleCampDelete(param);
        if (cnt > 0) {
            cnt += this.campaignSingleMapper.deletedCampSchdUpdate(param);
        }
        return cnt;
    }

    @Override
    public List<TmsCodeInfo> campListTableTypeList() {
        return this.campaignSingleMapper.campListTableTypeList();
    }

    @Override
    public TmsCampInfo getCampInfo(Map<String, String> param) {
        return this.campaignSingleMapper.getCampInfo(param);
    }

    @Override
    public int singleCampModify(Map<String, String> param) {
        if (param.get("campaign_period") != null) {
            String[] period = param.get("campaign_period").split("-");
            String startDate = period[0].trim();
            String endDate = period[1].trim();
            param.put("start_date", startDate);
            param.put("end_date", endDate);
        }
        return this.campaignSingleMapper.singleCampModify(param);
    }

    @Override
    public int deleteMsg(Map<String, String> param) {
        int cnt = this.campaignSingleMapper.deleteMsg(param);
        if (cnt > 0) {
            cnt += this.campaignSingleMapper.deletedMsgSchdUpdate(param);
        }
        return cnt;
    }

    @Override
    public void downloadXLS(HttpServletResponse response, Map<String, String> param, PeriodInfo periodInfo, TmsUserSession tmsUserSession) {
        String title = "Single Campaign";
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("Campaign Name");
        columnList.add("Dates");
        columnList.add("Email");
        columnList.add("SMS");
        columnList.add("Push");
        columnList.add("AlimTalk");
        columnList.add("FriendTalk");
        columnList.add("Total");
        columnList.add("Success");
        columnList.add("Open");
        columnList.add("Click");
        columnList.add("Fail");
        columnList.add("SwitchedSuccess");
        columnList.add("SwitchedFail");
        ArrayList<String> columnListMsg = new ArrayList<String>();
        columnListMsg.add("Campaign Name");
        columnListMsg.add("Message Name");
        columnListMsg.add("Dates");
        columnListMsg.add("Channel");
        columnListMsg.add("Job Status");
        columnListMsg.add("Total");
        columnListMsg.add("Success");
        columnListMsg.add("Open");
        columnListMsg.add("Click");
        columnListMsg.add("Fail");
        columnListMsg.add("SwitchedSuccess");
        columnListMsg.add("SwitchedFail");
        List<SingleCampListInfo> dataList = this.campaignSingleMapper.singleCampList(null, param, tmsUserSession);
        List<MessageInfo> dataListMsg = this.campaignSingleMapper.singleMsgList(null, param, tmsUserSession);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet[] worksheet = new XSSFSheet[]{workbook.createSheet("Campaign"), workbook.createSheet("Message")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnList, periodInfo);
        Layouter.buildReport(worksheet[1], startRowIndex, startColIndex, title, columnListMsg, periodInfo);
        FillManagerSingleCamp.fillReport(worksheet[0], startRowIndex, startColIndex, dataList);
        FillManagerSingleCamp.fillReportMsg(worksheet[1], startRowIndex, startColIndex, dataListMsg);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public MassSendListInfo getPreviewContent(String msgId, String postId) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setPOST_ID(postId);
        ms.targetListTable();
        return this.campaignSingleMapper.getPreviewContent(ms);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> randomTargetList(String msgId, String postId, String channelType) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setPOST_ID(postId);
        ms.setCHANNEL_TYPE(channelType);
        ms.targetListTable();
        List<MassSendListInfo> massSendList = this.campaignSingleMapper.randomTargetList(ms);
        return massSendList;
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> previewSearch(String msgId, String postId, String searchType, String searchValue, String channelType) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setPOST_ID(postId);
        ms.setCHANNEL_TYPE(channelType);
        ms.targetListTable();
        List<MassSendListInfo> massSendList = this.campaignSingleMapper.previewSearch(ms, searchType, searchValue);
        return massSendList;
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> randomTargetListByMemberId(String msgId, String postId, String memberId, String channelType) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setPOST_ID(postId);
        ms.setMEMBER_ID(memberId);
        ms.setCHANNEL_TYPE(channelType);
        ms.targetListTable();
        List<MassSendListInfo> massSendList = this.campaignSingleMapper.randomTargetListByMemberId(ms);
        return massSendList;
    }
}

