/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.single;

import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.mapper.campaign.CampaignAttachMapper;
import com.humuson.tms.mapper.campaign.single.CampaignSingleKakaoMapper;
import com.humuson.tms.model.CampaignChannelInfo;
import com.humuson.tms.model.TmsCampInfoAttach;
import com.humuson.tms.service.campaign.single.CampaignSingleKakaoService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CampaignSingleKakaoServiceImpl
implements CampaignSingleKakaoService {
    private static final Logger log = LoggerFactory.getLogger(CampaignSingleKakaoServiceImpl.class);
    @Value(value="${attach.path}")
    private String attachPath;
    @Value(value="${attach.url}")
    private String attachUrl;
    @Autowired
    private CampaignSingleKakaoMapper campaignSingleKakaoMapper;
    @Autowired
    private CampaignAttachMapper campaignAttachMapper;

    @Override
    public List<CampaignChannelInfo> selectKakaoInfo(String postId) {
        return this.campaignSingleKakaoMapper.selectKakaoInfo(postId);
    }

    @Override
    public int updateKakaoMsg(Map<String, String> param) {
        CampaignChannelInfo campChnInfo = new CampaignChannelInfo();
        campChnInfo.setPostId(param.get("POST_ID"));
        campChnInfo.setMsgId(param.get("MSG_ID"));
        campChnInfo.setSmsType(param.get("SMS_TYPE"));
        campChnInfo.setTemplateCode(param.get("TEMPLATE_CODE"));
        campChnInfo.setSenderKey(param.get("SENDER_KEY"));
        campChnInfo.setDeptId(param.get("DEPT_ID"));
        campChnInfo.setFromNumber(param.get("FROM_NUMBER"));
        campChnInfo.setFromName(param.get("FROM_NAME"));
        campChnInfo.setSubject(param.get("SUBJECT"));
        campChnInfo.setContentHtml(param.get("POST_ID") + ".kakao");
        return this.campaignSingleKakaoMapper.updateKakaoMsg(campChnInfo);
    }

    @Override
    public int uploadAttachFile(TmsCampInfoAttach attachInfo) throws Exception {
        MultipartFile file = attachInfo.getAttachFile();
        log.info("\uc5c5\ub85c\ub4dc\ud30c\uc77c\ud06c\uae30 : {}", (Object)file.getSize());
        String fileName = file.getOriginalFilename();
        String[] checkExtension = new String[]{"png", "jpg", "jpeg"};
        if (!FilenameUtils.isExtension((String)fileName.toLowerCase(), (String[])checkExtension)) {
            return -101;
        }
        BufferedImage image = ImageIO.read(file.getInputStream());
        double width = image.getWidth();
        if (width < 500.0) {
            return -103;
        }
        double height = image.getHeight();
        double a = width / height;
        if (a < 0.5 || a > 1.34) {
            return -102;
        }
        attachInfo.setContentName(fileName);
        List<TmsCampInfoAttach> attachInfoList = this.campaignAttachMapper.selectAttachFileList(attachInfo);
        log.info("attachInfoList size : {}", (Object)attachInfoList.size());
        if (attachInfoList.size() > 0) {
            String contentPath;
            log.info("attachInfoList size > 0");
            String attachName = contentPath = attachInfoList.get(0).getContentPath();
            File existFile = new File(attachName);
            existFile.delete();
        }
        String path = this.attachPath;
        try {
            String newFileName = FileUtil.upload((InputStream)file.getInputStream(), (String)fileName, (String)(path + "/"));
            attachInfo.setFileId(newFileName);
            attachInfo.setContentPath(path + "/" + newFileName);
            attachInfo.setContentUrl(this.attachUrl + "/" + newFileName);
        }
        catch (IOException ie) {
            log.error("File writing error : {}", (Throwable)ie);
        }
        log.info("FriendTalk IMG upload success!");
        attachInfo.setAttachType("A");
        return this.campaignAttachMapper.insertAttachFileInfo(attachInfo);
    }

    @Override
    public Map<String, Object> uploadSwAttachFile(TmsCampInfoAttach attachInfo) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MultipartFile file = attachInfo.getAttachFile();
        log.info("\uce5c\uad6c\ud1a1 \ubd80\ub2ec \uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \ud06c\uae30 : {}", (Object)file.getSize());
        String fileName = file.getOriginalFilename();
        String[] checkExtension = new String[]{"png", "jpg", "jpeg"};
        if (!FilenameUtils.isExtension((String)fileName.toLowerCase(), (String[])checkExtension)) {
            result.put("result", "-101");
            return result;
        }
        BufferedImage image = ImageIO.read(file.getInputStream());
        double width = image.getWidth();
        if (width < 500.0) {
            result.put("result", "-103");
            return result;
        }
        double height = image.getHeight();
        double a = width / height;
        if (a < 0.87) {
            result.put("result", "-102");
            return result;
        }
        attachInfo.setContentName(fileName);
        String path = this.attachPath;
        try {
            String newFileName = FileUtil.upload((InputStream)file.getInputStream(), (String)fileName, (String)(path + "/"));
            attachInfo.setFileId(newFileName);
            attachInfo.setContentPath(path + "/" + newFileName);
            attachInfo.setContentUrl(this.attachUrl + "/" + newFileName);
        }
        catch (IOException ie) {
            log.error("File writing error : {}", (Throwable)ie);
        }
        log.info("FriendTalk swIMG upload success!");
        attachInfo.setAttachType("A");
        result.put("result", this.campaignSingleKakaoMapper.updateSwAttachFile(attachInfo));
        result.put("attachInfo", attachInfo);
        return result;
    }

    @Override
    public int deleteSwAttachFile(String postId) {
        return this.campaignSingleKakaoMapper.deleteSwAttachFile(postId);
    }
}

