/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.single;

import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.mapper.campaign.single.CampaignSingleEmailMapper;
import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.service.campaign.single.CampaignSingleEmailService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CampaignSingleEmailServiceImpl
implements CampaignSingleEmailService {
    private static final Logger log = LoggerFactory.getLogger(CampaignSingleEmailServiceImpl.class);
    @Value(value="${camp.content.path}")
    private String fileMsgUploadPath;
    @Autowired
    private CampaignSingleEmailMapper campaignSingleEmailMapper;

    @Override
    public List<EntityMap> selectCampMsg(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        entityMap.put("CHANNEL_TYPE", (Object)ChannelType.EMAIL.getCode());
        return this.campaignSingleEmailMapper.selectCampMsg(entityMap);
    }

    @Override
    public List<EntityMap> selectCampMsgByPostId(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        entityMap.put("CHANNEL_TYPE", (Object)ChannelType.EMAIL.getCode());
        return this.campaignSingleEmailMapper.selectCampMsgByPostId(entityMap);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int updateCampMsg(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        int msgUpdateCount = this.campaignSingleEmailMapper.updateCampMsgInfo(entityMap);
        int chnUpdateCount = this.saveCampChnMsg(entityMap);
        return msgUpdateCount * chnUpdateCount;
    }

    public int saveCampChnMsg(EntityMap entityMap) {
        String postId = (String)entityMap.get("POST_ID");
        String html_base_path = this.fileMsgUploadPath;
        try {
            FileUtil.makeUrl((String)html_base_path);
        }
        catch (IOException e1) {
            log.error("makeUrl error : {}", (Throwable)e1);
        }
        if (entityMap.get("CHANNEL_TYPE").equals(ChannelType.EMAIL.getCode())) {
            String baseContentPath = html_base_path + "/" + postId + ".email";
            try {
                FileUtil.writeLocal((String)baseContentPath, (String)StringUtils.validString((Object)entityMap.get("CONTENT")), (boolean)false);
                entityMap.put("CONTENT_HTML", (Object)(postId + ".email"));
            }
            catch (Exception e) {
                log.error("camp writeLocal error : {}", (Throwable)e);
            }
        }
        return this.campaignSingleEmailMapper.saveCampChnInfo(entityMap);
    }

    @Override
    public String getContentHtml(EntityMap entityMap) {
        String html_base_path = this.fileMsgUploadPath;
        String thisContentPath = html_base_path + "/" + entityMap.get("CONTENT_HTML");
        String content = "";
        try {
            content = FileUtil.readLocal((String)thisContentPath);
            log.info(content);
        }
        catch (IOException e) {
            log.error("error : {}", (Throwable)e);
        }
        return content;
    }
}

