/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign.multi;

import com.humuson.tms.common.util.ExcelDataConvertor;
import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.SiteUtil;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.ContentType;
import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.mapper.TmsCampLinkInfoMapper;
import com.humuson.tms.mapper.campaign.TmsCampChnInfoMapper;
import com.humuson.tms.mapper.campaign.TmsCampMsgInfoMapper;
import com.humuson.tms.mapper.campaign.TmsCampSchdInfoMapper;
import com.humuson.tms.mapper.campaign.multi.CampaignMultiMsgMapper;
import com.humuson.tms.model.CampSchdInfo;
import com.humuson.tms.model.CampaignChannelInfo;
import com.humuson.tms.model.CampaignMsgInfo;
import com.humuson.tms.model.MappingCodeInfo;
import com.humuson.tms.model.MassSendListInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.TargetConditionInfo;
import com.humuson.tms.model.TargetServerInfo;
import com.humuson.tms.model.TargetTableQueryInfo;
import com.humuson.tms.model.TmsCampChnInfo;
import com.humuson.tms.model.targeting.TmsCampTargetInfo;
import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.CommonCodeService;
import com.humuson.tms.service.campaign.multi.CampaignMultiMsgService;
import com.vdurmont.emoji.EmojiParser;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class CampaignMultiMsgServiceImpl
implements CampaignMultiMsgService {
    private static final Logger log = LoggerFactory.getLogger(CampaignMultiMsgServiceImpl.class);
    @Value(value="${target.upload.path}")
    private String path;
    @Value(value="${camp.content.path}")
    private String fileMsgUploadPath;
    @Autowired
    private CampaignMultiMsgMapper campaignMultiMsgMapper;
    @Autowired
    private TmsCampMsgInfoMapper tmsCampMsgInfoMapper;
    @Autowired
    private TmsCampLinkInfoMapper tmsCampLinkInfoMapper;
    @Autowired
    private TmsCampChnInfoMapper tmsCampChnInfoMapper;
    @Autowired
    private TmsCampSchdInfoMapper tmsCampSchdInfoMapper;
    @Autowired
    private CommonCodeService commonCodeService;

    @Override
    public List<CampaignChannelInfo> selectMultiChnInfo(String msgId) {
        return this.campaignMultiMsgMapper.selectMultiChnInfo(msgId);
    }

    @Override
    public String getFirstChannelType(String postId) {
        return this.campaignMultiMsgMapper.getFirstChannelType(postId);
    }

    @Override
    public String getMktYnByMsgId(String msgId) {
        return this.tmsCampMsgInfoMapper.getMktYnByMsgId(msgId);
    }

    @Override
    public int updateDivideFlagCampMsgInfo(String msgId, String divideSendUseYn) {
        return this.tmsCampMsgInfoMapper.updateDivideFlagCampMsgInfo(msgId, divideSendUseYn);
    }

    @Override
    public JSONObject checkMultiComplete(String msgId, String abTestYn) {
        int cnt = 0;
        JSONObject result = new JSONObject();
        String resultMsg = "complete";
        String postId = "";
        List<CampaignChannelInfo> list = this.selectMultiChnInfo(msgId);
        for (CampaignChannelInfo info : list) {
            if (info.getContentHtml() != null && !info.getContentHtml().equals("")) continue;
            ++cnt;
        }
        if (list.get(0).getAbTestYn().equals("Y")) {
            postId = list.get(list.get(0).getAbTestCount()).getPPostId();
            if (cnt > 1) {
                resultMsg = "fail";
            }
        } else {
            postId = list.get(0).getPostId();
            if (cnt > 0) {
                resultMsg = "fail";
            }
        }
        result.put((Object)"resultMsg", (Object)resultMsg);
        result.put((Object)"postId", (Object)postId);
        return result;
    }

    @Override
    public String getFirstPostId(String msgId) {
        List<CampaignChannelInfo> list = this.selectMultiChnInfo(msgId);
        return list.get(0).getPostId();
    }

    @Override
    public String selectPPostIdTask(String msgId) {
        String result = "";
        List<Object> list = new ArrayList();
        list = this.selectPPostId(msgId);
        for (CampaignChannelInfo campaignChannelInfo : list) {
            if (campaignChannelInfo.getCnt() <= 1) continue;
            result = campaignChannelInfo.getPPostId();
        }
        return result;
    }

    @Override
    public List<CampaignChannelInfo> selectPPostId(String msgId) {
        return this.campaignMultiMsgMapper.selectPPostId(msgId);
    }

    @Override
    public List<EntityMap> selectCampMsg(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        return this.campaignMultiMsgMapper.selectCampMsg(entityMap);
    }

    @Override
    public List<EntityMap> selectCampMsgByPostId(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        return this.campaignMultiMsgMapper.selectCampMsgByPostId(entityMap);
    }

    @Override
    public String selectChannelType(String postId) {
        return this.campaignMultiMsgMapper.selectChannelType(postId);
    }

    @Override
    public String selectChannelList(String msgId) {
        return this.campaignMultiMsgMapper.selectChannelList(msgId);
    }

    @Override
    public int updateSmsMsg(Map<String, String> param) {
        CampaignChannelInfo campChnInfo = new CampaignChannelInfo();
        campChnInfo.setPostId(param.get("POST_ID"));
        campChnInfo.setFromName(param.get("FROM_NAME"));
        campChnInfo.setMsgId(param.get("MSG_ID"));
        campChnInfo.setSubject(param.get("SUBJECT"));
        campChnInfo.setContentHtml(param.get("POST_ID") + ".sms");
        campChnInfo.setFromNumber(param.get("USER_TEL"));
        campChnInfo.setSmsType(param.get("SMS_TYPE"));
        return this.campaignMultiMsgMapper.updateSmsMsg(campChnInfo);
    }

    @Override
    public List<CampaignMsgInfo> selectCampMsgInfo(String msgId) {
        log.info("msgId : {}", (Object)msgId);
        return this.campaignMultiMsgMapper.selectCampMsgInfo(msgId);
    }

    @Override
    public int insertCampMsg(CampaignMsgInfo campaignMsgInfo) {
        return this.campaignMultiMsgMapper.insertCampMsg(campaignMsgInfo);
    }

    @Override
    public int saveCampChannelInfo(CampaignChannelInfo campaignChannelInfo) {
        return this.campaignMultiMsgMapper.saveCampChannelInfo(campaignChannelInfo);
    }

    @Override
    public String insertCampaignMsgChn(CampaignMsgInfo campaignMsgInfo, CampaignChannelInfo campaignChannelInfo) {
        String[] msgNameArray = new String[]{"Type A_", "Type B_", "Type C_", "Type D_", "Type E_", "Type F_"};
        String resultMsgId = "fail";
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date now = new Date();
        String today = format.format(now);
        if (campaignMsgInfo.getAbTestYn().equals("N")) {
            log.info("AB TEST OFF");
            int todayMsgCnt = this.selectCountMsgId();
            int todayChnCnt = this.selectCountChnId();
            if (todayMsgCnt == 0) {
                campaignMsgInfo.setMsgId(today + "00001");
            } else {
                campaignMsgInfo.setMsgId(this.selectMsgId());
            }
            campaignChannelInfo.setMsgId(campaignMsgInfo.getMsgId());
            if (todayChnCnt == 0) {
                campaignChannelInfo.setPostId(today + "00001");
            }
            campaignChannelInfo.setChannelMsgName(campaignMsgInfo.getMsgName());
            this.insertCampMsg(campaignMsgInfo);
            this.saveCampChannelInfo(campaignChannelInfo);
            resultMsgId = campaignMsgInfo.getMsgId();
        } else {
            log.info("AB TEST ON");
            int todayMsgCnt = this.selectCountMsgId();
            int todayChnCnt = this.selectCountChnId();
            if (todayMsgCnt == 0) {
                campaignMsgInfo.setMsgId(today + "00001");
            } else {
                campaignMsgInfo.setMsgId(this.selectMsgId());
            }
            this.insertCampMsg(campaignMsgInfo);
            campaignChannelInfo.setMsgId(campaignMsgInfo.getMsgId());
            for (int i = 0; i < campaignMsgInfo.getAbTestCount(); ++i) {
                campaignChannelInfo.setChannelMsgName(msgNameArray[i] + campaignMsgInfo.getMsgName());
                if (todayChnCnt == 0 && i == 0) {
                    campaignChannelInfo.setPostId(today + "00001");
                } else {
                    campaignChannelInfo.setPostId(null);
                }
                this.saveCampChannelInfo(campaignChannelInfo);
            }
            campaignChannelInfo.setChannelMsgName("AB result_" + campaignMsgInfo.getMsgName());
            this.saveCampChannelInfo(campaignChannelInfo);
            resultMsgId = campaignMsgInfo.getMsgId();
        }
        return resultMsgId;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int updateCampaignMsgChn(Map<String, String> params) {
        String msgName = params.get("msgName");
        String campId = params.get("campId");
        String msgId = params.get("msgId");
        String channelType = params.get("channelType");
        String abTestYn = params.get("abTestYn");
        CampaignMsgInfo msgInfo = new CampaignMsgInfo();
        msgInfo.setMsgName(msgName);
        msgInfo.setCampId(campId);
        msgInfo.setMsgId(msgId);
        msgInfo.setChannelType(channelType);
        msgInfo.setAbTestYn(abTestYn);
        CampaignChannelInfo channelInfo = new CampaignChannelInfo();
        channelInfo.setMsgName(msgName);
        channelInfo.setCampId(campId);
        channelInfo.setMsgId(msgId);
        channelInfo.setChannelType(channelType);
        channelInfo.setAbTestYn(abTestYn);
        int msgResult = this.campaignMultiMsgMapper.updateCampMsgInfo(msgInfo);
        int channelResult = this.campaignMultiMsgMapper.updateCampChannelInfo(channelInfo);
        return msgResult * channelResult;
    }

    @Override
    public String selectChnId() {
        return this.campaignMultiMsgMapper.selectChnId();
    }

    @Override
    public String selectMsgId() {
        return this.campaignMultiMsgMapper.selectMsgId();
    }

    @Override
    public int selectCountChnId() {
        return this.campaignMultiMsgMapper.selectCountChnId();
    }

    @Override
    public int selectCountMsgId() {
        return this.campaignMultiMsgMapper.selectCountMsgId();
    }

    @Override
    public List<CampaignChannelInfo> selectPushChnInfo(String postId) {
        return this.campaignMultiMsgMapper.selectPushChnInfo(postId);
    }

    @Override
    public List<CampaignChannelInfo> selectChnInfo(String pPostId) {
        return this.campaignMultiMsgMapper.selectChnInfo(pPostId);
    }

    @Override
    public int updatePushMsg(CampaignChannelInfo campaignChannelInfo) {
        return this.campaignMultiMsgMapper.updatePushMsg(campaignChannelInfo);
    }

    @Override
    public String checkABComplete(String msgId) {
        int cnt = 0;
        String result = "complete";
        List<Object> list = new ArrayList();
        list = this.selectPushChnInfo(msgId);
        for (CampaignChannelInfo campaignChannelInfo : list) {
            if (campaignChannelInfo.getPushTitle() != "" && campaignChannelInfo.getPushTitle() != null && !campaignChannelInfo.getPushTitle().equals("")) continue;
            ++cnt;
        }
        if (cnt > 1) {
            result = "fail";
        }
        log.info("checkAB:" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String targetFileSave(Map<String, String> param, MultipartHttpServletRequest mpRequest) {
        Iterator fileNameIterator = mpRequest.getFileNames();
        String charSet = param.get("charSet");
        if (charSet == null) {
            log.info("file upload charset is null");
            charSet = "utf-8";
        }
        String fileName = "";
        InputStream stream = null;
        while (fileNameIterator.hasNext()) {
            int idx;
            String fileExt;
            MultipartFile multiFile = mpRequest.getFile((String)fileNameIterator.next());
            if (multiFile.getSize() <= 0L) continue;
            OutputStream bos = null;
            try {
                String t_fileName = multiFile.getOriginalFilename();
                stream = multiFile.getInputStream();
                int u = 0;
                do {
                    fileName = "tms_" + u + "_" + t_fileName;
                    ++u;
                } while (FileUtil.existsLocal((String)fileName, (String)this.path));
                bos = new FileOutputStream(this.path + "/" + fileName);
                fileName = this.path + "/" + fileName;
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
                bos.close();
                stream.close();
            }
            catch (Exception e) {
                log.error("file write error", (Throwable)e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception e) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (!(fileExt = fileName.substring((idx = fileName.lastIndexOf(".")) + 1)).toUpperCase().equals("XLS") && !fileExt.toUpperCase().equals("XLSX")) continue;
            String csvFileName = fileName.substring(0, fileName.lastIndexOf(".")).concat(".txt");
            if (fileExt.toUpperCase().equals("XLSX")) {
                try {
                    ExcelDataConvertor.XSLXToCSV((String)fileName, (String)csvFileName, (String)charSet);
                }
                catch (Exception e) {
                    log.error("Xslx convert error", (Throwable)e);
                }
            } else if (fileExt.toUpperCase().equals("XLS")) {
                try {
                    ExcelDataConvertor.XSLToCSV((String)fileName, (String)csvFileName, (String)charSet);
                }
                catch (Exception e) {
                    log.error("Xslx convert error", (Throwable)e);
                }
            }
            fileName = csvFileName;
        }
        return fileName;
    }

    @Override
    public int insertTargetServerTask(Map<String, String> param) {
        TargetServerInfo targetServerInfo = new TargetServerInfo();
        List<EntityMap> serverList = this.commonCodeService.commonCodeList("02");
        int insertCnt = 0;
        this.deleteTargetServer(param.get("msgId"));
        for (EntityMap server : serverList) {
            int rate;
            if (!param.containsKey(server.get("CODE1") + "_" + param.get("targetType") + "_SERVER_" + server.get("CODE4")) || (rate = Integer.parseInt(param.get(server.get("CODE1") + "_" + param.get("targetType") + "_SERVER_" + server.get("CODE4")))) == 0) continue;
            targetServerInfo.setChannelType(server.get("CODE1").toString());
            targetServerInfo.setPostId(param.get("postId"));
            targetServerInfo.setMsgId(param.get("msgId"));
            targetServerInfo.setServerId(server.get("CODE4").toString());
            targetServerInfo.setParticipationRate(rate);
            insertCnt += this.insertTargetServer(targetServerInfo);
        }
        return insertCnt;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int insertTargetAbTestTask(Map<String, String> param) {
        TargetServerInfo targetServerInfo = new TargetServerInfo();
        List<EntityMap> serverList = this.commonCodeService.commonCodeList("02");
        int insertCnt = 0;
        param.put("isAll", "Y");
        String pPostId = this.selectPPostIdTask(param.get("msgId"));
        List<CampaignChannelInfo> postList = this.selectChnInfo(pPostId);
        for (CampaignChannelInfo postMap : postList) {
            targetServerInfo.setPostId(postMap.getPostId());
            targetServerInfo.setMsgId(postMap.getMsgId());
            for (EntityMap server : serverList) {
                int rate;
                if (!param.containsKey(server.get("CODE1") + "_" + param.get("targetType") + "_SERVER_" + server.get("CODE4")) || (rate = Integer.parseInt(param.get(server.get("CODE1") + "_" + param.get("targetType") + "_SERVER_" + server.get("CODE4")))) == 0) continue;
                targetServerInfo.setChannelType(server.get("CODE1").toString());
                targetServerInfo.setServerId(server.get("CODE4").toString());
                targetServerInfo.setParticipationRate(rate);
                insertCnt += this.insertTargetServer(targetServerInfo);
            }
        }
        return insertCnt;
    }

    @Override
    public int insertTargetServer(TargetServerInfo targetServerInfo) {
        return this.campaignMultiMsgMapper.insertTargetServer(targetServerInfo);
    }

    @Override
    public List<MappingCodeInfo> fileTargetMappingCode() {
        return this.campaignMultiMsgMapper.fileTargetMappingCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertTargetTask(Map<String, String> param) {
        TmsCampTargetInfo targetDataInfo = new TmsCampTargetInfo();
        int result = 0;
        targetDataInfo.setTargetType(param.get("targetType"));
        targetDataInfo.setChannelType(param.get("channelType"));
        targetDataInfo.setAbTestYn(param.get("abTestYn"));
        targetDataInfo.setRegId(param.get("regId"));
        targetDataInfo.setTargetFileHeadFlag(param.get("targetFileHeaderFlag"));
        targetDataInfo.setTargetFileDelim(param.get("targetFileDelim"));
        targetDataInfo.setRegId(param.get("regId"));
        targetDataInfo.setUseCondition("N");
        targetDataInfo.setDeduplicationYn(param.get("deduplicationYn"));
        if (param.get("targetType").equals("FILE")) {
            String FileName = param.get("FILE_NAME");
            targetDataInfo.setAddSiteUserYn(param.get("addSiteUserYn"));
            int idx = FileName.lastIndexOf("/");
            String targetFileName = FileName.substring(idx + 1);
            targetDataInfo.setTargetFileName(targetFileName);
            targetDataInfo.setTargetStatus("T1");
            try {
                String tmpFileType = FileName.substring(FileName.lastIndexOf(".")).toUpperCase();
                if (tmpFileType.equals(".CSV")) {
                    targetDataInfo.setTargetFileEncoding("UTF-8");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                targetDataInfo.setTargetFileEncoding("UTF-8");
            }
            StringBuffer indexBuffer = new StringBuffer(256);
            int cnt = 1;
            String val = null;
            while ((val = param.get("idx" + cnt++)) != null) {
                indexBuffer.append(val + "|");
                log.info("[CampaignMultiMsgServiceImpl] val:{}, cnt:{}", (Object)val, (Object)cnt);
            }
            targetDataInfo.setTargetFileIdx(indexBuffer.substring(0, indexBuffer.length() - 1));
        }
        if (param.get("targetType").equals("DB")) {
            targetDataInfo.setAddSiteUserYn(param.get("addSiteUserDBYn"));
            targetDataInfo.setTargetDbId(param.get("targetDBId"));
            targetDataInfo.setTargetDbQuery(param.get("query"));
            targetDataInfo.setTargetStatus("T1");
        }
        if (param.get("targetType").equals("COND")) {
            targetDataInfo.setUsePlatform(param.get("usePlatform"));
            targetDataInfo.setUseLogin(param.get("useLogin"));
            targetDataInfo.setUseCondition(param.get("useCondition"));
            targetDataInfo.setAddSiteUserYn("N");
            targetDataInfo.setAppSessEnd(param.get("endDate").replaceAll("/", ""));
            targetDataInfo.setAppSessStart(param.get("startDate").replaceAll("/", ""));
            targetDataInfo.setTargetStatus("T1");
        }
        if (param.get("abTestYn").equals("Y")) {
            targetDataInfo.setPostId(this.selectPPostIdTask(param.get("msgId")));
        } else {
            targetDataInfo.setPostId(this.selectMinPostId(param.get("msgId")));
        }
        if (param.containsKey(param.get("targetType") + "_encrypt_yn")) {
            targetDataInfo.setEncryptYN(param.get(param.get("targetType") + "_encrypt_yn"));
        }
        if (param.get("targetType").equals("AMC")) {
            targetDataInfo.setAudienceSeq(param.get("audienceSeq"));
            targetDataInfo.setTargetStatus("T1");
        }
        targetDataInfo.setMsgId(param.get("msgId"));
        result = this.insertTarget(targetDataInfo);
        return result;
    }

    @Override
    public int insertTarget(TmsCampTargetInfo targetDataInfo) {
        this.campaignMultiMsgMapper.updateTargetingReset(targetDataInfo.getMsgId());
        return this.campaignMultiMsgMapper.insertTarget(targetDataInfo);
    }

    @Override
    public List<TmsCampTargetInfo> targetInfoList(String msgId) {
        return this.campaignMultiMsgMapper.targetInfoList(msgId);
    }

    @Override
    public TmsCampTargetInfo targetInfoDetail(String postId) {
        return this.campaignMultiMsgMapper.targetInfoDetail(postId);
    }

    @Override
    public int updateTargetingReset(String msgId) {
        return this.campaignMultiMsgMapper.updateTargetingReset(msgId);
    }

    @Override
    public int updateTargetingStop(String msgId, String targetStatus) {
        return this.campaignMultiMsgMapper.updateTargetingStop(msgId, targetStatus);
    }

    @Override
    public int deleteTargetServer(String msgId) {
        return this.campaignMultiMsgMapper.deleteTargetServer(msgId);
    }

    @Override
    public List<TmsCampTargetInfo> tgtDBQueryList(String targetDBId, String regId) {
        return this.campaignMultiMsgMapper.tgtDBQueryList(targetDBId, regId);
    }

    @Override
    public int tgtDBQueryCreate(TargetTableQueryInfo targetTableQueryInfo) {
        return this.campaignMultiMsgMapper.tgtDBQueryCreate(targetTableQueryInfo);
    }

    @Override
    public int tgtDBQuerySave(TargetTableQueryInfo targetTableQueryInfo) {
        return this.campaignMultiMsgMapper.tgtDBQuerySave(targetTableQueryInfo);
    }

    @Override
    public int tgtDBQueryDelete(TargetTableQueryInfo targetTableQueryInfo) {
        return this.campaignMultiMsgMapper.tgtDBQueryDelete(targetTableQueryInfo);
    }

    @Override
    public int insertSchedule(CampSchdInfo campSchdInfo) {
        return this.campaignMultiMsgMapper.insertSchedule(campSchdInfo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Throwable.class})
    public int emailSend(Map<String, String> param) {
        int resultCnt;
        block6: {
            CampSchdInfo campSchdInfo;
            String abTestYn;
            String pPostId;
            String servers;
            block5: {
                resultCnt = 0;
                servers = param.get("servers");
                String postId = this.selectMinPostId(param.get("msgId"));
                pPostId = param.get("pPostId");
                abTestYn = param.get("abTestYn");
                param.put("channelType", "EM");
                campSchdInfo = new CampSchdInfo();
                campSchdInfo.setChannelType("EM");
                campSchdInfo.setMsgId(param.get("msgId"));
                campSchdInfo.setPostId(postId);
                campSchdInfo.setReqDate(param.get("reqDate"));
                campSchdInfo.setApprovalReqYn(param.get("approvalReqYn"));
                campSchdInfo.setApprovalReqId(param.get("approvalReqId"));
                if (!abTestYn.equals("N") && abTestYn != null && !"".equals(abTestYn)) break block5;
                List<TargetServerInfo> targetServerInfo = this.selectServerInfo(postId);
                if (servers.equals("")) break block6;
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setPostId(postId);
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + postId));
                    campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + postId)));
                    campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + postId)));
                    resultCnt += this.insertSchedule(campSchdInfo);
                }
                break block6;
            }
            List<CampaignChannelInfo> campaignChannelInfo = this.selectPostIdByAbTest(pPostId);
            List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
            if (!servers.equals("")) {
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    for (int j = 0; j < campaignChannelInfo.size(); ++j) {
                        if (campaignChannelInfo.get(j).getPostId().equals(campaignChannelInfo.get(j).getPPostId())) {
                            campSchdInfo.setAbTestYn(abTestYn);
                        }
                        campSchdInfo.setPostId(campaignChannelInfo.get(j).getPostId());
                        campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(j).getPostId()));
                        campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(j).getPostId())));
                        campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(j).getPostId())));
                        resultCnt += this.insertSchedule(campSchdInfo);
                    }
                    campSchdInfo.setAbTestYn("N");
                }
            }
        }
        return resultCnt;
    }

    @Override
    @Transactional
    public int smsSend(Map<String, String> param) {
        int resultCnt;
        block6: {
            CampSchdInfo campSchdInfo;
            String abTestYn;
            String pPostId;
            String servers;
            block5: {
                resultCnt = 0;
                servers = param.get("servers");
                String postId = this.selectMinPostId(param.get("msgId"));
                pPostId = param.get("pPostId");
                abTestYn = param.get("abTestYn");
                param.put("channelType", "SM");
                campSchdInfo = new CampSchdInfo();
                campSchdInfo.setChannelType("SM");
                campSchdInfo.setMsgId(param.get("msgId"));
                campSchdInfo.setPostId(postId);
                campSchdInfo.setReqDate(param.get("reqDate"));
                campSchdInfo.setApprovalReqYn(param.get("approvalReqYn"));
                campSchdInfo.setApprovalReqId(param.get("approvalReqId"));
                if (!abTestYn.equals("N") && abTestYn != null && !"".equals(abTestYn)) break block5;
                List<TargetServerInfo> targetServerInfo = this.selectServerInfo(postId);
                if (servers.equals("")) break block6;
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setPostId(postId);
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + postId));
                    campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + postId)));
                    campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + postId)));
                    resultCnt += this.insertSchedule(campSchdInfo);
                }
                break block6;
            }
            List<CampaignChannelInfo> campaignChannelInfo = this.selectPostIdByAbTest(pPostId);
            List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
            if (!servers.equals("")) {
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    for (int j = 0; j < campaignChannelInfo.size(); ++j) {
                        if (campaignChannelInfo.get(j).getPostId().equals(campaignChannelInfo.get(j).getPPostId())) {
                            campSchdInfo.setAbTestYn(abTestYn);
                        }
                        campSchdInfo.setPostId(campaignChannelInfo.get(j).getPostId());
                        campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(j).getPostId()));
                        campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(j).getPostId())));
                        campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(j).getPostId())));
                        resultCnt += this.insertSchedule(campSchdInfo);
                    }
                    campSchdInfo.setAbTestYn("N");
                }
            }
        }
        return resultCnt;
    }

    @Override
    @Transactional
    public int pushSend(Map<String, String> param) {
        int resultCnt;
        block6: {
            CampSchdInfo campSchdInfo;
            String abTestYn;
            String pPostId;
            String servers;
            block5: {
                resultCnt = 0;
                servers = param.get("servers");
                String postId = this.selectMinPostId(param.get("msgId"));
                pPostId = param.get("pPostId");
                abTestYn = param.get("abTestYn");
                param.put("channelType", "PU");
                campSchdInfo = new CampSchdInfo();
                campSchdInfo.setChannelType("PU");
                campSchdInfo.setMsgId(param.get("msgId"));
                campSchdInfo.setPostId(postId);
                campSchdInfo.setReqDate(param.get("reqDate"));
                campSchdInfo.setApprovalReqYn(param.get("approvalReqYn"));
                campSchdInfo.setApprovalReqId(param.get("approvalReqId"));
                if (!abTestYn.equals("N") && abTestYn != null && !"".equals(abTestYn)) break block5;
                List<TargetServerInfo> targetServerInfo = this.selectServerInfo(postId);
                if (servers.equals("")) break block6;
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setPostId(postId);
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + postId));
                    campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + postId)));
                    campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + postId)));
                    resultCnt += this.insertSchedule(campSchdInfo);
                }
                break block6;
            }
            List<CampaignChannelInfo> campaignChannelInfo = this.selectPostIdByAbTest(pPostId);
            List<TargetServerInfo> targetServerInfo = this.selectServerInfo(campaignChannelInfo.get(0).getPostId());
            if (!servers.equals("")) {
                for (int i = 0; i < targetServerInfo.size(); ++i) {
                    campSchdInfo.setServerId(targetServerInfo.get(i).getServerId());
                    campSchdInfo.setTargetCnt(targetServerInfo.get(i).getTargetCnt());
                    for (int j = 0; j < campaignChannelInfo.size(); ++j) {
                        if (campaignChannelInfo.get(j).getPostId().equals(campaignChannelInfo.get(j).getPPostId())) {
                            campSchdInfo.setAbTestYn(abTestYn);
                        }
                        campSchdInfo.setPostId(campaignChannelInfo.get(j).getPostId());
                        campSchdInfo.setDivideSendUseYn(param.get("divideDetailFlag_" + campaignChannelInfo.get(j).getPostId()));
                        campSchdInfo.setDivideCnt(Integer.parseInt(param.get("divideCnt_" + campaignChannelInfo.get(j).getPostId())));
                        campSchdInfo.setDivideMinute(Integer.parseInt(param.get("divideMinute_" + campaignChannelInfo.get(j).getPostId())));
                        resultCnt += this.insertSchedule(campSchdInfo);
                    }
                    campSchdInfo.setAbTestYn("N");
                }
            }
        }
        return resultCnt;
    }

    @Override
    @Transactional
    public String updatePostIdTask(String msgId) {
        String pPostId = this.selectMaxPostId(msgId);
        this.updatePostId(msgId, pPostId);
        return pPostId;
    }

    @Override
    public CampaignChannelInfo selectChannelInfo(String postId, String channelType) {
        return this.campaignMultiMsgMapper.selectChannelInfo(postId, channelType);
    }

    @Override
    public List<CampSchdInfo> checkSchdInfo(String msgId) {
        return this.campaignMultiMsgMapper.checkSchdInfo(msgId);
    }

    @Override
    public List<EntityMap> commonServerList(String msgId) {
        return this.campaignMultiMsgMapper.commonServerList(msgId);
    }

    @Override
    public CampaignChannelInfo messageChannelInfos(String postId, String msgId, String abTestYn, String channelType) {
        return this.campaignMultiMsgMapper.messageChannelInfos(postId, msgId, abTestYn, channelType);
    }

    @Override
    public List<CampaignMsgInfo> messageInfo(String msgId) {
        return this.campaignMultiMsgMapper.messageInfo(msgId);
    }

    @Override
    public List<CampaignChannelInfo> selectPostIdByAbTest(String msgId) {
        return this.campaignMultiMsgMapper.selectPostIdByAbTest(msgId);
    }

    @Override
    public List<TargetServerInfo> selectServerInfo(String postId) {
        return this.campaignMultiMsgMapper.selectServerInfo(postId);
    }

    @Override
    public int deleteCampaign(String msgId) {
        return this.campaignMultiMsgMapper.deleteCampaign(msgId);
    }

    @Override
    public List<TargetConditionInfo> selectTargetClass() {
        return this.campaignMultiMsgMapper.selectTargetClass();
    }

    @Override
    public List<Map<String, String>> selectTargetClassDetail(String infoCode) {
        return this.campaignMultiMsgMapper.selectTargetClassDetail(infoCode);
    }

    @Override
    public int insertTargetConditionData(TargetConditionInfo targetConditionInfo) {
        return this.campaignMultiMsgMapper.insertTargetConditionData(targetConditionInfo);
    }

    @Override
    public String selectMaxPostId(String msgId) {
        return this.campaignMultiMsgMapper.selectMaxPostId(msgId);
    }

    @Override
    public int updatePostId(String msgId, String pPostId) {
        return this.campaignMultiMsgMapper.updatePostId(msgId, pPostId);
    }

    @Override
    public List<EntityMap> selectTargetStatus(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        return this.campaignMultiMsgMapper.selectTargetInfo(entityMap);
    }

    @Override
    public int selectSchdInfoCnt(Map<String, String> params) {
        EntityMap entityMap = new EntityMap();
        entityMap.putAll(params);
        return this.campaignMultiMsgMapper.selectSchdInfoCnt(entityMap);
    }

    @Override
    public String selectReqDate(String msgId) {
        return this.campaignMultiMsgMapper.selectReqDate(msgId);
    }

    @Override
    public String selectMinPostId(String msgId) {
        return this.campaignMultiMsgMapper.selectMinPostId(msgId);
    }

    @Override
    public String getContentHtml(EntityMap entityMap) {
        String html_base_path = this.fileMsgUploadPath;
        String thisContentPath = html_base_path + "/" + entityMap.get("CONTENT_HTML");
        String content = "";
        try {
            content = FileUtil.readLocal((String)thisContentPath);
            log.info(content);
        }
        catch (IOException e) {
            log.error("error : {}", (Throwable)e);
        }
        return content;
    }

    @Override
    public List<CampaignChannelInfo> getPushContent(List<CampaignChannelInfo> list) {
        String html_base_path = this.fileMsgUploadPath;
        for (int i = 0; i < list.size(); ++i) {
            CampaignChannelInfo channelInfo = list.get(i);
            if (ChannelType.PUSH.same(channelInfo.getChannelType()) && channelInfo.getContentHtml() != null && !channelInfo.getContentHtml().equals("")) {
                String thisContentPath = html_base_path + "/" + channelInfo.getContentHtml();
                try {
                    String content = FileUtil.readLocal((String)thisContentPath);
                    if (ContentType.TEXT_PUSH.same(channelInfo.getContentType())) {
                        list.get(i).setInAppContent(EmojiParser.parseToUnicode((String)content));
                        continue;
                    }
                    String[] contents = content.split("/\\*\\*PUSH_DELIM\\*\\*/");
                    String popupContent = "";
                    String inAppContent = "";
                    if (contents.length > 0) {
                        popupContent = contents[0];
                        inAppContent = contents[1];
                    }
                    list.get(i).setPopupContent(EmojiParser.parseToUnicode((String)popupContent));
                    list.get(i).setInAppContent(EmojiParser.parseToUnicode((String)inAppContent));
                }
                catch (Exception e) {
                    log.error("file read local error : {}", (Throwable)e);
                }
                continue;
            }
            list.get(i).setPopupContent("");
            list.get(i).setInAppContent("");
        }
        return list;
    }

    @Override
    public List<CampaignChannelInfo> getContent(List<CampaignChannelInfo> list) {
        String html_base_path = this.fileMsgUploadPath;
        for (int i = 0; i < list.size(); ++i) {
            String content;
            String thisContentPath;
            CampaignChannelInfo channelInfo = list.get(i);
            if (ChannelType.PUSH.same(channelInfo.getChannelType())) {
                if (channelInfo.getContentHtml() != null && !channelInfo.getContentHtml().equals("")) {
                    thisContentPath = html_base_path + "/" + channelInfo.getContentHtml();
                    try {
                        content = FileUtil.readLocal((String)thisContentPath);
                        if (ContentType.RICH_PUSH.same(channelInfo.getContentType())) {
                            String[] contents = content.split("/\\*\\*PUSH_DELIM\\*\\*/");
                            String popupContent = "";
                            String inAppContent = "";
                            if (contents.length > 0) {
                                popupContent = contents[0];
                                inAppContent = contents[1];
                            }
                            list.get(i).setPopupContent(EmojiParser.parseToUnicode((String)popupContent));
                            list.get(i).setInAppContent(EmojiParser.parseToUnicode((String)inAppContent));
                            continue;
                        }
                        list.get(i).setInAppContent(EmojiParser.parseToUnicode((String)content));
                    }
                    catch (IOException e) {
                        log.error("file read local error : {}", (Throwable)e);
                    }
                    continue;
                }
                list.get(i).setPopupContent("");
                list.get(i).setInAppContent("");
                continue;
            }
            if (ChannelType.EMAIL.same(channelInfo.getChannelType())) {
                if (channelInfo.getContentHtml() == null || channelInfo.getContentHtml().equals("")) continue;
                thisContentPath = html_base_path + "/" + channelInfo.getContentHtml();
                try {
                    content = FileUtil.readLocal((String)thisContentPath);
                    list.get(i).setEmailContent(content);
                }
                catch (IOException e) {
                    log.error("file read local error : {}", (Throwable)e);
                }
                continue;
            }
            if (!ChannelType.SMS.same(channelInfo.getChannelType()) || channelInfo.getContentHtml() == null || channelInfo.getContentHtml().equals("")) continue;
            thisContentPath = html_base_path + "/" + channelInfo.getContentHtml();
            try {
                content = FileUtil.readLocal((String)thisContentPath);
                list.get(i).setSmsContent(content);
                continue;
            }
            catch (IOException e) {
                log.error("file read local error : {}", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public String selectAppImg(String appGrpId) {
        return this.campaignMultiMsgMapper.selectAppImg(appGrpId);
    }

    @Override
    public List<CampaignChannelInfo> selectPushChnInfoByPostId(String msgId) {
        return this.campaignMultiMsgMapper.selectPushChnInfoByPostId(msgId);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> randomTargetList(String msgId) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.targetListTable();
        log.info(ms.toString());
        List<MassSendListInfo> masssendList = this.campaignMultiMsgMapper.randomTargetList(ms);
        return masssendList;
    }

    @Override
    public int sendResendSchduleInfo(String msgId, String postId, String serverId) {
        return this.campaignMultiMsgMapper.sendResendSchduleInfo(msgId, postId, serverId);
    }

    @Override
    public int sendSchduleInfoUpdate(String msgId, String postId, String serverId, String reqDate) {
        return this.campaignMultiMsgMapper.sendSchduleInfoUpdate(msgId, postId, serverId, reqDate);
    }

    @Override
    public int sendApprovalSchduleInfo(String msgId, String postId, String serverId, String userId) {
        return this.campaignMultiMsgMapper.sendApprovalSchduleInfo(msgId, postId, serverId, userId);
    }

    @Override
    public int sendApprovalRejectSchduleInfo(String msgId, String postId, String serverId, String userId) {
        return this.campaignMultiMsgMapper.sendApprovalRejectSchduleInfo(msgId, postId, serverId, userId);
    }

    @Override
    public int sendApprovalRejectedSchdUpdate(String msgId, String postId, String serverId, String userId) {
        return this.campaignMultiMsgMapper.sendApprovalRejectedSchdUpdate(msgId, postId, serverId, userId);
    }

    @Override
    public int sendStopSchduleInfo(String msgId, String postId, String serverId) {
        return this.campaignMultiMsgMapper.sendStopSchduleInfo(msgId, postId, serverId);
    }

    @Override
    public String selectMsgChnList(String msgId) {
        return this.campaignMultiMsgMapper.selectMsgChnList(msgId);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<MassSendListInfo> randomTargetListByMemberId(String msgId, String memberId) {
        MassSendListInfo ms = new MassSendListInfo();
        ms.setMSG_ID(msgId);
        ms.setMEMBER_ID(memberId);
        ms.targetListTable();
        log.info(ms.toString());
        List<MassSendListInfo> masssendList = this.campaignMultiMsgMapper.randomTargetListByMemberId(ms);
        return masssendList;
    }

    @Override
    public int deleteConditionTarget(String msgId) {
        return this.campaignMultiMsgMapper.deleteConditionTarget(msgId);
    }

    @Override
    public List<CampaignChannelInfo> selectCopyList(TmsUserSession tmsUserSession, PageInfo pageInfo, String channelType, String regId, int siteId, String searchValue, String deptId) {
        pageInfo.calculate(this.selectCountCopyList(tmsUserSession, channelType, regId, siteId, searchValue, deptId));
        return this.campaignMultiMsgMapper.selectCopyList(tmsUserSession, pageInfo, channelType, regId, siteId, searchValue, deptId);
    }

    @Override
    public int selectCountCopyList(TmsUserSession tmsUserSession, String channelType, String regId, int siteId, String searchValue, String deptId) {
        return this.campaignMultiMsgMapper.selectCountCopyList(tmsUserSession, channelType, regId, siteId, searchValue, deptId);
    }

    @Override
    public List<CampaignChannelInfo> selectCopyChnInfo(String postId) {
        return this.campaignMultiMsgMapper.selectCopyChnInfo(postId);
    }

    @Override
    public void insertPushClickUrl(String postId, String pushContent) throws Exception {
        String[] splitPushContent = pushContent.split("/\\*\\*PUSH_DELIM\\*\\*/");
        if (splitPushContent != null && splitPushContent.length == 2) {
            int i;
            String pushPopupContent = splitPushContent[0];
            String inAppMsg = splitPushContent[1];
            Map popupContentLinkUrl = SiteUtil.getLinkFromHtml((String)pushPopupContent);
            Map inAppMsgLinkUrl = SiteUtil.getLinkFromHtml((String)inAppMsg);
            int clickInsertCnt = 0;
            this.tmsCampLinkInfoMapper.deleteLinkInfo(postId);
            for (i = 1; i <= popupContentLinkUrl.size(); ++i) {
                clickInsertCnt = this.tmsCampLinkInfoMapper.insertLinkInfo(postId, "P" + String.format("%02d", i), (String)popupContentLinkUrl.get(i));
                if (clickInsertCnt != 0) continue;
                throw new Exception("Click Url Insert Fail Exception");
            }
            for (i = 1; i <= inAppMsgLinkUrl.size(); ++i) {
                clickInsertCnt = this.tmsCampLinkInfoMapper.insertLinkInfo(postId, "M" + String.format("%02d", i), (String)inAppMsgLinkUrl.get(i));
                if (clickInsertCnt != 0) continue;
                throw new Exception("Click Url Insert Fail Exception");
            }
        }
    }

    @Override
    public List<TmsCampChnInfo> selectCampChnInfoByMsgId(String msgId) {
        return this.tmsCampChnInfoMapper.selectCampChnInfoByMsgId(msgId);
    }

    @Override
    public int updateCampChnInfo(String msgId, String postId, String divideSendUseYn, int divideCnt, int divideMinute) {
        return this.tmsCampChnInfoMapper.updateCampChnInfo(msgId, postId, divideSendUseYn, divideCnt, divideMinute);
    }

    @Override
    @Transactional
    public int campSchdDivideInfoUpdate(Map<String, String> param) {
        String msgId = param.get("msgId");
        List<CampSchdInfo> campSchdInfoList = this.tmsCampSchdInfoMapper.selectCampSchdInfo(msgId);
        int result = 1;
        for (CampSchdInfo campSchdInfo : campSchdInfoList) {
            result *= this.tmsCampSchdInfoMapper.updateSchdDivideInfo(msgId, campSchdInfo.getPostId(), param.get("divideDetailFlag_" + campSchdInfo.getPostId()), Integer.parseInt(param.get("divideCnt_" + campSchdInfo.getPostId())), Integer.parseInt(param.get("divideMinute_" + campSchdInfo.getPostId())));
        }
        return result;
    }
}

