/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.campaign;

import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.mapper.campaign.CampaignSendResultMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.SendResultInfo;
import com.humuson.tms.service.campaign.CampaignSendResultService;
import com.humuson.tms.service.excel.FillManagerSendResult;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CampaignSendResultServiceImpl
implements CampaignSendResultService {
    @Autowired
    private CampaignSendResultMapper campaignSendResultMapper;

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> selectSendResultList(SendResultInfo sendResultInfo, PageInfo pageInfo) {
        if (pageInfo != null) {
            pageInfo.calculate(this.campaignSendResultMapper.selectSendResultListTotalCount(sendResultInfo));
        }
        return this.campaignSendResultMapper.selectSendResultList(sendResultInfo, pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> selectClickResultList(SendResultInfo sendResultInfo, PageInfo pageInfo) {
        if (pageInfo != null) {
            pageInfo.calculate(this.campaignSendResultMapper.selectClickResultListTotalCount(sendResultInfo));
        }
        return this.campaignSendResultMapper.selectClickResultList(sendResultInfo, pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> selectSwitchedResultList(SendResultInfo sendResultInfo, PageInfo pageInfo) {
        if (pageInfo != null) {
            pageInfo.calculate(this.campaignSendResultMapper.selectSwitchedResultListTotalCount(sendResultInfo));
        }
        return this.campaignSendResultMapper.selectSwitchedResultList(sendResultInfo, pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> selectOpenResultList(SendResultInfo sendResultInfo, PageInfo pageInfo) {
        if (pageInfo != null) {
            pageInfo.calculate(this.campaignSendResultMapper.selectOpenResultListTotalCount(sendResultInfo));
        }
        return this.campaignSendResultMapper.selectOpenResultList(sendResultInfo, pageInfo);
    }

    @Override
    public void downloadCSV(HttpServletResponse response, List<SendResultInfo> sendResultInfoList, List<String> columnListTemp, String mode) {
        String title = "Send Result";
        ArrayList<String> columnList = new ArrayList<String>();
        HashMap<String, String> columnListInfo = new HashMap<String, String>();
        for (int i = 0; i < columnListTemp.size(); ++i) {
            String[] columnInfo = columnListTemp.get(i).split(":");
            if (Boolean.valueOf(columnInfo[0]).equals(false)) {
                columnList.add(columnInfo[2]);
            }
            columnListInfo.put(columnInfo[1], columnInfo[0]);
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet[] worksheet = new XSSFSheet[]{workbook.createSheet("Send Result")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnList, "");
        FillManagerSendResult.fillReportSendResult(worksheet[0], startRowIndex, startColIndex, sendResultInfoList, columnListInfo, mode);
        String fileName = title + ".csv";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/csv");
        Writer.write(response, worksheet);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> selectSwitchedSuccessResultList(SendResultInfo sendResultInfo, PageInfo pageInfo) {
        if (pageInfo != null) {
            pageInfo.calculate(this.campaignSendResultMapper.selectSwitchedSuccessResultListTotalCount(sendResultInfo));
        }
        return this.campaignSendResultMapper.selectSwitchedSuccessResultList(sendResultInfo, pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> selectSwitchedFailResultList(SendResultInfo sendResultInfo, PageInfo pageInfo) {
        if (pageInfo != null) {
            pageInfo.calculate(this.campaignSendResultMapper.selectSwitchedFailResultListTotalCount(sendResultInfo));
        }
        return this.campaignSendResultMapper.selectSwitchedFailResultList(sendResultInfo, pageInfo);
    }
}

