/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.automation;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.StatusType;
import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.exception.ResourceNotFoundException;
import com.humuson.tms.mapper.automation.AutoCommonMapper;
import com.humuson.tms.mapper.automation.AutoSendResultMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.SendResultInfo;
import com.humuson.tms.model.automation.AutoSendResultSearchForm;
import com.humuson.tms.service.automation.AutoSendResultService;
import com.humuson.tms.service.excel.FillManagerAutoSendResult;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoSendResultServiceImpl
implements AutoSendResultService {
    @Autowired
    AutoSendResultMapper autoSendResultMapper;
    @Autowired
    AutoCommonMapper autoCommonMapper;

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> getList(AutoSendResultSearchForm searchForm, PageInfo pageInfo) {
        String listTable = this.autoCommonMapper.getListTableByWorkdayAndSeq(searchForm.getWorkday(), searchForm.getSeqNo());
        if (StringUtils.isEmpty((CharSequence)listTable)) {
            throw new ResourceNotFoundException("List table Not Found");
        }
        if (pageInfo != null) {
            pageInfo.calculate(this.autoSendResultMapper.selectSendResultListTotalCount(searchForm, listTable, null));
        }
        return this.autoSendResultMapper.selectSendResultList(searchForm, listTable, null, pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> getSuccessList(AutoSendResultSearchForm searchForm, PageInfo pageInfo) {
        String listTable = this.autoCommonMapper.getListTableByWorkdayAndSeq(searchForm.getWorkday(), searchForm.getSeqNo());
        if (StringUtils.isEmpty((CharSequence)listTable)) {
            throw new ResourceNotFoundException("List table Not Found");
        }
        if (pageInfo != null) {
            pageInfo.calculate(this.autoSendResultMapper.selectSendResultListTotalCount(searchForm, listTable, StatusType.COMPLETE.getCode()));
        }
        return this.autoSendResultMapper.selectSendResultList(searchForm, listTable, StatusType.COMPLETE.getCode(), pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> getFailList(AutoSendResultSearchForm searchForm, PageInfo pageInfo) {
        String listTable = this.autoCommonMapper.getListTableByWorkdayAndSeq(searchForm.getWorkday(), searchForm.getSeqNo());
        if (StringUtils.isEmpty((CharSequence)listTable)) {
            throw new ResourceNotFoundException("List table Not Found");
        }
        if (pageInfo != null) {
            pageInfo.calculate(this.autoSendResultMapper.selectSendResultListTotalCount(searchForm, listTable, StatusType.ERROR.getCode()));
        }
        return this.autoSendResultMapper.selectSendResultList(searchForm, listTable, StatusType.ERROR.getCode(), pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> getOpenList(AutoSendResultSearchForm searchForm, PageInfo pageInfo) {
        String listTable = this.autoCommonMapper.getListTableByWorkdayAndSeq(searchForm.getWorkday(), searchForm.getSeqNo());
        if (StringUtils.isEmpty((CharSequence)listTable)) {
            throw new ResourceNotFoundException("List table Not Found");
        }
        if (pageInfo != null) {
            pageInfo.calculate(this.autoSendResultMapper.selectOpenResultListTotalCount(searchForm, listTable));
        }
        return this.autoSendResultMapper.selectOpenResultList(searchForm, listTable, pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> getClickList(AutoSendResultSearchForm searchForm, PageInfo pageInfo) {
        String listTable = this.autoCommonMapper.getListTableByWorkdayAndSeq(searchForm.getWorkday(), searchForm.getSeqNo());
        if (StringUtils.isEmpty((CharSequence)listTable)) {
            throw new ResourceNotFoundException("List table Not Found");
        }
        if (pageInfo != null) {
            pageInfo.calculate(this.autoSendResultMapper.selectClickResultListTotalCount(searchForm, listTable));
        }
        return this.autoSendResultMapper.selectClickResultList(searchForm, listTable, pageInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> getSwitchedList(AutoSendResultSearchForm searchForm, PageInfo pageInfo) {
        String listTable = this.autoCommonMapper.getListTableByWorkdayAndSeq(searchForm.getWorkday(), searchForm.getSeqNo());
        if (StringUtils.isEmpty((CharSequence)listTable)) {
            throw new ResourceNotFoundException("List table Not Found");
        }
        if (pageInfo != null) {
            pageInfo.calculate(this.autoSendResultMapper.selectSwitchedResultListTotalCount(searchForm, listTable));
        }
        return this.autoSendResultMapper.selectSwitchedResultList(searchForm, listTable, pageInfo);
    }

    @Override
    public void downloadCSV(HttpServletResponse response, List<SendResultInfo> sendResultInfoList, AutoSendResultSearchForm searchForm) {
        String title = "Send Result";
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> columnListInfo = new ArrayList<String>();
        String[] columns = searchForm.getColumnList();
        for (int i = 0; i < columns.length; ++i) {
            String[] columnInfo = columns[i].split(":");
            columnList.add(columnInfo[1]);
            columnListInfo.add(columnInfo[0]);
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet[] worksheet = new XSSFSheet[]{workbook.createSheet("Send Result")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnList, "");
        FillManagerAutoSendResult.fillReportSendResult(worksheet[0], startRowIndex, startColIndex, sendResultInfoList, columnListInfo);
        String fileName = title + ".csv";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/csv");
        Writer.write(response, worksheet);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> getSwitchedSuccList(AutoSendResultSearchForm searchForm, PageInfo pageInfo) {
        String listTable = this.autoCommonMapper.getListTableByWorkdayAndSeq(searchForm.getWorkday(), searchForm.getSeqNo());
        if (StringUtils.isEmpty((CharSequence)listTable)) {
            throw new ResourceNotFoundException("List table Not Found");
        }
        if (pageInfo != null) {
            pageInfo.calculate(this.autoSendResultMapper.selectSwitchedResultListTotalCount(searchForm, listTable, "SUCC"));
        }
        return this.autoSendResultMapper.selectSwitchedResultList(searchForm, listTable, pageInfo, "SUCC");
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<SendResultInfo> getSwitchedFailList(AutoSendResultSearchForm searchForm, PageInfo pageInfo) {
        String listTable = this.autoCommonMapper.getListTableByWorkdayAndSeq(searchForm.getWorkday(), searchForm.getSeqNo());
        if (StringUtils.isEmpty((CharSequence)listTable)) {
            throw new ResourceNotFoundException("List table Not Found");
        }
        if (pageInfo != null) {
            pageInfo.calculate(this.autoSendResultMapper.selectSwitchedResultListTotalCount(searchForm, listTable, "FAIL"));
        }
        return this.autoSendResultMapper.selectSwitchedResultList(searchForm, listTable, pageInfo, "FAIL");
    }
}

