/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.automation;

import com.humuson.tms.common.util.MessageUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.convert.aop.ConvertTarget;
import com.humuson.tms.convert.bind.DecryptAndMasking;
import com.humuson.tms.mapper.automation.AutoListMapper;
import com.humuson.tms.model.AutoMsgChnInfo;
import com.humuson.tms.model.AutoSendListInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.SiteInfo;
import com.humuson.tms.model.vo.AutoListInfo;
import com.humuson.tms.model.vo.AutoPreviewInfo;
import com.humuson.tms.model.vo.AutoSchdlInfo;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.automation.AutoMainService;
import com.humuson.tms.service.excel.FillManagerAutoCamp;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pluto.net.communicator.InfoBeans;
import pluto.net.communicator.InfoComunicator;
import pluto.util.convert.BASE64;

@Service
public class AutoMainServiceImpl
implements AutoMainService {
    @Autowired
    AutoListMapper autoListMapper;
    @Autowired
    private MessageUtil message;

    @Override
    public List<AutoListInfo> selectAutoListInfo(PageInfo pg, AutoListInfo autoListInfo, TmsUserSession tmsUserSession) {
        autoListInfo.calculateDate();
        pg.calculate(this.totalCnt(autoListInfo, tmsUserSession));
        return this.autoListMapper.selectAutoListInfo(pg, autoListInfo, tmsUserSession);
    }

    @Override
    public int totalCnt(AutoListInfo autoListInfo, TmsUserSession tmsUserSession) {
        return this.autoListMapper.totalCnt(autoListInfo, tmsUserSession);
    }

    @Override
    public String updateAutoUseYn(AutoListInfo autoInfo) {
        int successFlag = 0;
        String updateResult = "";
        successFlag = this.updateAutoChnYn(autoInfo);
        if (successFlag > 0) {
            successFlag = this.updateAutoMsgYn(autoInfo);
        }
        updateResult = successFlag > 0 ? "updateSuccess" : "updateFail";
        return updateResult;
    }

    @Override
    public int updateAutoMsgYn(AutoListInfo autoInfo) {
        return this.autoListMapper.updateAutoChnYn(autoInfo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public int updateAutoChnYn(AutoListInfo autoInfo) {
        if (this.autoListMapper.updateAutoMsgYn(autoInfo) > 0 && this.autoListMapper.updateAutoChnYn(autoInfo) > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public List<AutoSchdlInfo> selectAutoScheList(AutoListInfo autoListInfo, PageInfo pageInfo) {
        autoListInfo.calculateDate();
        pageInfo.calculate(this.autoListMapper.selectAutoScheListCnt(autoListInfo));
        return this.autoListMapper.selectAutoScheList(autoListInfo, pageInfo);
    }

    @Override
    public List<AutoListInfo> mailTypeList() {
        return this.autoListMapper.mailTypeList();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteAutoMsg(Map<String, String> param) {
        AutoListInfo info = new AutoListInfo();
        info.setUseYn("N");
        info.setMsgType(param.get("msgType"));
        info.setMsgTypeSeq(param.get("msgTypeSeq"));
        if (this.autoListMapper.deleteAutoMsg(param) <= 0) {
            throw new RuntimeException("delete auto msg error");
        }
        if (this.autoListMapper.updateAutoMsgYn(info) <= 0) {
            throw new RuntimeException("delete auto msg error");
        }
        if (this.autoListMapper.updateAutoChnYn(info) <= 0) {
            throw new RuntimeException("delete auto msg error");
        }
    }

    @Override
    public AutoPreviewInfo targetAutopreView(AutoListInfo autoListInfo) {
        return this.autoListMapper.targetAutopreView(autoListInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public AutoPreviewInfo getPreviewContent(String msgType, String msgTypeSeq) {
        AutoPreviewInfo autoPreviewInfo = new AutoPreviewInfo();
        autoPreviewInfo.setMSG_TYPE(msgType);
        autoPreviewInfo.setMSG_TYPE_SEQ(msgTypeSeq);
        return this.autoListMapper.targetAutopreViewPush(autoPreviewInfo);
    }

    @Override
    public void downloadXLS(HttpServletResponse response, AutoListInfo autoListInfo, TmsUserSession tmsUserSession, PeriodInfo periodInfo) {
        String title = "Auto Campaign";
        if (autoListInfo.getChannelType().equals("EM")) {
            title = "Auto Mail Campaign";
        } else if (autoListInfo.getChannelType().equals("SM")) {
            title = "Auto SMS Campaign";
        } else if (autoListInfo.getChannelType().equals("PU")) {
            title = "Auto Push Campaign";
        } else if (autoListInfo.getChannelType().equals("KA")) {
            title = "Auto Kakao Campaign";
        }
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("Message Name");
        columnList.add("Channel");
        columnList.add("Use");
        columnList.add("Code Name");
        columnList.add("SchCnt");
        columnList.add("Cnt");
        columnList.add("mailType");
        columnList.add("Total");
        columnList.add("Success");
        columnList.add("Open");
        ArrayList<String> columnListMsg = new ArrayList<String>();
        columnListMsg.add("Message Name");
        columnListMsg.add("Channel");
        columnListMsg.add("Dates");
        columnListMsg.add("Seq No");
        columnListMsg.add("Total");
        columnListMsg.add("Success");
        columnListMsg.add("Open");
        columnListMsg.add("Click");
        columnListMsg.add("Fail");
        columnListMsg.add("SwitchedSuccess");
        columnListMsg.add("SwitchedFail");
        List<AutoListInfo> dataList = this.autoListMapper.selectAutoListInfo(null, autoListInfo, tmsUserSession);
        List<AutoSchdlInfo> dataListMsg = this.autoListMapper.selectAutoScheList(autoListInfo, null);
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet[] worksheet = new XSSFSheet[]{workbook.createSheet("Campaign"), workbook.createSheet("Message")};
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet[0], startRowIndex, startColIndex, title, columnList, periodInfo);
        Layouter.buildReport(worksheet[1], startRowIndex, startColIndex, title, columnListMsg, periodInfo);
        FillManagerAutoCamp.fillReport(worksheet[0], startRowIndex, startColIndex, dataList);
        FillManagerAutoCamp.fillReportMsg(worksheet[1], startRowIndex, startColIndex, dataListMsg);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }

    @Override
    public void deleteAutoSchdl(String workDay, String seqNo) {
        this.autoListMapper.deleteAutoSchdl(workDay, seqNo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public AutoSendListInfo getAutoTempInfo(AutoSendListInfo autoSendListInfo) {
        return this.autoListMapper.getAutoTempInfo(autoSendListInfo);
    }

    @Override
    public String getAutoTemplate(AutoSendListInfo autoSendListInfo, AutoSendListInfo autoTempInfo) {
        String result = "\uc81c\uc791\ubb3c\uc744 \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4!";
        if (autoSendListInfo != null) {
            String[] sIps;
            String sContentsActor = MessageUtil.getMessage((String)"preview.info.actor");
            String sSenderIp = "";
            String channelType = autoSendListInfo.getChannelType();
            InfoBeans sContent = new InfoBeans();
            Properties prop = new Properties();
            if (ChannelType.EMAIL.same(channelType)) {
                sSenderIp = MessageUtil.getMessage((String)"preview.mail.ip");
                prop.setProperty("TMS_M_EMAIL", autoTempInfo.getTMS_M_EMAIL());
            } else if (ChannelType.SMS.same(channelType)) {
                sSenderIp = MessageUtil.getMessage((String)"preview.sms.ip");
                prop.setProperty("TMS_M_PHONE", autoTempInfo.getTMS_M_PHONE());
            } else if (ChannelType.PUSH.same(channelType)) {
                sSenderIp = MessageUtil.getMessage((String)"preview.push.ip");
                prop.setProperty("TMS_M_TOKEN", autoTempInfo.getTMS_M_TOKEN());
            } else if (ChannelType.KAKAO.same(channelType)) {
                sSenderIp = MessageUtil.getMessage((String)"preview.kakao.ip");
                if (StringUtils.isNotEmpty((CharSequence)autoTempInfo.getTMS_M_PHONE())) {
                    prop.setProperty("TMS_M_PHONE", autoTempInfo.getTMS_M_PHONE());
                }
            }
            prop.setProperty("WORKDAY", autoSendListInfo.getWorkDay());
            prop.setProperty("SEQNO", autoSendListInfo.getSeqNo());
            prop.setProperty("POST_ID", autoSendListInfo.getWorkDay() + "_" + autoSendListInfo.getSeqNo());
            prop.setProperty("MEMBER_ID", autoTempInfo.getMemberId());
            prop.setProperty("MEMBER_ID_SEQ", autoTempInfo.getMemberIdSeq());
            prop.setProperty("MEMBER_NAME", autoTempInfo.getMemberName() == null ? "" : autoTempInfo.getMemberName());
            prop.setProperty("MAPPING", autoTempInfo.getMapping());
            sContent.setArgs(prop);
            sContent.setHandler(sContentsActor);
            for (String sIp : sIps = sSenderIp.split(",")) {
                String[] sIpsTemp = sIp.split("#");
                if (!sIpsTemp[0].equals(StringUtils.validString((String)autoTempInfo.getServerId()))) continue;
                String[] ipPort = sIpsTemp[1].split(":");
                sContent.setServerIP(ipPort[0]);
                sContent.setServerPORT(Integer.parseInt(ipPort[1]));
                break;
            }
            InfoComunicator cmtr = new InfoComunicator();
            cmtr.setInfoBeans(sContent);
            try {
                sContent = cmtr.execute();
                String memberContent = sContent.getProperty("CONTENTS");
                result = BASE64.decode((byte[])memberContent.getBytes("UTF-8"), (String)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public AutoMsgChnInfo getAutoMsgChnInfo(AutoSendListInfo autoSendListInfo) {
        return this.autoListMapper.getAutoMsgChnInfo(autoSendListInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<AutoSendListInfo> randomTargetList(AutoSendListInfo autoSendListInfo) {
        return this.autoListMapper.randomTargetList(autoSendListInfo);
    }

    @Override
    public void deleteAutoMsgChnFromSiteDel(SiteInfo siteInfo) {
        this.autoListMapper.deleteAutoMsgFromSiteDel(siteInfo);
        this.autoListMapper.deleteAutoChnFromSiteDel(siteInfo);
    }

    @Override
    @ConvertTarget
    @DecryptAndMasking
    public List<AutoSendListInfo> previewSearchTargetList(AutoSendListInfo autoSendListInfo, PageInfo pageInfo) {
        pageInfo.calculate(this.autoListMapper.searchPreviewTargetListCnt(autoSendListInfo));
        return this.autoListMapper.searchPreviewTargetList(autoSendListInfo, pageInfo);
    }
}

