/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.automation;

import com.humuson.tms.common.util.FileExtentionUtil;
import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.mapper.automation.AutoAttachMapper;
import com.humuson.tms.model.automation.TmsAutoMsgInfoAttach;
import com.humuson.tms.service.automation.AutoAttachService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AutoAttachServiceImpl
implements AutoAttachService {
    private static final Logger log = LoggerFactory.getLogger(AutoAttachServiceImpl.class);
    @Value(value="${attach.path}")
    private String attachPath;
    @Value(value="${attach.url}")
    private String attachUrl;
    @Autowired
    private AutoAttachMapper autoAttachMapper;

    @Override
    public List<TmsAutoMsgInfoAttach> selectAttachFileList(String msgType, String msgTypeSeq) {
        return this.selectAttachFileList(msgType, msgTypeSeq, null);
    }

    @Override
    public List<TmsAutoMsgInfoAttach> selectAttachFileList(String msgType, String msgTypeSeq, String attachType) {
        TmsAutoMsgInfoAttach tmsAutoMsgInfoAttach = new TmsAutoMsgInfoAttach();
        tmsAutoMsgInfoAttach.setMsgType(msgType);
        tmsAutoMsgInfoAttach.setMsgTypeSeq(msgTypeSeq);
        tmsAutoMsgInfoAttach.setAttachType(attachType);
        return this.autoAttachMapper.selectAttachFileList(tmsAutoMsgInfoAttach);
    }

    @Override
    public int updateAttachFileType(TmsAutoMsgInfoAttach tmsAutoMsgInfoAttach) {
        return this.autoAttachMapper.updateAttachFileType(tmsAutoMsgInfoAttach);
    }

    @Override
    public int deleteAttachFile(TmsAutoMsgInfoAttach tmsAutoMsgInfoAttach) {
        return this.autoAttachMapper.deleteAttachFile(tmsAutoMsgInfoAttach);
    }

    @Override
    public int uploadAttachFile(TmsAutoMsgInfoAttach tmsAutoMsgInfoAttach) throws Exception {
        MultipartFile file = tmsAutoMsgInfoAttach.getAttachFile();
        String fileName = file.getOriginalFilename();
        String channelType = tmsAutoMsgInfoAttach.getChannelType();
        if (channelType.equals("EM") && !FileExtentionUtil.isValidExtention((String)fileName)) {
            return -1;
        }
        if ((channelType.equals("SM") || channelType.equals("KA")) && !FileExtentionUtil.isImageFileExtention((String)fileName)) {
            return -1;
        }
        if (channelType.equals("KA")) {
            BufferedImage image = ImageIO.read(file.getInputStream());
            double width = image.getWidth();
            if (width < 500.0) {
                return -103;
            }
            double height = image.getHeight();
            double a = width / height;
            if (a < 0.5 || a > 1.34) {
                return -102;
            }
        }
        tmsAutoMsgInfoAttach.setAttachType("A");
        tmsAutoMsgInfoAttach.setAttachCharset("UTF-8");
        tmsAutoMsgInfoAttach.setContentName(fileName);
        List<TmsAutoMsgInfoAttach> attachInfoList = this.autoAttachMapper.selectAttachFileList(tmsAutoMsgInfoAttach);
        log.info("attachInfoList size : {}", (Object)attachInfoList.size());
        if (attachInfoList.size() > 0) {
            log.info("attachInfoList size > 0");
            TmsAutoMsgInfoAttach attachInfo = attachInfoList.get(0);
            String attachName = attachInfo.getContentPath();
            File existFile = new File(attachName);
            existFile.delete();
        }
        String path = this.attachPath;
        try {
            String newFileName = FileUtil.upload((InputStream)file.getInputStream(), (String)fileName, (String)(path + "/"));
            tmsAutoMsgInfoAttach.setFileId(newFileName);
            tmsAutoMsgInfoAttach.setContentPath(path + "/" + newFileName);
            tmsAutoMsgInfoAttach.setContentUrl(this.attachUrl + "/" + newFileName);
        }
        catch (IOException ie) {
            log.error("File writing error : {}", (Throwable)ie);
        }
        log.info("File upload success!");
        return this.autoAttachMapper.insertAttachFileInfo(tmsAutoMsgInfoAttach);
    }
}

