/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl.account;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mapper.account.PwdMgrMapper;
import com.humuson.tms.service.account.PwdMgrService;
import com.humuson.tms.service.security.Sha512PasswordEncoder;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PwdMgrServiceImpl
implements PwdMgrService {
    @Autowired
    PwdMgrMapper pwdMgrMapper;
    @Autowired
    Sha512PasswordEncoder encoder;

    @Override
    public boolean checkPwd(String userId, String userPwd) {
        String encryptedPwd = this.pwdMgrMapper.getPassword(userId);
        return this.encoder.matches(StringUtils.validString((String)userPwd), encryptedPwd);
    }

    @Override
    public int modifyPwd(String userId, String userNewPwd) {
        Sha512PasswordEncoder encoder = new Sha512PasswordEncoder();
        String encryptedNewPwd = encoder.encode(StringUtils.validString((String)userNewPwd));
        HashMap<String, String> sqlParams = new HashMap<String, String>();
        sqlParams.put("userId", userId);
        sqlParams.put("userNewPwd", encryptedNewPwd);
        int result = this.pwdMgrMapper.modifyPwd(sqlParams);
        return result;
    }
}

