/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl;

import com.humuson.tms.mapper.AnalyticsUserApiMapper;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.analytics.AnalyticsUserApiInfo;
import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.service.api.AnalyticsUserApiService;
import com.humuson.tms.service.excel.FillManagerUser;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsUserApiServiceImpl
implements AnalyticsUserApiService {
    @Autowired
    AnalyticsUserApiMapper analyticsUserApiMapper;

    @Override
    public List<AnalyticsUserApiInfo> selectTotal(int appGrpId, PeriodInfo periodInfo, PageInfo pageInfo) {
        return this.analyticsUserApiMapper.selectTotal(appGrpId, periodInfo, pageInfo);
    }

    @Override
    public List<AnalyticsUserApiInfo> selectList(int appGrpId, PeriodInfo periodInfo, PageInfo pageInfo) {
        return this.analyticsUserApiMapper.selectList(appGrpId, periodInfo, pageInfo);
    }

    @Override
    public void downloadXLS(HttpServletResponse response, int appGrpId, PeriodInfo periodInfo) {
        String title = "User";
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("Dates");
        columnList.add("Unique User");
        columnList.add("New User");
        columnList.add("Retained User");
        List<AnalyticsUserApiInfo> dataList = this.selectList(appGrpId, periodInfo, new PageInfo());
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet worksheet = workbook.createSheet(title);
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet, startRowIndex, startColIndex, title, columnList, periodInfo);
        FillManagerUser.fillReport(worksheet, startRowIndex, startColIndex, dataList);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }

    @Override
    public List<EntityMap> selectAppGrpList(int siteId) {
        return this.analyticsUserApiMapper.selectAppGrpList(siteId);
    }
}

