/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.model.PeriodInfo;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Layouter {
    Logger logger = LoggerFactory.getLogger(Layouter.class);

    public static void buildReport(XSSFSheet worksheet, int startRowIndex, int startColIndex, String title, List<String> columnList, String workday) {
        int listCount = columnList.size();
        for (int i = 0; i < listCount; ++i) {
            worksheet.setColumnWidth(i, 5000);
        }
        Layouter.buildTitle(worksheet, startRowIndex, startColIndex, title, workday);
        Layouter.buildHeaders(worksheet, startRowIndex, startColIndex, columnList);
    }

    public static void buildTitle(XSSFSheet worksheet, int startRowIndex, int startColIndex, String title, String workday) {
        XSSFFont fontTitle = worksheet.getWorkbook().createFont();
        fontTitle.setBoldweight((short)700);
        fontTitle.setFontHeight((short)280);
        XSSFCellStyle cellStyleTitle = worksheet.getWorkbook().createCellStyle();
        cellStyleTitle.setAlignment((short)2);
        cellStyleTitle.setWrapText(true);
        cellStyleTitle.setFont((Font)fontTitle);
        XSSFRow rowTitle = worksheet.createRow((int)((short)startRowIndex));
        rowTitle.setHeight((short)500);
        XSSFCell cellTitle = rowTitle.createCell(startColIndex);
        cellTitle.setCellValue(title);
        cellTitle.setCellStyle((CellStyle)cellStyleTitle);
        XSSFCell cellDueDate = rowTitle.createCell(startColIndex + 1);
        cellDueDate.setCellValue("( " + workday + " )");
        XSSFRow dateTitle = worksheet.createRow((short)startRowIndex + 1);
        XSSFCell cellDate = dateTitle.createCell(startColIndex);
        cellDate.setCellValue("This report was generated at " + new Date());
    }

    public static void buildReport(XSSFSheet worksheet, int startRowIndex, int startColIndex, String title, List<String> columnList, PeriodInfo periodInfo) {
        int listCount = columnList.size();
        for (int i = 0; i < listCount; ++i) {
            worksheet.setColumnWidth(i, 5000);
            if (i != 0) continue;
            worksheet.setColumnWidth(i, 10000);
        }
        Layouter.buildTitle(worksheet, startRowIndex, startColIndex, title, periodInfo);
        Layouter.buildHeaders(worksheet, startRowIndex, startColIndex, columnList);
    }

    public static void buildTitle(XSSFSheet worksheet, int startRowIndex, int startColIndex, String title, PeriodInfo periodInfo) {
        XSSFFont fontTitle = worksheet.getWorkbook().createFont();
        fontTitle.setBoldweight((short)700);
        fontTitle.setFontHeight((short)280);
        XSSFCellStyle cellStyleTitle = worksheet.getWorkbook().createCellStyle();
        cellStyleTitle.setAlignment((short)2);
        cellStyleTitle.setWrapText(true);
        cellStyleTitle.setFont((Font)fontTitle);
        XSSFRow rowTitle = worksheet.createRow((int)((short)startRowIndex));
        rowTitle.setHeight((short)500);
        XSSFCell cellTitle = rowTitle.createCell(startColIndex);
        cellTitle.setCellValue(title);
        cellTitle.setCellStyle((CellStyle)cellStyleTitle);
        if (periodInfo.getStartDate() != null) {
            XSSFCell cellDueDate = rowTitle.createCell(startColIndex + 1);
            cellDueDate.setCellValue("( " + periodInfo.getStartDate() + " ~ " + periodInfo.getEndDate() + " )");
        }
        XSSFRow dateTitle = worksheet.createRow((short)startRowIndex + 1);
        XSSFCell cellDate = dateTitle.createCell(startColIndex);
        cellDate.setCellValue("This report was generated at " + new Date());
    }

    public static void buildHeaders(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<String> columnList) {
        XSSFFont font = worksheet.getWorkbook().createFont();
        font.setBoldweight((short)700);
        XSSFCellStyle headerCellStyle = worksheet.getWorkbook().createCellStyle();
        headerCellStyle.setFillBackgroundColor((short)22);
        headerCellStyle.setFillPattern((short)2);
        headerCellStyle.setAlignment((short)2);
        headerCellStyle.setVerticalAlignment((short)1);
        headerCellStyle.setWrapText(true);
        headerCellStyle.setFont((Font)font);
        headerCellStyle.setBorderBottom((short)1);
        XSSFRow rowHeader = worksheet.createRow((short)startRowIndex + 2);
        rowHeader.setHeight((short)500);
        int listCount = columnList.size();
        for (int i = 0; i < listCount; ++i) {
            String columnName = columnList.get(i);
            XSSFCell cell = rowHeader.createCell(startColIndex + i);
            cell.setCellValue(columnName);
            cell.setCellStyle((CellStyle)headerCellStyle);
        }
    }
}

