/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.model.analytics.AnalyticsUserApiInfo;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerUser {
    private static final Logger log = LoggerFactory.getLogger(FillManagerUser.class);

    public static void fillReport(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<AnalyticsUserApiInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            AnalyticsUserApiInfo info = dataList.get(i - 2);
            XSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getWorkday().substring(0, 4) + "/" + info.getWorkday().substring(4, 6) + "/" + info.getWorkday().substring(6, 8));
            cell1.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell2 = row.createCell(startColIndex + 1);
            cell2.setCellValue(StringUtils.moneyForm((String)(info.getUqSessCnt() + "")));
            cell2.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(StringUtils.moneyForm((String)(info.getNewSessCnt() + "")));
            cell3.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(StringUtils.moneyForm((String)(info.getRtSessCnt() + "")));
            cell4.setCellStyle((CellStyle)bodyCellStyle);
            ++i;
        }
    }
}

