/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.common.util.StringUtils;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerStat {
    private static final Logger log = LoggerFactory.getLogger(FillManagerStat.class);

    public static void fillReport(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<List<String>> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            List<String> info = dataList.get(i - 2);
            for (int j = 0; j < info.size(); ++j) {
                String value = info.get(j);
                value = j == 0 ? value.substring(0, 4) + "/" + value.substring(4, 6) + "/" + value.substring(6, 8) : StringUtils.moneyForm((String)value);
                XSSFCell cell = row.createCell(startColIndex + j);
                cell.setCellValue(value);
                cell.setCellStyle((CellStyle)bodyCellStyle);
            }
            ++i;
        }
    }
}

