/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.model.site.user.SiteUserInfo;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerSiteUser {
    private static final Logger log = LoggerFactory.getLogger(FillManagerSiteUser.class);

    public static void fillReportSiteUser(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<SiteUserInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            SiteUserInfo info = dataList.get(i - 2);
            XSSFCell cell2 = row.createCell(startColIndex + 0);
            cell2.setCellValue(info.getRegDate());
            cell2.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell3 = row.createCell(startColIndex + 1);
            cell3.setCellValue(info.getCustId());
            cell3.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell4 = row.createCell(startColIndex + 2);
            cell4.setCellValue(info.getCustName());
            cell4.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell5 = row.createCell(startColIndex + 3);
            cell5.setCellValue(info.getCustEmail());
            cell5.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell6 = row.createCell(startColIndex + 4);
            cell6.setCellValue(info.getCustPhone());
            cell6.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell7 = row.createCell(startColIndex + 5);
            cell7.setCellValue(info.getOs());
            cell7.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell8 = row.createCell(startColIndex + 6);
            cell8.setCellValue(info.getAppVer());
            cell8.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell9 = row.createCell(startColIndex + 7);
            cell9.setCellValue(info.getDevice());
            cell9.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell10 = row.createCell(startColIndex + 8);
            cell10.setCellValue(info.getInactiveFlag());
            cell10.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell11 = row.createCell(startColIndex + 9);
            cell11.setCellValue(info.getMktEmailYn());
            cell11.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell12 = row.createCell(startColIndex + 10);
            cell12.setCellValue(info.getMktPushYn());
            cell12.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell13 = row.createCell(startColIndex + 11);
            cell13.setCellValue(info.getMktSmsYn());
            cell13.setCellStyle((CellStyle)bodyCellStyle);
            ++i;
        }
    }
}

