/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.model.MessageInfo;
import com.humuson.tms.model.SingleCampListInfo;
import com.humuson.tms.model.analytics.AnalyticsSendAmntInfo;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerSingleCamp {
    private static final Logger log = LoggerFactory.getLogger(FillManagerSingleCamp.class);

    public static void fillReport(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<SingleCampListInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            SingleCampListInfo info = dataList.get(i - 2);
            XSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getCampName());
            cell1.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell2 = row.createCell(startColIndex + 1);
            cell2.setCellValue(info.getRegDate());
            cell2.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(StringUtils.moneyForm((String)(info.getMailTotal() + "")));
            cell3.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(StringUtils.moneyForm((String)(info.getSmsTotal() + "")));
            cell4.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(StringUtils.moneyForm((String)(info.getPushTotal() + "")));
            cell5.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getAlimTalkTotal() + "")));
            cell6.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(StringUtils.moneyForm((String)(info.getFriendTalkTotal() + "")));
            cell7.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(StringUtils.moneyForm((String)(info.getPushedCnt() + "")));
            cell8.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell9 = row.createCell(startColIndex + 8);
            cell9.setCellValue(StringUtils.moneyForm((String)(info.getDeliveredCnt() + "")));
            cell9.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell10 = row.createCell(startColIndex + 9);
            cell10.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")));
            cell10.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell11 = row.createCell(startColIndex + 10);
            cell11.setCellValue(StringUtils.moneyForm((String)(info.getClickCnt() + "")));
            cell11.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell12 = row.createCell(startColIndex + 11);
            cell12.setCellValue(StringUtils.moneyForm((String)(info.getFailCnt() + "")));
            cell12.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell13 = row.createCell(startColIndex + 12);
            cell13.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedDeliveredCnt() + "")));
            cell13.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell14 = row.createCell(startColIndex + 13);
            cell14.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedFailCnt() + "")));
            cell14.setCellStyle((CellStyle)bodyCellStyle);
            ++i;
        }
    }

    public static void fillReportMsg(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<MessageInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            MessageInfo info = dataList.get(i - 2);
            XSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getCampName());
            cell1.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell2 = row.createCell(startColIndex + 1);
            cell2.setCellValue(info.getMsgName());
            cell2.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(info.getRegDate());
            cell3.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell4 = row.createCell(startColIndex + 3);
            if (info.getChannelType().equals("EM")) {
                cell4.setCellValue("Mail");
            } else if (info.getChannelType().equals("SM")) {
                cell4.setCellValue("SMS");
            } else if (info.getChannelType().equals("PU")) {
                cell4.setCellValue("Push");
            } else if (info.getChannelType().equals("KA")) {
                cell4.setCellValue(info.getKakaoType());
            } else {
                cell4.setCellValue(info.getChannelType());
            }
            cell4.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(info.getJobStatusName());
            cell5.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getPushedCnt() + "")));
            cell6.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(StringUtils.moneyForm((String)(info.getDeliveredCnt() + "")) + " (" + info.getDeliveredRate() + "%)");
            cell7.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")) + " (" + info.getOpenRate() + "%)");
            cell8.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell9 = row.createCell(startColIndex + 8);
            cell9.setCellValue(StringUtils.moneyForm((String)(info.getClickCnt() + "")) + " (" + info.getClickRate() + "%)");
            cell9.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell10 = row.createCell(startColIndex + 9);
            cell10.setCellValue(StringUtils.moneyForm((String)(info.getFailCnt() + "")) + " (" + info.getFailRate() + "%)");
            cell10.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell11 = row.createCell(startColIndex + 10);
            cell11.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedDeliveredCnt() + "")) + " (" + info.getSwitchedDeliveredRate() + "%)");
            cell11.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell12 = row.createCell(startColIndex + 11);
            cell12.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedFailCnt() + "")) + " (" + info.getSwitchedFailRate() + "%)");
            cell12.setCellStyle((CellStyle)bodyCellStyle);
            ++i;
        }
    }

    public static void fillReportAnalytics(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<AnalyticsSendAmntInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            AnalyticsSendAmntInfo info = dataList.get(i - 2);
            XSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getGubun());
            cell1.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell2 = row.createCell(startColIndex + 1);
            cell2.setCellValue((double)info.getMsgCnt());
            cell2.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(StringUtils.moneyForm((String)(info.getPushedCnt() + "")));
            cell3.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(StringUtils.moneyForm((String)(info.getDeliveredCnt() + "")) + " (" + info.getDeliveredRate() + "%)");
            cell4.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(StringUtils.moneyForm((String)(info.getFailCnt() + "")) + " (" + info.getFailRate() + "%)");
            cell5.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")) + " (" + info.getOpenRate() + "%)");
            cell6.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(StringUtils.moneyForm((String)(info.getClickCnt() + "")) + " (" + info.getClickRate() + "%)");
            cell7.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(info.getClickRatePerOpen() + "%");
            cell8.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell9 = row.createCell(startColIndex + 8);
            cell9.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedDeliveredCnt() + "")) + " (" + info.getSwitchedDeliveredRate() + "%)");
            cell9.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell10 = row.createCell(startColIndex + 9);
            cell10.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedFailCnt() + "")) + " (" + info.getSwitchedFailRate() + "%)");
            cell10.setCellStyle((CellStyle)bodyCellStyle);
            ++i;
        }
    }
}

