/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.constrants.SendResultType;
import com.humuson.tms.model.SendResultInfo;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerSendResult {
    private static final Logger log = LoggerFactory.getLogger(FillManagerSendResult.class);
    private static final String SEND_TIME = "sendTime";
    private static final String MEMBER_ID = "memberId";
    private static final String MEMBER_NAME = "memberName";
    private static final String DEVICE = "device";
    private static final String MOBILE_TYPE = "mobileType";
    private static final String MEMBER_EMAIL = "memberEmail";
    private static final String MEMBER_PHONE = "memberPhone";
    private static final String MEMBER_TOKEN = "memberToken";
    private static final String READ_CLICK_CNT = "readClickCnt";
    private static final String READ_CLICK_TIME = "readClickTime";
    private static final String ERROR_CODE = "errorCode";
    private static final String ERROR_NAME = "errorName";
    private static final String SWITCHED_ERROR_CODE = "switchedErrorCode";
    private static final String DELIVERE_TIME = "deliverTime";
    private static final String CODE_NAME = "codeName";

    public static void fillReportSendResult(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<SendResultInfo> dataList, Map<String, String> columnListInfo, String mode) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFCell cell;
            XSSFRow row = worksheet.createRow((short)i + 1);
            SendResultInfo info = dataList.get(i - 2);
            int index = 0;
            if (Boolean.valueOf(columnListInfo.get(SEND_TIME)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getSendTime());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(MEMBER_ID)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberId());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(MEMBER_NAME)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberName());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(DEVICE)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getDevice());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(MOBILE_TYPE)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMobileType());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(MEMBER_EMAIL)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberEmail());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(MEMBER_PHONE)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberPhone());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(MEMBER_TOKEN)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getMemberToken());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(READ_CLICK_CNT)).equals(false)) {
                if (mode.equals(SendResultType.READ.getCode())) {
                    cell = row.createCell(startColIndex + index);
                    cell.setCellValue(info.getOpenCnt());
                    cell.setCellStyle((CellStyle)bodyCellStyle);
                    ++index;
                }
                if (mode.equals(SendResultType.CLICK.getCode())) {
                    cell = row.createCell(startColIndex + index);
                    cell.setCellValue(info.getClickCnt());
                    cell.setCellStyle((CellStyle)bodyCellStyle);
                    ++index;
                }
            }
            if (Boolean.valueOf(columnListInfo.get(READ_CLICK_TIME)).equals(false)) {
                if (mode.equals(SendResultType.READ.getCode())) {
                    cell = row.createCell(startColIndex + index);
                    cell.setCellValue(info.getOpenTime());
                    cell.setCellStyle((CellStyle)bodyCellStyle);
                    ++index;
                }
                if (mode.equals(SendResultType.CLICK.getCode())) {
                    cell = row.createCell(startColIndex + index);
                    cell.setCellValue(info.getClickTime());
                    cell.setCellStyle((CellStyle)bodyCellStyle);
                    ++index;
                }
            }
            if (Boolean.valueOf(columnListInfo.get(SWITCHED_ERROR_CODE)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getSwitchedErrorCode());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(ERROR_CODE)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getErrorCode());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(ERROR_NAME)).equals(false)) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getCodeName());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(CODE_NAME)).equals(false) && mode.equals(SendResultType.SWITCHED.getCode())) {
                System.out.println("SWITCHED false");
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getCodeName());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            if (Boolean.valueOf(columnListInfo.get(DELIVERE_TIME)).equals(false) && mode.equals(SendResultType.SWITCHED.getCode())) {
                cell = row.createCell(startColIndex + index);
                cell.setCellValue(info.getDeliverTime());
                cell.setCellStyle((CellStyle)bodyCellStyle);
                ++index;
            }
            ++i;
        }
    }
}

