/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.excel;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.model.analytics.AnalyticsAutoSchdlInfo;
import com.humuson.tms.model.vo.AutoListInfo;
import com.humuson.tms.model.vo.AutoSchdlInfo;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FillManagerAutoCamp {
    private static final Logger log = LoggerFactory.getLogger(FillManagerAutoCamp.class);

    public static void fillReport(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<AutoListInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            AutoListInfo info = dataList.get(i - 2);
            XSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getMsgName());
            cell1.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell2 = row.createCell(startColIndex + 1);
            if (info.getChannelType().equals("EM")) {
                cell2.setCellValue("Mail");
            } else if (info.getChannelType().equals("SM")) {
                cell2.setCellValue("SMS");
            } else if (info.getChannelType().equals("PU")) {
                cell2.setCellValue("Push");
            } else {
                cell2.setCellValue(info.getChannelType());
            }
            cell2.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(info.getUseYn());
            cell3.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(info.getCodeName());
            cell4.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(StringUtils.moneyForm((String)(info.getSchCnt() + "")));
            cell5.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getCnt() + "")));
            cell6.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(info.getMailType());
            cell7.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(StringUtils.moneyForm((String)(info.getPushedCnt() + "")));
            cell8.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell9 = row.createCell(startColIndex + 8);
            cell9.setCellValue(StringUtils.moneyForm((String)(info.getSuccessCnt() + "")));
            cell9.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell10 = row.createCell(startColIndex + 9);
            cell10.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")));
            cell10.setCellStyle((CellStyle)bodyCellStyle);
            ++i;
        }
    }

    public static void fillReportMsg(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<AutoSchdlInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            AutoSchdlInfo info = dataList.get(i - 2);
            XSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getMsgName());
            cell1.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell2 = row.createCell(startColIndex + 1);
            if (info.getChannelType().equals("EM")) {
                cell2.setCellValue("Mail");
            } else if (info.getChannelType().equals("SM")) {
                cell2.setCellValue("SMS");
            } else if (info.getChannelType().equals("PU")) {
                cell2.setCellValue("Push");
            } else {
                cell2.setCellValue(info.getChannelType());
            }
            cell2.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(info.getWorkDay());
            cell3.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(info.getSeqNo());
            cell4.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(StringUtils.moneyForm((String)(info.getTargetCnt() + "")));
            cell5.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getDeliveredCnt() + "")) + " (" + info.getDeliveredRate() + "%)");
            cell6.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")) + " (" + info.getOpenRate() + "%)");
            cell7.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(StringUtils.moneyForm((String)(info.getClickCnt() + "")) + " (" + info.getClickRate() + "%)");
            cell8.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell9 = row.createCell(startColIndex + 8);
            cell9.setCellValue(StringUtils.moneyForm((String)(info.getFailCnt() + "")) + " (" + info.getFailRate() + "%)");
            cell9.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell10 = row.createCell(startColIndex + 9);
            cell10.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedCnt() + "")) + " (" + info.getSwitchedDeliveredRate() + "%)");
            cell10.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell11 = row.createCell(startColIndex + 10);
            cell11.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedFailedCnt() + "")) + " (" + info.getSwitchedFailedRate() + "%)");
            cell11.setCellStyle((CellStyle)bodyCellStyle);
            ++i;
        }
    }

    public static void fillReportSchdl(XSSFSheet worksheet, int startRowIndex, int startColIndex, List<AnalyticsAutoSchdlInfo> dataList) {
        log.debug("Excel download : {}", (Object)dataList.toString());
        XSSFCellStyle bodyCellStyle = worksheet.getWorkbook().createCellStyle();
        bodyCellStyle.setAlignment((short)2);
        bodyCellStyle.setWrapText(true);
        int i = startRowIndex += 2;
        while (i + startRowIndex - 2 < dataList.size() + 2) {
            XSSFRow row = worksheet.createRow((short)i + 1);
            AnalyticsAutoSchdlInfo info = dataList.get(i - 2);
            XSSFCell cell1 = row.createCell(startColIndex + 0);
            cell1.setCellValue(info.getMsgName());
            cell1.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell2 = row.createCell(startColIndex + 1);
            if (info.getChannelType().equals("EM")) {
                cell2.setCellValue("Mail");
            } else if (info.getChannelType().equals("SM")) {
                cell2.setCellValue("SMS");
            } else if (info.getChannelType().equals("PU")) {
                cell2.setCellValue("Push");
            } else if (info.getChannelType().equals("KA")) {
                cell2.setCellValue(info.getKakaoType());
            } else {
                cell2.setCellValue(info.getChannelType());
            }
            cell2.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell3 = row.createCell(startColIndex + 2);
            cell3.setCellValue(info.getWorkDay());
            cell3.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell4 = row.createCell(startColIndex + 3);
            cell4.setCellValue(info.getSeqNo());
            cell4.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell5 = row.createCell(startColIndex + 4);
            cell5.setCellValue(StringUtils.moneyForm((String)(info.getTargetCnt() + "")));
            cell5.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell6 = row.createCell(startColIndex + 5);
            cell6.setCellValue(StringUtils.moneyForm((String)(info.getDeliveredCnt() + "")) + " (" + info.getDeliveredRate() + "%)");
            cell6.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell7 = row.createCell(startColIndex + 6);
            cell7.setCellValue(StringUtils.moneyForm((String)(info.getOpenCnt() + "")) + " (" + info.getOpenRate() + "%)");
            cell7.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell8 = row.createCell(startColIndex + 7);
            cell8.setCellValue(StringUtils.moneyForm((String)(info.getClickCnt() + "")) + " (" + info.getClickRate() + "%)");
            cell8.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell9 = row.createCell(startColIndex + 8);
            cell9.setCellValue(StringUtils.moneyForm((String)(info.getFailCnt() + "")) + " (" + info.getFailRate() + "%)");
            cell9.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell10 = row.createCell(startColIndex + 9);
            cell10.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedDeliveredCnt() + "")) + " (" + info.getSwitchedDeliveredRate() + "%)");
            cell10.setCellStyle((CellStyle)bodyCellStyle);
            XSSFCell cell11 = row.createCell(startColIndex + 10);
            cell11.setCellValue(StringUtils.moneyForm((String)(info.getSwitchedFailCnt() + "")) + " (" + info.getSwitchedFailRate() + "%)");
            cell11.setCellStyle((CellStyle)bodyCellStyle);
            ++i;
        }
    }
}

