/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.api;

import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.analytics.BaseAnalyticsApiInfo;
import com.humuson.tms.model.vo.EntityMap;
import com.humuson.tms.service.api.BaseAnalyticsApiService;
import com.humuson.tms.service.excel.FillManagerStat;
import com.humuson.tms.service.excel.Layouter;
import com.humuson.tms.service.excel.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsApiService
extends BaseAnalyticsApiService {
    @Override
    public List<BaseAnalyticsApiInfo> selectWorkdayTotalCnt(String dataType, int appGrpId, PeriodInfo periodInfo) {
        return this.analyticsApiMapper.selectWorkdayTotalCnt(dataType, appGrpId, periodInfo);
    }

    @Override
    public List<BaseAnalyticsApiInfo> selectStat(String dataId, int appGrpId, PeriodInfo periodInfo) {
        return this.analyticsApiMapper.selectStat(dataId, appGrpId, periodInfo);
    }

    @Override
    public List<BaseAnalyticsApiInfo> selectTop5(String dataType, int appGrpId, PeriodInfo periodInfo) {
        return this.analyticsApiMapper.selectTop5(dataType, appGrpId, periodInfo);
    }

    @Override
    public void downloadXLS(HttpServletResponse response, int appGrpId, String statType, PeriodInfo periodInfo) {
        String dataType = statType;
        List<BaseAnalyticsApiInfo> appVerTop5 = this.selectTop5(dataType, appGrpId, periodInfo);
        if (!appVerTop5.isEmpty()) {
            appVerTop5.get(0).setTop5Size(appVerTop5.size());
        }
        ArrayList<BaseAnalyticsApiInfo> resultList = new ArrayList<BaseAnalyticsApiInfo>();
        int workdayListSize = 0;
        String id = "";
        ArrayList<List<BaseAnalyticsApiInfo>> workdayAppVerStatList = new ArrayList<List<BaseAnalyticsApiInfo>>();
        for (int i = 0; i < appVerTop5.size(); ++i) {
            BaseAnalyticsApiInfo info = appVerTop5.get(i);
            id = Long.toString(info.getId());
            List<BaseAnalyticsApiInfo> list = this.selectStat(id, appGrpId, periodInfo);
            if (workdayListSize == 0) {
                workdayListSize = list.size();
            }
            workdayAppVerStatList.add(list);
        }
        ArrayList<BaseAnalyticsApiInfo> workdayStatList = new ArrayList<BaseAnalyticsApiInfo>(workdayListSize);
        for (int i = 0; i < workdayListSize; ++i) {
            BaseAnalyticsApiInfo info = new BaseAnalyticsApiInfo();
            ArrayList list = new ArrayList();
            String workday = null;
            for (int j = 0; j < workdayAppVerStatList.size(); ++j) {
                List workdayDeviceList = (List)workdayAppVerStatList.get(j);
                list.add(workdayDeviceList.get(i));
                if (workday != null) continue;
                workday = ((BaseAnalyticsApiInfo)workdayDeviceList.get(i)).getWorkday();
            }
            info.setStatList(list);
            info.setWorkday(workday);
            workdayStatList.add(0, info);
        }
        resultList.addAll(appVerTop5);
        resultList.addAll(workdayStatList);
        int top5Size = 0;
        ArrayList<String> headerList = new ArrayList<String>();
        ArrayList<List<String>> dailyListTotal = new ArrayList<List<String>>();
        headerList.add("Dates");
        for (int i = 0; i < resultList.size(); ++i) {
            if (i == 0) {
                top5Size = ((BaseAnalyticsApiInfo)resultList.get(i)).getTop5Size();
            }
            if (i < top5Size) {
                headerList.add(((BaseAnalyticsApiInfo)resultList.get(i)).getName());
                continue;
            }
            ArrayList<String> dailyList = new ArrayList<String>();
            dailyList.add(((BaseAnalyticsApiInfo)resultList.get(i)).getWorkday());
            for (int j = 0; j < ((BaseAnalyticsApiInfo)resultList.get(i)).getStatList().size(); ++j) {
                dailyList.add("" + ((BaseAnalyticsApiInfo)resultList.get(i)).getStatList().get(j).getCnt());
            }
            dailyListTotal.add(dailyList);
        }
        String title = statType;
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("Dates");
        for (int i = 0; i < appVerTop5.size(); ++i) {
            columnList.add(appVerTop5.get(i).getName());
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet worksheet = workbook.createSheet(title);
        int startRowIndex = 0;
        int startColIndex = 0;
        Layouter.buildReport(worksheet, startRowIndex, startColIndex, title, columnList, periodInfo);
        FillManagerStat.fillReport(worksheet, startRowIndex, startColIndex, dailyListTotal);
        String fileName = title + ".xls";
        response.setHeader("Content-Disposition", "inline; filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        Writer.write(response, worksheet);
    }

    public List<EntityMap> selectAppGrpList(int siteId) {
        return this.analyticsApiMapper.selectAppGrpList(siteId);
    }
}

