/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.model.vo;

import com.humuson.tms.common.util.ConvertUtils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;

public class EntityMap
extends LinkedHashMap<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(EntityMap.class);
    private static final long serialVersionUID = -1579736203670970476L;

    public EntityMap() {
    }

    public EntityMap(Map<String, Object> map) {
        this();
        this.putAll(map);
    }

    @Override
    public final Object put(String key, Object value) {
        if (key == null) {
            return super.put(key, value);
        }
        return super.put(key.toUpperCase(), value);
    }

    public final Object putResult(String key, Object value) {
        return super.put(key, value);
    }

    @Override
    public final void putAll(Map map) {
        if (map.size() == 0) {
            return;
        }
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = map instanceof EntityMap ? ((EntityMap)map).getResult(key) : map.get(key);
            super.put(key, value);
        }
    }

    public final Properties toProperties() {
        if (this.size() == 0) {
            return new Properties();
        }
        Properties prop = new Properties();
        Set keys = this.keySet();
        for (String key : keys) {
            Object value = this instanceof EntityMap ? this.getResult(key) : this.get(key);
            prop.put(key, value);
        }
        return prop;
    }

    @Override
    public final Object get(Object key) {
        if (key == null) {
            return super.get(key);
        }
        return super.get(((String)key).toUpperCase());
    }

    public final Object getResult(String key) {
        return super.get(key);
    }

    public Boolean getBoolean(String key) {
        if (this.get(key) instanceof Boolean) {
            return (Boolean)this.get(key);
        }
        return (Boolean)ConvertUtils.convertIfNecessary((Object)this.get(key), Boolean.class);
    }

    public Boolean[] getBooleanValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Boolean[])value;
        }
        return (Boolean[])ConvertUtils.convertIfNecessary((Object)this.get(key), Boolean[].class);
    }

    public Character getCharacter(String key) {
        if (this.get(key) instanceof Character) {
            return (Character)this.get(key);
        }
        return (Character)ConvertUtils.convertIfNecessary((Object)this.get(key), Character.class);
    }

    public Character[] getCharacterValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Character[])value;
        }
        return (Character[])ConvertUtils.convertIfNecessary((Object)this.get(key), Character[].class);
    }

    public Byte getByte(String key) {
        if (this.get(key) instanceof Byte) {
            return (Byte)this.get(key);
        }
        return (Byte)ConvertUtils.convertIfNecessary((Object)this.get(key), Byte.class);
    }

    public Byte[] getByteValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Byte[])value;
        }
        return (Byte[])ConvertUtils.convertIfNecessary((Object)this.get(key), Byte[].class);
    }

    public Short getShort(String key) {
        if (this.get(key) instanceof Short) {
            return (Short)this.get(key);
        }
        return (Short)ConvertUtils.convertIfNecessary((Object)this.get(key), Short.class);
    }

    public Short[] getShortValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Short[])value;
        }
        return (Short[])ConvertUtils.convertIfNecessary((Object)this.get(key), Short[].class);
    }

    public Integer getInt(String key) {
        if (this.get(key) instanceof Integer) {
            return (Integer)this.get(key);
        }
        return (Integer)ConvertUtils.convertIfNecessary((Object)this.get(key), Integer.class);
    }

    public Integer[] getIntValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Integer[])value;
        }
        return (Integer[])ConvertUtils.convertIfNecessary((Object)this.get(key), Integer[].class);
    }

    public Long getLong(String key) {
        if (this.get(key) instanceof Long) {
            return (Long)this.get(key);
        }
        return (Long)ConvertUtils.convertIfNecessary((Object)this.get(key), Long.class);
    }

    public Long[] getLongValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Long[])value;
        }
        return (Long[])ConvertUtils.convertIfNecessary((Object)this.get(key), Long[].class);
    }

    public Float getFloat(String key) {
        if (this.get(key) instanceof Float) {
            return (Float)this.get(key);
        }
        return (Float)ConvertUtils.convertIfNecessary((Object)this.get(key), Float.class);
    }

    public Float[] getFloatValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Float[])value;
        }
        return (Float[])ConvertUtils.convertIfNecessary((Object)this.get(key), Float[].class);
    }

    public Double getDouble(String key) {
        if (this.get(key) instanceof Double) {
            return (Double)this.get(key);
        }
        return (Double)ConvertUtils.convertIfNecessary((Object)this.get(key), Double.class);
    }

    public Double[] getDoubleValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Double[])value;
        }
        return (Double[])ConvertUtils.convertIfNecessary((Object)this.get(key), Double[].class);
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String[] getStringValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (String[])value;
        }
        return new String[]{(String)value};
    }

    public java.util.Date getDate(String key) {
        if (this.get(key) instanceof java.util.Date) {
            return (java.util.Date)this.get(key);
        }
        return (java.util.Date)ConvertUtils.convertIfNecessary((Object)this.get(key), java.util.Date.class);
    }

    public java.util.Date[] getDateValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (java.util.Date[])value;
        }
        return (java.util.Date[])ConvertUtils.convertIfNecessary((Object)this.get(key), java.util.Date[].class);
    }

    public Date getSqlDate(String key) {
        if (this.get(key) instanceof Date) {
            return (Date)this.get(key);
        }
        return (Date)ConvertUtils.convertIfNecessary((Object)this.get(key), Date.class);
    }

    public Date[] getSqlDateValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Date[])value;
        }
        return (Date[])ConvertUtils.convertIfNecessary((Object)this.get(key), Date[].class);
    }

    public Timestamp getTimestamp(String key) {
        if (this.get(key) instanceof Timestamp) {
            return (Timestamp)this.get(key);
        }
        return (Timestamp)ConvertUtils.convertIfNecessary((Object)this.get(key), Timestamp.class);
    }

    public Timestamp[] getTimestampValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Timestamp[])value;
        }
        return (Timestamp[])ConvertUtils.convertIfNecessary((Object)this.get(key), Timestamp[].class);
    }

    public Time getTime(String key) {
        if (this.get(key) instanceof Time) {
            return (Time)this.get(key);
        }
        return (Time)ConvertUtils.convertIfNecessary((Object)this.get(key), Time.class);
    }

    public Time[] getTimeValues(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return (Time[])value;
        }
        return (Time[])ConvertUtils.convertIfNecessary((Object)this.get(key), Time[].class);
    }

    public List<?> getList(String key) throws TypeMismatchException {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new TypeMismatchException(value, List.class);
    }

    public <T> List<T> getList(String key, Class<T> requiredType) throws TypeMismatchException {
        return this.getList(key);
    }

    public List<EntityMap> getEntityMapList(String key) throws TypeMismatchException {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new TypeMismatchException(value, List.class);
    }

    public Map<?, ?> getMap(String key) throws TypeMismatchException {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new TypeMismatchException(value, Map.class);
    }

    public <K, V> Map<K, V> getMap(String key, Class<K> requiredKeyType, Class<V> requiredValueType) throws TypeMismatchException {
        return this.getMap(key);
    }

    public EntityMap getEntityMap(String key) throws TypeMismatchException {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof EntityMap) {
            return (EntityMap)value;
        }
        throw new TypeMismatchException(value, EntityMap.class);
    }

    @Override
    public String toString() {
        try {
            return "EntityMap " + super.toString();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public void showMap() {
        for (Object key : this.keySet()) {
            log.info("key :{}", key);
        }
    }
}

