/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.exception.handler;

import com.humuson.tms.api.component.ApiResponseFormConverter;
import com.humuson.tms.exception.ApiResponseDataProvider;
import com.humuson.tms.model.api.ApiResponseForm;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.WebUtils;

public class ApiResponseExceptionHandler
implements HandlerExceptionResolver,
Ordered,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ApiResponseExceptionHandler.class);
    int order = Integer.MIN_VALUE;
    @Autowired
    private ApiResponseFormConverter apiResponseFormConverter;
    @Autowired
    private HttpMessageConverter<?>[] messageConverters = null;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        if (!(exception instanceof ApiResponseDataProvider)) {
            return null;
        }
        log.error("api response exception", (Throwable)exception);
        List<MediaType> acceptedMediaTypes = null;
        Class<?> bodyType = null;
        try {
            ApiResponseDataProvider e = (ApiResponseDataProvider)((Object)exception);
            this.setStatus(request, response, e.getApiStatus().getHttpStatus());
            acceptedMediaTypes = this.getMediaType(request);
            ApiResponseForm responseBody = this.apiResponseFormConverter.makeApiResponseForm(request, e);
            bodyType = responseBody.getClass();
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
                    if (!messageConverter.canWrite(bodyType, acceptedMediaType)) continue;
                    ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
                    messageConverter.write((Object)responseBody, acceptedMediaType, (HttpOutputMessage)outputMessage);
                    return new ModelAndView();
                }
            }
        }
        catch (Exception e) {
            log.error("create exception response error {}", (Throwable)e);
        }
        log.info("[AjaxResponseExceptionHandler resolveException method] Could not find HttpMessageConverter that supports return type {} and {}", bodyType, acceptedMediaTypes);
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messageConverters == null) {
            throw new IllegalArgumentException("messageConverters not found");
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setStatus(HttpServletRequest request, HttpServletResponse response, HttpStatus status) {
        if (!WebUtils.isIncludeRequest((ServletRequest)request)) {
            response.setStatus(status.value());
        }
    }

    public List<MediaType> getMediaType(HttpServletRequest request) {
        ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(request);
        List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
        if (acceptedMediaTypes.isEmpty()) {
            acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
        }
        MediaType.sortByQualityValue((List)acceptedMediaTypes);
        return acceptedMediaTypes;
    }
}

