/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.convert.handler;

import com.humuson.tms.config.TmsConfig;
import com.humuson.tms.convert.bind.Decrypt;
import com.humuson.tms.convert.handler.ConvertInfoHandler;
import com.humuson.tms.service.MemberFieldSecurityService;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StringDecryptHandler
implements ConvertInfoHandler<String, Decrypt> {
    private static final Logger log = LoggerFactory.getLogger(StringDecryptHandler.class);
    @Autowired
    TmsConfig tmsConfig;
    @Autowired
    MemberFieldSecurityService memberFieldSecurityService;

    @Override
    public Object convert(Decrypt annotation, String object, Collection<Annotation> annotations, Map<String, Object> context) {
        if (this.tmsConfig.isMemberFieldEncrypted()) {
            String decryptStr = null;
            try {
                decryptStr = this.memberFieldSecurityService.decrypt(object);
            }
            catch (Exception e) {
                log.error("string decrypt error - param : {}", (Object)object);
                decryptStr = object;
            }
            return decryptStr;
        }
        return object;
    }
}

