/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.convert.aop;

import com.humuson.tms.convert.ConvertInfoResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class ConvertTargetMethodProcessor {
    @Autowired
    ConvertInfoResolver resolver;

    @Around(value="@annotation(com.humuson.tms.convert.aop.ConvertTarget)")
    public Object aroundConvert(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            method = pjp.getTarget().getClass().getDeclaredMethod(signature.getName(), method.getParameterTypes());
        }
        Annotation[][] annotations = method.getParameterAnnotations();
        Object[] args = pjp.getArgs();
        for (int i = annotations.length - 1; i >= 0; --i) {
            args[i] = this.resolver.findConvertAnnotationsAndconvert(annotations[i], args[i]);
        }
        Object returnObj = pjp.proceed(args);
        return this.resolver.findConvertAnnotationsAndconvert(method.getDeclaredAnnotations(), returnObj);
    }
}

