/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.convert;

import com.humuson.tms.convert.bind.Convert;
import com.humuson.tms.convert.handler.ConvertInfoHandleCheckable;
import com.humuson.tms.convert.handler.ConvertInfoHandler;
import com.humuson.tms.convert.handler.ListConvertHandler;
import com.humuson.tms.convert.handler.MapConvertHandler;
import com.humuson.tms.convert.handler.ModelConvertHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConvertInfoResolver
implements InitializingBean {
    @Autowired(required=false)
    List<ConvertInfoHandler<?, ?>> convertInfoHandlerList;
    List<ConvertInfoHandler<?, ?>> checkableConvertInfoHandlerList = new ArrayList();
    Map<Integer, ConvertInfoHandler<?, ?>> handlerCache = new HashMap();
    Map<Integer, Class<? extends Annotation>> handlerAnnotationCache = new ConcurrentHashMap<Integer, Class<? extends Annotation>>();
    Map<Integer, List<Annotation>> containAnnotationCache = new ConcurrentHashMap<Integer, List<Annotation>>();
    Map<Integer, ModelConvertInfoDescriptor> modelDescriptorCache = new HashMap<Integer, ModelConvertInfoDescriptor>();
    MapConvertHandler mapConvertHandler = null;
    ModelConvertHandler modelConvertHandler = null;
    ListConvertHandler listConvertHandler = null;

    public void afterPropertiesSet() throws Exception {
        Class annoClz = null;
        Class objClz = null;
        for (ConvertInfoHandler<?, ?> handler : this.convertInfoHandlerList) {
            if (handler instanceof ConvertInfoHandleCheckable) {
                this.checkableConvertInfoHandlerList.add(handler);
                continue;
            }
            for (Type type : handler.getClass().getGenericInterfaces()) {
                ParameterizedType t;
                if (!(type instanceof ParameterizedType) || !(t = (ParameterizedType)type).getRawType().equals(ConvertInfoHandler.class)) continue;
                Type[] t2 = t.getActualTypeArguments();
                objClz = (Class)t2[0];
                annoClz = (Class)t2[1];
                break;
            }
            this.handlerAnnotationCache.put(this.getAnnotationHashCode(annoClz), annoClz);
            this.handlerCache.put(this.getHashCode(annoClz, objClz), handler);
        }
    }

    public int getHashCode(Class<? extends Annotation> annoClz, Class<?> clz) {
        return 31 * annoClz.getName().hashCode() + clz.getName().hashCode();
    }

    public ConvertInfoHandler<?, ?> getHandler(Annotation annotation, Object obj) {
        int hashCode = this.getHashCode(annotation.annotationType(), obj.getClass());
        ConvertInfoHandler<?, ?> handler = this.handlerCache.get(hashCode);
        if (handler != null) {
            return handler;
        }
        for (ConvertInfoHandler<?, ?> h : this.checkableConvertInfoHandlerList) {
            if (!((ConvertInfoHandleCheckable)((Object)h)).isHandlePossible(obj, annotation)) continue;
            return h;
        }
        return null;
    }

    private int getAnnotationHashCode(Class<? extends Annotation> clz) {
        return clz.getName().hashCode();
    }

    private void cacheContainAnnotation(Class<? extends Annotation> clz, List<Annotation> list) {
        this.containAnnotationCache.put(this.getAnnotationHashCode(clz), list);
    }

    private List<Annotation> getCachedContainAnnotation(Class<? extends Annotation> clz) {
        return this.containAnnotationCache.get(this.getAnnotationHashCode(clz));
    }

    public Collection<Annotation> findConvertInfoAnnotation(Annotation[] annotations) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        LinkedList<Annotation> annoList = new LinkedList<Annotation>();
        int hashCode = 0;
        for (Annotation anno : annotations) {
            hashCode = this.getAnnotationHashCode(anno.annotationType());
            if (hashSet.contains(hashCode) || !this.handlerAnnotationCache.containsKey(hashCode) && !this.isConvertInfoAnnotation(anno)) continue;
            hashSet.add(hashCode);
            annoList.add(anno);
            for (Annotation containAnno : this.getContainAnnotation(anno.annotationType())) {
                hashCode = this.getAnnotationHashCode(containAnno.annotationType());
                if (!this.handlerAnnotationCache.containsKey(hashCode) || hashSet.contains(hashCode)) continue;
                hashSet.add(hashCode);
                annoList.add(containAnno);
            }
        }
        return annoList;
    }

    private List<Annotation> getContainAnnotation(Class<? extends Annotation> clz) {
        List<Annotation> list = this.getCachedContainAnnotation(clz);
        if (list != null) {
            return list;
        }
        list = new LinkedList<Annotation>();
        int hashCode = 0;
        for (Annotation anno : clz.getDeclaredAnnotations()) {
            hashCode = this.getAnnotationHashCode(anno.annotationType());
            if (!this.handlerAnnotationCache.containsKey(hashCode)) continue;
            list.add(anno);
        }
        this.cacheContainAnnotation(clz, list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelConvertInfoDescriptor getModelDescriptor(Class<?> clz) {
        int hashCode = clz.getName().hashCode();
        ModelConvertInfoDescriptor descriptor = this.modelDescriptorCache.get(hashCode);
        if (descriptor == null) {
            Map<Integer, ModelConvertInfoDescriptor> map = this.modelDescriptorCache;
            synchronized (map) {
                if (this.modelDescriptorCache.get(hashCode) == null) {
                    descriptor = new ModelConvertInfoDescriptor(clz, this);
                    this.modelDescriptorCache.put(hashCode, descriptor);
                }
            }
        }
        return descriptor;
    }

    public boolean isConvertInfoAnnotation(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Convert.class);
    }

    public Object convert(Annotation annotation, Object target, Collection<Annotation> annotations, Map<String, Object> context) {
        if (target == null) {
            return null;
        }
        ConvertInfoHandler<?, ?> handler = this.getHandler(annotation, target);
        if (handler != null) {
            target = handler.convert(annotation, target, annotations, context);
        }
        return target;
    }

    public Object convertAll(Collection<Annotation> annotations, Object target) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (target == null) {
            return null;
        }
        ConvertInfoHandler<?, ?> handler = null;
        for (Annotation anno : annotations) {
            handler = this.getHandler(anno, target);
            if (handler == null) continue;
            target = handler.convert(anno, target, annotations, context);
        }
        return target;
    }

    public Object findConvertAnnotationsAndconvert(Annotation[] annotations, Object target) {
        return this.convertAll(this.findConvertInfoAnnotation(annotations), target);
    }

    public Collection<Annotation> getSameAnnotation(Collection<Annotation> l, Collection<Annotation> r) {
        LinkedList<Annotation> list = new LinkedList<Annotation>();
        for (Annotation a : l) {
            if (!r.contains(a)) continue;
            list.add(a);
        }
        return list;
    }

    public class ModelConvertInfoDescriptor {
        Class<?> thisClz;
        Map<Integer, List<Field>> annotationFieldList;

        public ModelConvertInfoDescriptor(Class<?> clz, ConvertInfoResolver resolver) {
            this.thisClz = clz;
            this.initAnnotationMap(clz, resolver);
        }

        public void initAnnotationMap(Class<?> clz, ConvertInfoResolver resolver) {
            this.annotationFieldList = new HashMap<Integer, List<Field>>();
            List<Field> fieldList = null;
            for (Field field : clz.getDeclaredFields()) {
                Collection<Annotation> annotations = resolver.findConvertInfoAnnotation(field.getAnnotations());
                if (annotations == null || annotations.size() == 0) continue;
                for (Annotation anno : annotations) {
                    fieldList = this.annotationFieldList.get(this.getAnnotationHashCode(anno));
                    if (fieldList == null) {
                        fieldList = new LinkedList<Field>();
                        this.annotationFieldList.put(this.getAnnotationHashCode(anno), fieldList);
                    }
                    fieldList.add(field);
                }
            }
        }

        public Integer getAnnotationHashCode(Annotation annotation) {
            return annotation.getClass().getName().hashCode();
        }

        public List<Field> getFieldByAnnotation(Annotation annotation) {
            return this.annotationFieldList.get(this.getAnnotationHashCode(annotation));
        }
    }
}

