/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.paging;

import java.util.List;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class PageImplWrapper<T>
extends PageImpl<T> {
    private static final long serialVersionUID = -3596082743567208010L;
    public static int maxPagingNumber = 10;
    Integer currentIndex;
    Integer beginIndex;
    Integer endIndex;
    Integer lastPageNumber;
    Integer prevPageNumber;
    Integer nextPageNumber;
    Integer baseRowNumber;

    public PageImplWrapper(List<T> content) {
        super(content);
    }

    public PageImplWrapper(List<T> content, int pageIndex, int pageSize, long total) {
        super(content, (Pageable)new PageRequest(pageIndex, pageSize, null), total);
    }

    public PageImplWrapper(List<T> content, Pageable pageable, long total) {
        super(content, pageable, total);
    }

    public static int getMaxPagingNumber() {
        return maxPagingNumber;
    }

    public static void setMaxPagingNumber(int maxPagingNumber) {
        PageImplWrapper.maxPagingNumber = maxPagingNumber;
    }

    public int getCurrentIndex() {
        return this.currentIndex != null ? this.currentIndex : this.getNumber() + 1;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public int getBeginIndex() {
        return this.beginIndex != null ? this.beginIndex : Math.max(1, this.getCurrentIndex() - PageImplWrapper.getMaxPagingNumber() / 2);
    }

    public void setBeginIndex(int beginIndex) {
        this.beginIndex = beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex != null ? this.endIndex : Math.min(this.getBeginIndex() + PageImplWrapper.getMaxPagingNumber() - 1, this.getTotalPages());
    }

    public Integer getLastPageNumber() {
        return this.lastPageNumber != null ? this.lastPageNumber.intValue() : this.getTotalPages();
    }

    public void setLastPageNumber(Integer lastPageNumber) {
        this.lastPageNumber = lastPageNumber;
    }

    public Integer getPrevPageNumber() {
        return this.prevPageNumber != null ? this.prevPageNumber : this.getCurrentIndex() - 1;
    }

    public void setPrevPageNumber(Integer prevPageNumber) {
        this.prevPageNumber = prevPageNumber;
    }

    public Integer getNextPageNumber() {
        return this.nextPageNumber != null ? this.nextPageNumber : this.getCurrentIndex() + 1;
    }

    public void setNextPageNumber(Integer nextPageNumber) {
        this.nextPageNumber = nextPageNumber;
    }

    public Integer getBaseRowNumber() {
        return this.baseRowNumber != null ? this.baseRowNumber : (int)(this.getTotalElements() - (long)this.getNumber() + (long)this.getSize());
    }

    public void setBaseRowNumber(Integer baseRowNumber) {
        this.baseRowNumber = baseRowNumber;
    }
}

