/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common;

import com.humuson.tms.model.SiteInfo;
import com.humuson.tms.model.vo.TmsUser;
import com.humuson.tms.model.vo.TmsUserSession;
import com.humuson.tms.service.SiteService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class TmsRequestInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TmsRequestInterceptor.class);
    @Autowired
    private SiteService siteService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        TmsUser tmsUser;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        log.info("URL load start [url:{}, method:{}, mode:{}]", new Object[]{request.getRequestURI(), request.getMethod(), request.getHeader("mode")});
        request.setAttribute("req.start.time", (Object)System.currentTimeMillis());
        if (authentication != null && authentication.getPrincipal() instanceof TmsUser && (tmsUser = (TmsUser)authentication.getPrincipal()) != null) {
            int siteId = tmsUser.getSiteId();
            List<SiteInfo> siteList = tmsUser.getSiteList();
            if (tmsUser.getSiteList() == null || tmsUser.getSiteList().isEmpty()) {
                siteList = this.siteService.selectSiteList(tmsUser.getUsername());
                tmsUser.setSiteList(siteList);
            }
            TmsUserSession tmsUserSession = new TmsUserSession(tmsUser);
            request.setAttribute("tmsUserSession", (Object)tmsUserSession);
            request.setAttribute("siteList", siteList);
            request.setAttribute("selectedSiteId", (Object)siteId);
            String emailFlag = "N";
            String pushFlag = "N";
            String smsFlag = "N";
            String kakaoFlag = "N";
            for (SiteInfo siteInfo : siteList) {
                if (siteInfo.getSiteId() != siteId) continue;
                emailFlag = siteInfo.getEmailFlag();
                pushFlag = siteInfo.getPushFlag();
                smsFlag = siteInfo.getSmsFlag();
                kakaoFlag = siteInfo.getKakaoFlag();
                tmsUser.setAmcSiteKey(siteInfo.getAmcSiteKey());
                tmsUser.setAmcWebKey(siteInfo.getAmcWebKey());
                request.setAttribute("emailFlag", (Object)emailFlag);
                request.setAttribute("pushFlag", (Object)pushFlag);
                request.setAttribute("smsFlag", (Object)smsFlag);
                request.setAttribute("kakaoFlag", (Object)kakaoFlag);
            }
            if (log.isDebugEnabled()) {
                log.info("TmsUser [id:{}, siteId:{}, siteSize:{}, email:{} push:{} sms:{} kakao:{}]", new Object[]{tmsUserSession.getRegId(), siteId, siteList.size(), emailFlag, pushFlag, smsFlag, kakaoFlag});
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null) {
            log.info("URL load completed [url :{}, method:{} mode:{}, error:{}]", new Object[]{request.getRequestURI(), request.getMethod(), request.getHeader("mode"), ex});
        } else {
            Long startTime = (Long)request.getAttribute("req.start.time");
            if (startTime != null) {
                long elapseTime = System.currentTimeMillis() - startTime;
                if (elapseTime > 2000L) {
                    log.warn("URL load completed [url :{}, method:{}, mode:{}, elapseTime:{}]", new Object[]{request.getRequestURI(), request.getMethod(), request.getHeader("mode"), elapseTime});
                } else {
                    log.info("URL load completed [url :{}, method:{}, mode:{}, elapseTime:{}]", new Object[]{request.getRequestURI(), request.getMethod(), request.getHeader("mode"), elapseTime});
                }
            } else {
                log.info("URL load completed [url :{}, method:{}, mode:{}]", new Object[]{request.getRequestURI(), request.getMethod(), request.getHeader("mode")});
            }
        }
    }
}

