/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api.controller;

import com.google.gson.Gson;
import com.humuson.tms.api.controller.BaseApiController;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.model.BaseApiInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.vo.AppUserApiInfo;
import com.humuson.tms.service.api.AppUserApiService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AppUserApiController
extends BaseApiController {
    public static final Locale DEFAULT_LOCALE = Locale.KOREAN;
    private static final Logger logger = LoggerFactory.getLogger(AppUserApiController.class);
    public static final int OPTION_SELECT_APP_USER = 1;
    @Autowired
    private AppUserApiService appUserApiService;
    @Autowired
    private Gson gson;

    @RequestMapping(value={"/api/apps/{appKey}/user"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectAll(@PathVariable(value="appKey") String appKey, ModelMap model, @RequestParam Map<String, String> params) {
        BaseApiInfo baseApiInfo = new BaseApiInfo(appKey, "selectAll()");
        return this.getResponseEntity(baseApiInfo, params, 1, logger);
    }

    @RequestMapping(value={"/api/apps/{appKey}/user/{custId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectByCustId(@PathVariable(value="appKey") String appKey, @PathVariable(value="custId") String custId, ModelMap model, @RequestParam Map<String, String> params) {
        BaseApiInfo baseApiInfo = new BaseApiInfo(appKey, "selectByCustId()");
        params.put("custId", custId);
        return this.getResponseEntity(baseApiInfo, params, 1, logger);
    }

    @Override
    public String process(BaseApiInfo baseApiInfo, Map<String, String> params, int option) throws Exception {
        String result = "";
        switch (option) {
            case 1: {
                List<AppUserApiInfo> appUserList = this.appUserApiService.selectAppUser(baseApiInfo.getAppApiInfo(), new AppUserApiInfo(baseApiInfo.getCustId()), new PageInfo(baseApiInfo.getPageToken(), baseApiInfo.getMaxResults()));
                result = this.gson.toJson(appUserList, ArrayList.class);
                break;
            }
        }
        return result;
    }

    @Override
    public void setRequiredValue(BaseApiInfo baseApiInfo, Map<String, String> params) throws Exception {
        super.setRequiredValue(baseApiInfo, params);
        String custId = params.get("custId");
        if (!StringUtils.isEmpty((CharSequence)custId)) {
            baseApiInfo.setCustId(custId);
        }
    }

    @Override
    public String pagingProcess(BaseApiInfo baseApiInfo, Map<String, String> params, int option) throws Exception {
        return null;
    }
}

