/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api.controller;

import com.google.gson.Gson;
import com.humuson.tms.api.controller.AnalyticsBaseController;
import com.humuson.tms.common.util.DateConverter;
import com.humuson.tms.model.BaseApiInfo;
import com.humuson.tms.model.PageInfo;
import com.humuson.tms.model.PeriodInfo;
import com.humuson.tms.model.analytics.AnalyticsUserApiInfo;
import com.humuson.tms.service.api.AnalyticsUserApiService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AnalyticsUserController
extends AnalyticsBaseController {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsUserController.class);
    public static final Locale DEFAULT_LOCALE = Locale.KOREAN;
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsUserController.class);
    public static final int OPTION_SELECT_DEFAULT = 1;
    public static final int OPTION_SELECT_TOTAL = 2;
    public static final int OPTION_SELECT_LIST = 3;
    @Autowired
    private AnalyticsUserApiService analyticsUserApiService;
    @Autowired
    private Gson gson;

    @RequestMapping(value={"/api/apps/{appGrpId}/analytics/user"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectAll(@PathVariable(value="appGrpId") String appGrpId, ModelMap model, @RequestParam Map<String, String> params) {
        String startDate = DateConverter.addCurrentDays((int)-7);
        String endDate = DateConverter.getCurrentDate((String)"yyyyMMdd");
        return this.selectAll(appGrpId, startDate, endDate, model, params);
    }

    @RequestMapping(value={"/api/apps/{appGrpId}/analytics/user/{startDate}/{endDate}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectAll(@PathVariable(value="appGrpId") String appGrpId, @PathVariable(value="startDate") String startDate, @PathVariable(value="endDate") String endDate, ModelMap model, @RequestParam Map<String, String> params) {
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        BaseApiInfo baseApiInfo = new BaseApiInfo(appGrpId, "A", "selectAll()");
        return this.getResponseEntity(baseApiInfo, params, 1, logger);
    }

    @RequestMapping(value={"/api/apps/{appGrpId}/analytics/user/total/{startDate}/{endDate}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectTotal(@PathVariable(value="appGrpId") String appGrpId, @PathVariable(value="startDate") String startDate, @PathVariable(value="endDate") String endDate, ModelMap model, @RequestParam Map<String, String> params) {
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        BaseApiInfo baseApiInfo = new BaseApiInfo(appGrpId, "A", "selectAll()");
        return this.getResponseEntity(baseApiInfo, params, 2, logger);
    }

    @RequestMapping(value={"/api/apps/{appGrpId}/analytics/user/list/{startDate}/{endDate}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    public ResponseEntity<String> selectList(@PathVariable(value="appGrpId") String appGrpId, @PathVariable(value="startDate") String startDate, @PathVariable(value="endDate") String endDate, ModelMap model, @RequestParam Map<String, String> params) {
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        BaseApiInfo baseApiInfo = new BaseApiInfo(appGrpId, "A", "selectAll()");
        return this.getResponseEntity(baseApiInfo, params, 3, logger);
    }

    @Override
    public String process(BaseApiInfo baseApiInfo, Map<String, String> params, int option) throws Exception {
        String result = "";
        switch (option) {
            case 1: {
                List<AnalyticsUserApiInfo> tList = this.selectUserData(baseApiInfo, params, 2);
                List<AnalyticsUserApiInfo> lList = this.selectUserData(baseApiInfo, params, 3);
                JSONObject obj = new JSONObject();
                obj.put((Object)"total", (Object)this.gson.toJson(tList, ArrayList.class));
                obj.put((Object)"list", (Object)this.makeUserList(lList));
                result = obj.toString();
                break;
            }
            case 2: {
                List<AnalyticsUserApiInfo> tList = this.selectUserData(baseApiInfo, params, 2);
                result = this.gson.toJson(tList, ArrayList.class);
                break;
            }
            case 3: {
                List<AnalyticsUserApiInfo> lList = this.selectUserData(baseApiInfo, params, 3);
                result = this.makeUserList(lList).toString();
                break;
            }
        }
        return result;
    }

    @Override
    public void setRequiredValue(BaseApiInfo baseApiInfo, Map<String, String> params) throws Exception {
        super.setRequiredValue(baseApiInfo, params);
        String startDate = params.get("startDate");
        String endDate = params.get("endDate");
        if (startDate == null || "".equals(startDate) || endDate == null || "".equals(endDate)) {
            params.put("startDate", DateConverter.addCurrentDays((int)-7));
            params.put("endDate", DateConverter.getCurrentDate((String)"yyyyMMdd"));
        }
    }

    protected List<AnalyticsUserApiInfo> selectUserData(BaseApiInfo baseApiInfo, Map<String, String> params, int option) {
        String startDate = params.get("startDate");
        String endDate = params.get("endDate");
        PeriodInfo pi = new PeriodInfo();
        if (startDate != null && endDate != null) {
            pi.setStartDate(startDate);
            pi.setEndDate(endDate);
        }
        List<AnalyticsUserApiInfo> resultList = null;
        switch (option) {
            case 2: {
                resultList = this.analyticsUserApiService.selectTotal(Integer.parseInt(baseApiInfo.getChannelId()), pi, new PageInfo(baseApiInfo.getPageToken(), baseApiInfo.getMaxResults()));
                break;
            }
            case 3: {
                resultList = this.analyticsUserApiService.selectList(Integer.parseInt(baseApiInfo.getChannelId()), pi, new PageInfo(baseApiInfo.getPageToken(), baseApiInfo.getMaxResults()));
                break;
            }
        }
        return resultList;
    }

    private JSONObject makeUserList(List<AnalyticsUserApiInfo> lList) {
        JSONObject obj = new JSONObject();
        ArrayList<String> appVerList = new ArrayList<String>();
        ArrayList dailyListTotal = new ArrayList();
        Locale thisLocale = this.getLocale();
        appVerList.add(this.messagesource.getMessage("message.analytics.dates", null, thisLocale));
        appVerList.add(this.messagesource.getMessage("message.analytics.user.uniqueUser", null, thisLocale));
        appVerList.add(this.messagesource.getMessage("message.analytics.user.newUser", null, thisLocale));
        appVerList.add(this.messagesource.getMessage("message.analytics.user.retainedUser", null, thisLocale));
        for (int i = 0; i < lList.size(); ++i) {
            ArrayList<String> dailyList = new ArrayList<String>();
            dailyList.add(lList.get(i).getWorkday());
            dailyList.add("" + lList.get(i).getUqSessCnt());
            dailyList.add("" + lList.get(i).getNewSessCnt());
            dailyList.add("" + lList.get(i).getRtSessCnt());
            dailyListTotal.add(dailyList);
        }
        obj.put((Object)"Header", appVerList);
        obj.put((Object)"Data", dailyListTotal);
        return obj;
    }
}

